/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.RootWindowNode;
import com.android.uiautomator.tree.UiNode;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;

public class UiAutomatorNodeHelper {
    public static int getRotation(BasicTreeNode root) {
        if (!(root instanceof RootWindowNode)) {
            return 0;
        }
        return ((RootWindowNode)root).getRotation();
    }

    public static LinkedHashMap<BasicTreeNode, Integer> createElementLevelMap(BasicTreeNode root) {
        LinkedHashMap elementLevels = Maps.newLinkedHashMap();
        UiAutomatorNodeHelper.populateElementLevels(root, 0, elementLevels);
        return elementLevels;
    }

    private static void populateElementLevels(BasicTreeNode currentElement, int currentLevel, Map<BasicTreeNode, Integer> elementLevels) {
        if (currentElement == null) {
            return;
        }
        if (!(currentElement instanceof RootWindowNode)) {
            elementLevels.put(currentElement, currentLevel);
        }
        for (BasicTreeNode child : currentElement.getChildren()) {
            UiAutomatorNodeHelper.populateElementLevels(child, currentLevel + 1, elementLevels);
        }
    }

    public static boolean isTextView(BasicTreeNode node) {
        String className = UiAutomatorNodeHelper.getClassName(node);
        return className.equals("android.widget.TextView") || className.equals("android.widget.EditText");
    }

    public static String getClassName(BasicTreeNode node) {
        return UiAutomatorNodeHelper.getAttribute(node, "class");
    }

    public static String getResourceId(BasicTreeNode node) {
        return UiAutomatorNodeHelper.getAttribute(node, "resource-id");
    }

    public static String getText(BasicTreeNode node) {
        return UiAutomatorNodeHelper.getAttribute(node, "text");
    }

    public static String getContentDescription(BasicTreeNode node) {
        return UiAutomatorNodeHelper.getAttribute(node, "content-desc");
    }

    public static int getViewGroupChildPosition(BasicTreeNode node) {
        try {
            return Integer.parseInt(UiAutomatorNodeHelper.getAttribute(node, "index"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getAppPackageName(BasicTreeNode root) {
        if (root.getChildCount() > 0) {
            return UiAutomatorNodeHelper.getAttribute(root.getChildren()[0], "package");
        }
        return "";
    }

    private static String getAttribute(BasicTreeNode node, String attributeName) {
        if (node instanceof UiNode) {
            return ((UiNode)node).getAttribute(attributeName);
        }
        return "";
    }
}

