/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/google/urlassistant/UrlAssistantToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createSidePanelContent", "logV2PanelOpenEvent", "url-assistant"})
public final class UrlAssistantToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(toolWindow, this, project){
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ UrlAssistantToolWindowFactory this$0;
            final /* synthetic */ Project $project;
            {
                this.$toolWindow = $toolWindow;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void toolWindowShown(ToolWindow shownToolWindow) {
                Intrinsics.checkNotNullParameter((Object)shownToolWindow, (String)"shownToolWindow");
                if (this.$toolWindow == shownToolWindow && this.$toolWindow.getContentManager().isEmpty()) {
                    UrlAssistantToolWindowFactory.access$createSidePanelContent(this.this$0, this.$project, shownToolWindow);
                }
            }

            public void stateChanged(ToolWindowManager toolWindowManager, ToolWindow toolWindowChanged, ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                Intrinsics.checkNotNullParameter((Object)toolWindowChanged, (String)"toolWindowChanged");
                Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
                if (this.$toolWindow == toolWindowChanged && changeType == ToolWindowManagerListener.ToolWindowManagerEventType.HideToolWindow) {
                    this.$toolWindow.getContentManager().removeAllContents(true);
                }
            }
        });
    }

    private final void createSidePanelContent(Project project, ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.getInstance();
        this.logV2PanelOpenEvent(project);
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        Content content = contentFactory.createContent((JComponent)new UrlAssistantSidePanel(project, disposable), "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        toolWindow.getContentManager().addContent(content2);
    }

    private final void logV2PanelOpenEvent(Project project) {
        UsageTrackerUtils.INSTANCE.log(project, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)UrlAssistantToolWindowFactory::logV2PanelOpenEvent$lambda$0));
    }

    private static final AppLinksAssistantEvent.Builder logV2PanelOpenEvent$lambda$0(AppLinksAssistantEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppLinksAssistantEvent.Builder builder = it.setEventSource(AppLinksAssistantEvent.EventSource.OVERVIEW_TABLE).setEventState(AppLinksAssistantEvent.EventState.OPENED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventState(...)");
        return builder;
    }

    public static final /* synthetic */ void access$createSidePanelContent(UrlAssistantToolWindowFactory $this, Project project, ToolWindow toolWindow) {
        $this.createSidePanelContent(project, toolWindow);
    }
}

