/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.grpc;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.netty.GrpcSslContexts;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.io.netty.handler.ssl.SslContext;
import com.google.urlassistant.datalayer.grpc.FakeManagedChannelForTests;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "getChannel", "()Lcom/android/tools/idea/io/grpc/ManagedChannel;", "createGrpcChannel", "dispose", "", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nDeeplinkAssistantChannelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeeplinkAssistantChannelService.kt\ncom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,82:1\n73#2:83\n*S KotlinDebug\n*F\n+ 1 DeeplinkAssistantChannelService.kt\ncom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService\n*L\n38#1:83\n*E\n"})
public final class DeeplinkAssistantChannelService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ManagedChannel channel;
    @NotNull
    private static final Logger LOG;
    private static final String address;

    public DeeplinkAssistantChannelService() {
        boolean $i$f$isUnitTestMode = false;
        this.channel = ApplicationManager.getApplication().isUnitTestMode() ? (ManagedChannel)new FakeManagedChannelForTests() : this.createGrpcChannel();
    }

    @NotNull
    public final ManagedChannel getChannel() {
        return this.channel;
    }

    private final ManagedChannel createGrpcChannel() {
        NettyChannelBuilder nettyChannelBuilder;
        SslContext sslContext = GrpcSslContexts.forClient().trustManager((TrustManager)ConfirmingTrustManager.createForStorage((String)CertificateManager.DEFAULT_PATH, (String)"changeit")).build();
        NettyChannelBuilder $this$createGrpcChannel_u24lambda_u240 = nettyChannelBuilder = NettyChannelBuilder.forTarget((String)address).sslContext(sslContext);
        boolean bl = false;
        $this$createGrpcChannel_u24lambda_u240.useTransportSecurity();
        $this$createGrpcChannel_u24lambda_u240.maxInboundMessageSize(0x100000);
        ManagedChannel newChannel = nettyChannelBuilder.build();
        LOG.info("Connected to deeplink assistant gRPC server at " + address);
        Intrinsics.checkNotNull((Object)newChannel);
        return newChannel;
    }

    public void dispose() {
        try {
            this.channel.shutdownNow();
            this.channel.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOG.info(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    static {
        Logger logger = Logger.getInstance(DeeplinkAssistantChannelService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        address = (String)StudioFlags.DEEPLINKS_GRPC_SERVER.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "address", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

