/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.logcat;

import com.android.tools.idea.logcat.message.LogcatMessage;
import com.google.urlassistant.ui.AppLinkTestingWindow;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppLinksLogLineListener {
    static final String TARGETED_TAG = "ActivityManager";
    static final String RESOLVER_MESSAGE = "android/com.android.internal.app.ResolverActivity";
    static final String ACTIVITY_DISPLAY_MESSAGE = "Displayed";
    private final AppLinkTestingWindow myUiWindow;
    private boolean listening = false;
    private Module myLaunchModule;
    private String myLaunchActivityName = "";

    public AppLinksLogLineListener(@NotNull AppLinkTestingWindow uiWindow) {
        this.myUiWindow = uiWindow;
    }

    public boolean onLogLineReceived(@NotNull LogcatMessage line) {
        if (!this.listening) {
            return false;
        }
        if (!TARGETED_TAG.contains(line.getHeader().getTag())) {
            return true;
        }
        String message = line.getMessage();
        if (message.contains(RESOLVER_MESSAGE)) {
            this.stopListening();
            ApplicationManager.getApplication().invokeLater(() -> this.myUiWindow.setShortResultLabel(UrlAssistantBundle.message("test.url.resolve.error", new Object[0]), false), ModalityState.any());
            return false;
        }
        if (message.startsWith(ACTIVITY_DISPLAY_MESSAGE) && message.contains(this.myLaunchActivityName)) {
            String activityName = this.myLaunchActivityName;
            this.stopListening();
            ApplicationManager.getApplication().invokeLater(() -> this.myUiWindow.setShortResultLabel(UrlAssistantBundle.message("test.url.resolve.success", activityName), true), ModalityState.any());
            return false;
        }
        return true;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void startListening(@NotNull Module module, @NotNull String activityName) {
        if (StringUtil.isEmpty((String)activityName)) {
            return;
        }
        this.listening = true;
        this.myLaunchModule = module;
        this.myLaunchActivityName = activityName;
    }

    public void stopListening() {
        this.listening = false;
        this.myLaunchModule = null;
        this.myLaunchActivityName = "";
    }

    @Nullable
    public Module getLaunchModule() {
        return this.myLaunchModule;
    }
}

