/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.ui.UrlAssistantWindow;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class AddUrlDialogLegacy
extends DialogWrapper {
    private JPanel myPane;
    private JBTextField myPathTextField;
    private UrlAssistantWindow myUrlAssistantWindow;
    private JComboBox<ActivityData> myActivityListComboBox;
    private JComboBox<PathType> myPathTypeComboBox;
    private ActivityComboBoxModel myActivityComboBoxModel;
    private JBRadioButton myHttpRadioButton;
    private JBRadioButton myHttpsRadioButton;
    private JPanel myBasicPanel;
    private JPanel myAdvancedPanel;
    private JBTextField myFullUrlTextField;
    private JBTextField myHostTextField;
    private JBTextField myPortTextField;
    private JPanel myCardPanel;
    private JBLabel myTitleTextField;
    private JBTextField myMimeTypeTextField;
    private JBLabel myMimeTypeLabel;
    private HyperlinkLabel myHowItWorksHyperLink;
    private JBTextField myOrderField;
    private JBLabel myOrderLabel;
    private ActivityData myActivityData;
    private final Project myProject;
    private PathType myOldPathType;
    private SwitchAdvancedAction mySwitchAdvancedAction;
    private XmlTag myCurrentIntentFilter;
    private int myCurrentRow = -1;
    private boolean myIsEdit = false;
    private boolean myIsAdvancedDialog = false;
    private final boolean mySupportOrder;
    private static FullUrl ourPreviousUrl = null;
    KeyAdapter myKeyAdapter;

    private static Logger getLog() {
        return Logger.getInstance(AddUrlDialogLegacy.class);
    }

    public AddUrlDialogLegacy(@NotNull Project project, @NotNull UrlAssistantWindow urlAssistantWindow, @NotNull List<Activity> activityList) {
        super(project);
        this.$$$setupUI$$$();
        this.myKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AddUrlDialogLegacy.this.setOKActionEnabled(StringUtil.isNotEmpty((String)((JTextField)e.getComponent()).getText()));
            }
        };
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myPane);
        this.init();
        this.myProject = project;
        this.myUrlAssistantWindow = urlAssistantWindow;
        this.mySupportOrder = Order.isSupportedFor(project);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myHttpRadioButton);
        group.add((AbstractButton)this.myHttpsRadioButton);
        this.myHttpRadioButton.setSelected(true);
        this.setTitle(UrlAssistantBundle.message("add.url.dialog.title", new Object[0]));
        this.setUpComboBox(activityList);
        if (ourPreviousUrl != null) {
            this.populateUrl(ourPreviousUrl);
        }
        this.myFullUrlTextField.addKeyListener((KeyListener)this.myKeyAdapter);
        this.myFullUrlTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.host.hint", new Object[0]));
        this.myFullUrlTextField.setText("https://");
        this.myHostTextField.addKeyListener((KeyListener)this.myKeyAdapter);
        this.myHostTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.host.hint", new Object[0]));
        this.myMimeTypeTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.mimetype.hint", new Object[0]));
        this.myHowItWorksHyperLink.setHyperlinkText(UrlAssistantBundle.message("add.url.how.it.works.text", new Object[0]));
        this.myHowItWorksHyperLink.setHyperlinkTarget(UrlAssistantBundle.message("add.url.how.it.works.url", new Object[0]));
        this.myHowItWorksHyperLink.setBackground(this.myPane.getBackground());
        this.myPathTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (AddUrlDialogLegacy.this.myPathTextField.getText().isEmpty()) {
                    AddUrlDialogLegacy.this.myPathTextField.setText("/");
                }
                AddUrlDialogLegacy.this.myPathTextField.removeFocusListener((FocusListener)this);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setMode();
        this.validate();
    }

    public JComboBox<PathType> getPathTypeComboBox() {
        return this.myPathTypeComboBox;
    }

    public JBTextField getPathTextField() {
        return this.myPathTextField;
    }

    public JComboBox<ActivityData> getActivityListComboBox() {
        return this.myActivityListComboBox;
    }

    public void setValue(@NotNull Order order, @NotNull FullUrl fullUrl, @NotNull PathData path, @Nullable ActivityData activityData, int currentRow) {
        this.populateUrl(fullUrl);
        this.myFullUrlTextField.setText(fullUrl.toString());
        this.myOrderField.setText(order.getInteger() != null ? order.getInteger().toString() : "");
        this.myOldPathType = path.getPathType();
        String pathValue = path.getPathValue();
        if (StringUtil.isNotEmpty((String)pathValue)) {
            this.myPathTextField.setText(pathValue);
        }
        this.myPathTypeComboBox.setSelectedItem((Object)this.myOldPathType);
        if ((order.getInteger() != null || fullUrl.getPort() >= 0 || StringUtil.isNotEmpty((String)fullUrl.getMimeType())) && !this.myIsAdvancedDialog) {
            this.mySwitchAdvancedAction.doAction(null);
        }
        if (activityData != null) {
            this.myIsEdit = true;
            this.myCurrentRow = currentRow;
            this.myActivityData = activityData;
            this.myCurrentIntentFilter = activityData.getIntentFilterTag();
            for (int i = 0; i < this.myActivityListComboBox.getItemCount(); ++i) {
                ActivityData theActivityData = this.myActivityComboBoxModel.getElementAt(i);
                if (theActivityData == null || theActivityData.getModule() != activityData.getModule() || !theActivityData.getActivityName().equals(activityData.getActivityName())) continue;
                this.myActivityListComboBox.setSelectedIndex(i);
                break;
            }
        }
        if (this.myIsAdvancedDialog) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_ADVANCED_DIALOG, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
        }
    }

    public void setValue(@NotNull DeepLinks.DeepLink deepLink, int currentRow) {
        this.setValue(deepLink.getOrder(), deepLink.getUrl(), deepLink.getPath(), deepLink.getActivityData(), currentRow);
    }

    private void populateUrl(@NotNull FullUrl fullUrl) {
        this.myHttpRadioButton.setSelected("http".equals(fullUrl.getScheme()));
        this.myFullUrlTextField.setText(fullUrl.toString());
        this.myPortTextField.setText(fullUrl.getPortText());
        this.myHostTextField.setText(fullUrl.getHost());
        this.myMimeTypeTextField.setText(fullUrl.getMimeType());
        this.setOKActionEnabled(StringUtil.isNotEmpty((String)fullUrl.getHost()));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        return new Action[]{this.getCancelAction()};
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.mySwitchAdvancedAction, this.getOKAction()};
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.mySwitchAdvancedAction = new SwitchAdvancedAction();
    }

    private void setMode() {
        CardLayout cl = (CardLayout)this.myCardPanel.getLayout();
        if (this.myIsAdvancedDialog) {
            cl.last(this.myCardPanel);
        } else {
            cl.first(this.myCardPanel);
        }
        this.myMimeTypeTextField.setVisible(this.myIsAdvancedDialog);
        this.myMimeTypeLabel.setVisible(this.myIsAdvancedDialog);
        this.myOrderLabel.setVisible(this.mySupportOrder && this.myIsAdvancedDialog);
        this.myOrderField.setVisible(this.mySupportOrder && this.myIsAdvancedDialog);
        try {
            if (this.myIsAdvancedDialog) {
                FullUrl fullUrl = new FullUrl(this.myFullUrlTextField.getText());
                if ("http".equals(fullUrl.getScheme())) {
                    this.myHttpRadioButton.setSelected(true);
                } else {
                    this.myHttpsRadioButton.setSelected(true);
                }
                this.myHostTextField.setText(fullUrl.getHost());
                this.myPortTextField.setText(fullUrl.getPortText());
            } else {
                String scheme = this.myHttpRadioButton.isSelected() ? "http" : "https";
                String fullUrl = scheme + "://" + this.myHostTextField.getText() + (String)(StringUtil.isEmpty((String)this.myPortTextField.getText()) ? "" : ":" + this.myPortTextField.getText());
                this.myFullUrlTextField.setText(fullUrl);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myIsAdvancedDialog ? this.myHostTextField : this.myFullUrlTextField;
    }

    private void setUpComboBox(List<Activity> activityList) {
        this.myActivityComboBoxModel = new ActivityComboBoxModel(activityList);
        this.myActivityListComboBox.setModel(this.myActivityComboBoxModel);
        this.myActivityListComboBox.setRenderer((ListCellRenderer<ActivityData>)((Object)new MyActivityListRender()));
        this.myPathTypeComboBox.setModel(new DefaultComboBoxModel<PathType>(PathType.values()));
        this.myPathTypeComboBox.setSelectedItem((Object)PathType.PathPattern);
        this.myPathTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.path.hint", new Object[0]));
        this.myPathTypeComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                PathType item = (PathType)((Object)((Object)e.getItem()));
                String messageKey = item.equals((Object)PathType.Path) ? "add.url.path.hint" : (item.equals((Object)PathType.PathPrefix) ? "add.url.path.prefix.hint" : "add.url.path.pattern.hint");
                this.myPathTextField.getEmptyText().setText(UrlAssistantBundle.message(messageKey, new Object[0]));
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    public boolean isInputValid(@NotNull FullUrl fullUrl) {
        boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
        if ((this.myPathTypeComboBox.getSelectedItem() == PathType.Path || this.myPathTypeComboBox.getSelectedItem() == PathType.PathPrefix) && StringUtil.isNotEmpty((String)this.myPathTextField.getText()) && !StringUtil.startsWith((CharSequence)this.myPathTextField.getText(), (CharSequence)"/")) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.path.start.with.slash", this.myPathTypeComboBox.getSelectedItem().toString()));
            }
            return false;
        }
        if (!fullUrl.getScheme().equals("http") && !fullUrl.getScheme().equals("https")) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.scheme", new Object[0]));
            }
            return false;
        }
        if (StringUtil.isEmpty((String)fullUrl.getHost())) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.host", new Object[0]));
            }
            return false;
        }
        if (fullUrl.isPortSet() && (fullUrl.getPort() < 0 || fullUrl.getPort() > 65535)) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.port", new Object[0]));
            }
            return false;
        }
        try {
            if (this.mySupportOrder && StringUtil.isNotEmpty((String)this.myOrderField.getText())) {
                Integer.parseInt(this.myOrderField.getText());
            }
        }
        catch (NumberFormatException e) {
            this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.order", new Object[0]));
            return false;
        }
        return true;
    }

    protected void doOKAction() {
        try {
            if (this.doAddOrEditUrl()) {
                this.close(0);
            }
        }
        catch (MalformedURLException e) {
            this.showInvalidInputMessage(UrlAssistantBundle.message("url.malformed", new Object[0]));
        }
        catch (Exception e2) {
            AddUrlDialogLegacy.getLog().debug(e2.getMessage());
            this.close(1);
        }
    }

    public boolean doAddOrEditUrl() throws MalformedURLException {
        Object fullUrlString;
        if (this.myIsAdvancedDialog) {
            String scheme = this.myHttpRadioButton.isSelected() ? "http" : "https";
            fullUrlString = scheme + "://" + this.myHostTextField.getText() + ":" + this.myPortTextField.getText();
        } else {
            fullUrlString = this.myFullUrlTextField.getText();
        }
        FullUrl fullUrl = new FullUrl((String)fullUrlString);
        if (this.myIsAdvancedDialog) {
            fullUrl.setMimeType(this.myMimeTypeTextField.getText());
        }
        if (!this.isInputValid(fullUrl)) {
            return false;
        }
        Order order = new Order(this.myIsAdvancedDialog && StringUtil.isNotEmpty((String)this.myOrderField.getText()) ? Integer.valueOf(this.myOrderField.getText()) : null);
        ourPreviousUrl = fullUrl;
        PathData pathData = new PathData((PathType)((Object)this.myPathTypeComboBox.getSelectedItem()), this.myPathTextField.getText());
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            int rowIndex;
            JBTable table = this.myUrlAssistantWindow.getTable();
            if (this.myIsEdit) {
                this.editIntentFilter(fullUrl, pathData, order);
                rowIndex = this.myUrlAssistantWindow.getTableModel().updateRow(order, fullUrl, pathData, this.myActivityData, this.mySupportOrder, this.myCurrentRow);
            } else {
                this.myActivityData = this.myActivityComboBoxModel.getSelectedItem();
                this.createIntentFilter(fullUrl, this.myActivityData, pathData, order);
                rowIndex = this.myUrlAssistantWindow.getTableModel().addRow(order, fullUrl, pathData, this.myActivityData, this.mySupportOrder);
            }
            table.setRowSelectionInterval(rowIndex, rowIndex);
            this.myUrlAssistantWindow.handleTableSelection();
        });
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
        return true;
    }

    private void showInvalidInputMessage(@NotNull String message) {
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)UrlAssistantBundle.message("add.url.invalid.input.dialog.title", new Object[0]), null);
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
    }

    private void createIntentFilter(@NotNull FullUrl fullUrl, @NotNull ActivityData activityData, @NotNull PathData pathData, @NotNull Order order) {
        XmlTag root;
        XmlFile manifestPsiFile = ManifestUtils.getAndroidManifestPsi(activityData.getModule());
        if (manifestPsiFile != null && (root = manifestPsiFile.getRootTag()) != null) {
            List<XmlTag> activities = ManifestUtils.searchXmlTagsByName(root, "activity");
            for (XmlTag activityTag : activities) {
                String activityName = activityTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (activityName == null || !activityName.equals(activityData.getActivityName())) continue;
                this.myActivityData.setIntentFilterTag(UrlAssistUtils.createDeepLinkIntentFilter(order, activityTag, fullUrl, pathData));
                UsageTrackerUtils.INSTANCE.log(this.myProject, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)builder -> {
                    builder.setEventSource(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG).setEventState(AppLinksAssistantEvent.EventState.COMPLETED).setLinksRecord(UsageTrackerUtils.INSTANCE.createLinksRecord(fullUrl.getScheme(), fullUrl.getHost(), pathData.getPathValue(), pathData.getPathType().asLinksRecordPathType()).setInteractionType(AppLinksAssistantEvent.LinksRecord.InteractionType.NEW_LINK_CREATED));
                    return builder;
                }));
                break;
            }
        }
        this.myUrlAssistantWindow.updateAndroidManifestPreview(this.myActivityData.getModule());
    }

    private void editIntentFilter(@NotNull FullUrl fullUrl, @NotNull PathData pathData, @NotNull Order order) {
        String oldActivityName = this.myActivityData.getActivityName();
        this.myActivityData = this.myActivityComboBoxModel.getSelectedItem();
        if (!oldActivityName.equals(this.myActivityData.getActivityName())) {
            this.myCurrentIntentFilter.delete();
            this.createIntentFilter(fullUrl, this.myActivityData, pathData, order);
        } else {
            this.myCurrentIntentFilter.delete();
            this.createIntentFilter(fullUrl, this.myActivityData, pathData, order);
            this.myUrlAssistantWindow.updateAndroidManifestPreview(this.myActivityData.getModule());
        }
    }

    protected void dispose() {
        super.dispose();
        this.myUrlAssistantWindow = null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBTextField jBTextField;
        HyperlinkLabel hyperlinkLabel;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JBLabel jBLabel2;
        JBTextField jBTextField4;
        JBTextField jBTextField5;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        JBTextField jBTextField6;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JPanel jPanel4;
        this.myPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(11, 5, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel4.setMinimumSize(new Dimension(650, -1));
        jPanel4.setPreferredSize(new Dimension(550, 280));
        JBLabel jBLabel4 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel4.getFont());
        if (font != null) {
            jBLabel4.setFont(font);
        }
        jBLabel4.setText("Activity");
        jPanel4.add((Component)jBLabel4, new GridConstraints(8, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(10, 3, 1, 2, 0, 2, 5, 2, null, null, null));
        this.myTitleTextField = jBLabel3 = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jBLabel3.getFont());
        if (font2 != null) {
            jBLabel3.setFont(font2);
        }
        jBLabel3.setText("Basic URL Mapping");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("You can add or edit your URL mapping here");
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myCardPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 5, 0, 3, 7, 0, null, null, null));
        this.myBasicPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, "Card1");
        ((CardLayout)jPanel3.getLayout()).show(jPanel3, "Card1");
        JBLabel jBLabel6 = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jBLabel6.getFont());
        if (font3 != null) {
            jBLabel6.setFont(font3);
        }
        jBLabel6.setText("Host");
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFullUrlTextField = jBTextField6 = new JBTextField();
        jPanel2.add((Component)jBTextField6, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myAdvancedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(100, 57));
        jPanel.setPreferredSize(new Dimension(650, 57));
        jPanel3.add((Component)jPanel, "Card2");
        this.myHttpRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("http");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 1, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        Font font4 = this.$$$getFont$$$(null, 1, -1, jBLabel7.getFont());
        if (font4 != null) {
            jBLabel7.setFont(font4);
        }
        jBLabel7.setText("Scheme");
        jPanel.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 2, 8, 2, 0, 0, null, new Dimension(125, 15), null));
        JBLabel jBLabel8 = new JBLabel();
        Font font5 = this.$$$getFont$$$(null, 1, -1, jBLabel8.getFont());
        if (font5 != null) {
            jBLabel8.setFont(font5);
        }
        jBLabel8.setText("Host");
        jPanel.add((Component)jBLabel8, new GridConstraints(0, 2, 1, 1, 8, 0, 7, 0, null, new Dimension(-1, 15), null));
        this.myHttpsRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("https");
        jPanel.add((Component)jBRadioButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 1, null, null, null));
        this.myPortTextField = jBTextField5 = new JBTextField();
        jPanel.add((Component)jBTextField5, new GridConstraints(1, 3, 1, 1, 4, 0, 0, 0, null, new Dimension(80, -1), null));
        JBLabel jBLabel9 = new JBLabel();
        Font font6 = this.$$$getFont$$$(null, 1, -1, jBLabel9.getFont());
        if (font6 != null) {
            jBLabel9.setFont(font6);
        }
        jBLabel9.setText("Port");
        jPanel.add((Component)jBLabel9, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jBTextField4 = new JBTextField();
        jPanel.add((Component)jBTextField4, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myActivityListComboBox = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(9, 0, 1, 4, 1, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myMimeTypeLabel = jBLabel2 = new JBLabel();
        Font font7 = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font7 != null) {
            jBLabel2.setFont(font7);
        }
        jBLabel2.setText("Mime Type");
        jPanel4.add((Component)jBLabel2, new GridConstraints(8, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMimeTypeTextField = jBTextField3 = new JBTextField();
        jPanel4.add((Component)jBTextField3, new GridConstraints(9, 4, 1, 1, 1, 1, 6, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(6, 2, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myPathTextField = jBTextField2 = new JBTextField();
        jPanel5.add((Component)jBTextField2, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        this.myHowItWorksHyperLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setFocusable(false);
        Font font8 = UIManager.getFont("Label.font");
        if (font8 != null) {
            hyperlinkLabel.setFont(font8);
        }
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myPathTypeComboBox = jComboBox2;
        jPanel4.add(jComboBox2, new GridConstraints(6, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myOrderField = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel10 = new JBLabel();
        Font font9 = this.$$$getFont$$$(null, 1, -1, jBLabel10.getFont());
        if (font9 != null) {
            jBLabel10.setFont(font9);
        }
        jBLabel10.setText("Path");
        jPanel4.add((Component)jBLabel10, new GridConstraints(5, 1, 1, 3, 8, 0, 0, 0, null, new Dimension(24, 15), null));
        this.myOrderLabel = jBLabel = new JBLabel();
        Font font10 = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font10 != null) {
            jBLabel.setFont(font10);
        }
        jBLabel.setText("Order");
        jPanel4.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 4, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        Spacer spacer5 = new Spacer();
        jPanel4.add((Component)spacer5, new GridConstraints(7, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel4.add((Component)spacer6, new GridConstraints(7, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel4.add((Component)spacer7, new GridConstraints(7, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    class SwitchAdvancedAction
    extends DialogWrapper.DialogWrapperAction {
        public SwitchAdvancedAction() {
            super((DialogWrapper)AddUrlDialogLegacy.this, UrlAssistantBundle.message("add.url.dialog.show.advanced", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            AddUrlDialogLegacy.this.myIsAdvancedDialog = !AddUrlDialogLegacy.this.myIsAdvancedDialog;
            this.putValue("Name", UrlAssistantBundle.message(AddUrlDialogLegacy.this.myIsAdvancedDialog ? "add.url.dialog.hide.advanced" : "add.url.dialog.show.advanced", new Object[0]));
            AddUrlDialogLegacy.this.setMode();
        }
    }

    static class ActivityComboBoxModel
    implements ComboBoxModel<ActivityData> {
        private final List<ActivityData> myActivityList = new ArrayList<ActivityData>();
        private int selectedIndex = 0;

        public ActivityComboBoxModel(@NotNull List<Activity> activityList) {
            for (Activity activity : activityList) {
                if (activity == null) continue;
                Module mainModule = activity.getModule();
                String activityName = activity.getActivityClass().getStringValue();
                if (mainModule == null || !StringUtil.isNotEmpty((String)activityName)) continue;
                this.myActivityList.add(new ActivityData(ProjectSystemUtil.getModuleSystem((Module)mainModule).getHolderModule(), activityName, null, null));
            }
        }

        @Override
        public void setSelectedItem(@NotNull Object anItem) {
            for (int i = 0; i < this.myActivityList.size(); ++i) {
                if (!this.getElementAt(i).equals(anItem)) continue;
                this.selectedIndex = i;
                return;
            }
        }

        @Override
        public ActivityData getSelectedItem() {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.myActivityList.size()) {
                return this.myActivityList.get(this.selectedIndex);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.myActivityList.size();
        }

        @Override
        public ActivityData getElementAt(int index) {
            if (index >= 0 && index < this.myActivityList.size()) {
                return this.myActivityList.get(index);
            }
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    static class MyActivityListRender
    extends ListCellRendererWrapper<ActivityData> {
        MyActivityListRender() {
        }

        public void customize(JList list, ActivityData value, int index, boolean selected, boolean hasFocus) {
            this.setText(value == null ? "" : value.getHtmlText(selected));
        }
    }
}

