/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.ui.AppLinkOverviewTable;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0013\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/google/urlassistant/ui/AppLinkTableCellButton;", "Ljavax/swing/AbstractButton;", "Ljavax/accessibility/Accessible;", "Lcom/intellij/openapi/Disposable;", "label", "Lcom/intellij/ui/components/JBLabel;", "table", "Lcom/google/urlassistant/ui/AppLinkOverviewTable;", "isSelected", "", "hasFocus", "<init>", "(Lcom/intellij/ui/components/JBLabel;Lcom/google/urlassistant/ui/AppLinkOverviewTable;ZZ)V", "getLabel", "()Lcom/intellij/ui/components/JBLabel;", "buttonAccessibleContext", "Lcom/google/urlassistant/ui/AppLinkTableCellButton$AppLinkTableCellButtonAccessibleContext;", "updateAppearance", "", "selected", "focused", "getText", "", "setText", "text", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "dispose", "AppLinkTableCellButtonAccessibleContext", "url-assistant"})
class AppLinkTableCellButton
extends AbstractButton
implements Accessible,
Disposable {
    @NotNull
    private final JBLabel label;
    @NotNull
    private final AppLinkTableCellButtonAccessibleContext buttonAccessibleContext;

    public AppLinkTableCellButton(@NotNull JBLabel label, @NotNull AppLinkOverviewTable table, boolean isSelected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.label = label;
        this.buttonAccessibleContext = new AppLinkTableCellButtonAccessibleContext();
        Disposer.register((Disposable)table, (Disposable)this);
        this.setModel(new DefaultButtonModel());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.label, UiUtils.createConstraintsForExpander$default(UiUtils.INSTANCE, 0, 0, 3, null));
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> AppLinkTableCellButton._init_$lambda$0(this, isSelected, hasFocus, arg_0));
        this.updateAppearance(isSelected, hasFocus);
    }

    @NotNull
    public final JBLabel getLabel() {
        return this.label;
    }

    private final void updateAppearance(boolean selected, boolean focused) {
        this.label.setForeground(UIManager.getColor(selected ? "Table.selectionForeground" : "Table.foreground"));
        this.label.setBackground(UIManager.getColor(selected ? "Table.selectionBackground" : "Table.background"));
        this.label.setOpaque(true);
        this.label.setBorder(UIManager.getBorder(focused && selected ? "Table.focusSelectedCellHighlightBorder" : (focused ? "Table.focusCellHighlightBorder" : "Table.cellNoFocusBorder")));
        this.setBorder((Border)JBUI.Borders.empty());
        this.setHorizontalAlignment(2);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.label.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    public void setText(@Nullable String text) {
        this.label.setText(text);
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        return this.buttonAccessibleContext;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(AppLinkTableCellButton this$0, boolean $isSelected, boolean $hasFocus, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateAppearance($isSelected, $hasFocus);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/google/urlassistant/ui/AppLinkTableCellButton$AppLinkTableCellButtonAccessibleContext;", "Ljavax/swing/AbstractButton$AccessibleAbstractButton;", "Ljavax/swing/AbstractButton;", "<init>", "(Lcom/google/urlassistant/ui/AppLinkTableCellButton;)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleChildrenCount", "", "url-assistant"})
    private final class AppLinkTableCellButtonAccessibleContext
    extends AbstractButton.AccessibleAbstractButton {
        public AppLinkTableCellButtonAccessibleContext() {
            super(AppLinkTableCellButton.this);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.PUSH_BUTTON;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PUSH_BUTTON");
            return accessibleRole;
        }

        @Override
        @NotNull
        public String getAccessibleName() {
            return AppLinkTableCellButton.this.getText();
        }

        @Override
        @NotNull
        public String getAccessibleDescription() {
            String string = UrlAssistantBundle.message("overview.space.to.view.link.details", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }
    }
}

