/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.util.InsertCodeHandler;
import com.google.urlassistant.util.InsertCodeHandlerFactory;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class InsertCodeDialog
extends DialogWrapper {
    private final Project myProject;
    private final JTextPane myWarningMessage = new JTextPane();
    private final JBPanel myMessagePanel = new JBPanel((LayoutManager)new GridLayoutManager(1, 2));
    private final JPanel myContentPanel = new JBPanel((LayoutManager)new BorderLayout(0, 0));
    private List<ActivityData> myActivities;
    private JList myJList;
    private InsertCodeHandler myInsertCodeHandler;

    private static Logger getLog() {
        return Logger.getInstance(InsertCodeDialog.class);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJList;
    }

    public InsertCodeDialog(@NotNull Project project) {
        super(project, true);
        this.setOKActionEnabled(false);
        this.myProject = project;
        this.myMessagePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        JBLabel iconLabel = new JBLabel();
        iconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myMessagePanel.add((Component)iconLabel, (Object)constraints);
        constraints.setColumn(1);
        this.myWarningMessage.setAlignmentX(0.0f);
        this.myWarningMessage.setBackground(this.myContentPanel.getBackground());
        this.myWarningMessage.setEditable(false);
        this.myMessagePanel.add((Component)this.myWarningMessage, (Object)constraints);
        this.myMessagePanel.setVisible(false);
        this.myContentPanel.setPreferredSize(new Dimension(400, 200));
        this.myContentPanel.add((Component)this.myMessagePanel, "South");
        try {
            this.initializeActivityList((List)ManifestUtils.getAllActivities(ProjectSystemUtil.getAndroidModulesForDisplay((Project)this.myProject).toArray(new Module[0]), true, true, this.myDisposable).get());
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (ExecutionException e) {
            InsertCodeDialog.getLog().error((Throwable)e);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myJList);
        this.myContentPanel.add((Component)scrollPane, "Center");
        this.setTitle(UrlAssistantBundle.message("insert.code.dialog.title", new Object[0]));
        Action okAction = this.getOKAction();
        okAction.putValue("Name", UrlAssistantBundle.message("insert.code.dialog.ok", new Object[0]));
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("Name", UrlAssistantBundle.message("insert.code.dialog.cancel", new Object[0]));
        this.init();
    }

    private void initializeActivityList(List<ActivityData> result) {
        this.myActivities = result;
        AbstractListModel model = new AbstractListModel(){

            @Override
            public int getSize() {
                return InsertCodeDialog.this.myActivities.size();
            }

            @Override
            public Object getElementAt(int i) {
                return InsertCodeDialog.this.myActivities.get(i).getActivityAndModuleName();
            }
        };
        if (this.myActivities.isEmpty()) {
            this.setErrorMessage(UrlAssistantBundle.message("insert.code.dialog.app.link.missing.error", new Object[0]));
        }
        this.myJList = new JBList((ListModel)model);
        this.myJList.setSelectionMode(0);
        this.myJList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.myJList.getSelectedValue() != null) {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.CODE_INSERT_DIALOG_LIST_SELECTION, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
                this.handleListMouseClickEvent(this.myJList.getSelectedIndex());
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (InsertCodeDialog.this.isOKActionEnabled()) {
                    InsertCodeDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myJList);
    }

    private void setErrorMessage(@NotNull String message) {
        this.myWarningMessage.setText(message);
        this.myMessagePanel.setVisible(!message.isBlank());
    }

    private void handleListMouseClickEvent(int index) {
        this.setOKActionEnabled(false);
        ActivityData activityData = this.myActivities.get(index);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            VirtualFile file = activityData.getActivityVirtualFile();
            assert (file != null);
            FileEditorManager.getInstance((Project)this.myProject).openFile(file, true);
        }, ModalityState.any());
        PsiClass activityClass = activityData.getActivityClass();
        assert (activityClass != null);
        this.myInsertCodeHandler = InsertCodeHandlerFactory.create(activityClass);
        InsertCodeHandler.CodeInsertErrorCode code = this.myInsertCodeHandler.shouldInvoke();
        this.setErrorMessage(code.getMessage());
        if (code == InsertCodeHandler.CodeInsertErrorCode.SUCCEED) {
            this.setOKActionEnabled(true);
        } else {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.CODE_INSERT_DIALOG_INSERT_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            this.setOKActionEnabled(false);
        }
    }

    protected void doOKAction() {
        try {
            this.myInsertCodeHandler.invoke();
        }
        finally {
            super.doOKAction();
        }
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)"https://developer.android.com/studio/write/app-link-indexing.html");
    }
}

