/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.db.DalApisConsentStore;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebAssociationMeta;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebCheckSummary;
import com.google.urlassistant.ui.models.ColumnSelectionListener;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 '2\u00020\u0001:\u0002'(B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0014\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010$\u001a\u00020\u001cH\u0016R0\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "Ljavax/swing/table/AbstractTableModel;", "linkInfos", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "value", "getLinkInfos", "()Ljava/util/List;", "setLinkInfos", "(Ljava/util/List;)V", "columnSelectionListeners", "", "Lcom/google/urlassistant/ui/models/ColumnSelectionListener;", "columnOptions", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$AppLinksTableColumnOption;", "getColumnOptions", "selectableColumnOptions", "getSelectableColumnOptions", "addColumnSelectionListener", "", "l", "onColumnSelectionChange", "column", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "getColumnName", "", "modelColumnIndex", "getColumnClass", "Ljava/lang/Class;", "Companion", "AppLinksTableColumnOption", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,595:1\n785#2:596\n796#2:597\n1872#2,2:598\n797#2,2:600\n1874#2:602\n799#2:603\n1863#2,2:604\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n*L\n546#1:596\n546#1:597\n546#1:598,2\n546#1:600,2\n546#1:602\n546#1:603\n553#1:604,2\n*E\n"})
public final class AppLinkOverviewTableModel
extends AbstractTableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<LinkInfo> linkInfos;
    @NotNull
    private final List<ColumnSelectionListener> columnSelectionListeners;
    @NotNull
    private final List<AppLinksTableColumnOption> columnOptions;
    @NotNull
    private final List<AppLinksTableColumnOption> selectableColumnOptions;
    public static final int SCHEME_MODEL_COLUMN_INDEX = 0;
    public static final int HOST_MODEL_COLUMN_INDEX = 1;
    public static final int PATH_MODEL_COLUMN_INDEX = 2;
    public static final int ACTIVITY_MODEL_COLUMN_INDEX = 3;
    public static final int APP_CHECKS_FAILED_MODEL_COLUMN_INDEX = 4;
    public static final int WEB_CHECKS_FAILED_MODEL_COLUMN_INDEX = 5;
    public static final int LINKS_WITH_SAME_DOMAIN_MODEL_COLUMN_INDEX = 6;
    public static final int ARROW_BUTTON_INDEX = 7;

    /*
     * WARNING - void declaration
     */
    public AppLinkOverviewTableModel(@NotNull List<LinkInfo> linkInfos, @NotNull Project project) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Intrinsics.checkNotNullParameter(linkInfos, (String)"linkInfos");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.linkInfos = linkInfos;
        this.columnSelectionListeners = new ArrayList();
        Object object = new AppLinksTableColumnOption[8];
        String string = UrlAssistantBundle.message("overview.column.scheme", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        object[0] = new AppLinksTableColumnOption(string, 0, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string2 = UrlAssistantBundle.message("overview.column.host", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        object[1] = new AppLinksTableColumnOption(string2, 1, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string3 = UrlAssistantBundle.message("overview.column.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        object[2] = new AppLinksTableColumnOption(string3, 2, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string4 = UrlAssistantBundle.message("overview.column.activity.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        object[3] = new AppLinksTableColumnOption(string4, 3, false, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string5 = UrlAssistantBundle.message("overview.column.app.check.failures", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        object[4] = new AppLinksTableColumnOption(string5, 4, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string6 = UrlAssistantBundle.message("overview.column.web.check.failures", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        object[5] = new AppLinksTableColumnOption(string6, 5, DalApisConsentStore.Companion.getInstance(project).isConsented(), (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        String string7 = UrlAssistantBundle.message("overview.column.links.with.same.domain", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        object[6] = new AppLinksTableColumnOption(string7, 6, false, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }));
        object[7] = new AppLinksTableColumnOption("", 7, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)AppLinkOverviewTableModel::columnOptions$lambda$0));
        this.columnOptions = CollectionsKt.listOf((Object[])object);
        object = this.columnOptions;
        AppLinkOverviewTableModel appLinkOverviewTableModel = this;
        boolean $i$f$filterIndexed = false;
        void var5_6 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            AppLinksTableColumnOption cfr_ignored_0 = (AppLinksTableColumnOption)element$iv$iv;
            int idx = index$iv$iv;
            boolean bl2 = false;
            if (!(idx != 7)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        appLinkOverviewTableModel.selectableColumnOptions = (List)destination$iv$iv;
    }

    @NotNull
    public final List<LinkInfo> getLinkInfos() {
        return this.linkInfos;
    }

    public final void setLinkInfos(@NotNull List<LinkInfo> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.linkInfos = value;
        ApplicationManager.getApplication().invokeLater(this::fireTableDataChanged);
    }

    @NotNull
    public final List<AppLinksTableColumnOption> getColumnOptions() {
        return this.columnOptions;
    }

    @NotNull
    public final List<AppLinksTableColumnOption> getSelectableColumnOptions() {
        return this.selectableColumnOptions;
    }

    public final void addColumnSelectionListener(@NotNull ColumnSelectionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.columnSelectionListeners.add(l);
    }

    private final void onColumnSelectionChange(AppLinksTableColumnOption column) {
        Iterable $this$forEach$iv = this.columnSelectionListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColumnSelectionListener it = (ColumnSelectionListener)element$iv;
            boolean bl = false;
            it.onSelectionChange(column);
        }
    }

    @Override
    public int getRowCount() {
        return this.linkInfos.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LinkInfo linkInfo = (LinkInfo)CollectionsKt.getOrNull(this.linkInfos, (int)rowIndex);
        if (linkInfo == null) {
            return null;
        }
        LinkInfo link = linkInfo;
        Object result = switch (columnIndex) {
            case 0 -> link.getSingleLinkDataTagConfig().getScheme();
            case 1 -> link.getSingleLinkDataTagConfig().getRawHost();
            case 2 -> link.getSingleLinkDataTagConfig().getRawPath();
            case 3 -> link.getActivityConfig().getActivityName();
            case 4 -> link.getAppCheckSummary().getTotalFailedIntentFilterChecks();
            case 5 -> {
                WebCheckSummary v2 = link.getWebCheckSummary();
                if (v2 != null) {
                    yield v2.getTotalFailedWebAssociationChecks();
                }
                yield null;
            }
            case 6 -> {
                WebAssociationMeta v3 = link.getWebAssociationMeta();
                if (v3 != null) {
                    yield v3.getTotalAffectedAppLinks();
                }
                yield null;
            }
            case 7 -> link;
            default -> throw new AssertionError(columnIndex);
        };
        return result;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        return this.columnOptions.get(modelColumnIndex).getName();
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        return switch (modelColumnIndex) {
            case 0, 1, 2, 3 -> String.class;
            case 4, 5, 6 -> Integer.TYPE;
            case 7 -> LinkInfo.class;
            default -> throw new AssertionError(modelColumnIndex);
        };
    }

    private static final Unit columnOptions$lambda$0(AppLinksTableColumnOption it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onColumnSelectionChange(AppLinkOverviewTableModel $this, AppLinksTableColumnOption column) {
        $this.onColumnSelectionChange(column);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$AppLinksTableColumnOption;", "", "name", "", "modelIndex", "", "selected", "", "callback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "column", "", "<init>", "(Ljava/lang/String;IZLkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getModelIndex", "()I", "value", "getSelected", "()Z", "setSelected", "(Z)V", "url-assistant"})
    public static final class AppLinksTableColumnOption {
        @NotNull
        private final String name;
        private final int modelIndex;
        @NotNull
        private final Function1<AppLinksTableColumnOption, Unit> callback;
        private boolean selected;

        public AppLinksTableColumnOption(@NotNull String name, int modelIndex, boolean selected, @NotNull Function1<? super AppLinksTableColumnOption, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.name = name;
            this.modelIndex = modelIndex;
            this.callback = callback;
            this.setSelected(selected);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getModelIndex() {
            return this.modelIndex;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean value) {
            this.selected = value;
            this.callback.invoke((Object)this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$Companion;", "", "<init>", "()V", "SCHEME_MODEL_COLUMN_INDEX", "", "HOST_MODEL_COLUMN_INDEX", "PATH_MODEL_COLUMN_INDEX", "ACTIVITY_MODEL_COLUMN_INDEX", "APP_CHECKS_FAILED_MODEL_COLUMN_INDEX", "WEB_CHECKS_FAILED_MODEL_COLUMN_INDEX", "LINKS_WITH_SAME_DOMAIN_MODEL_COLUMN_INDEX", "ARROW_BUTTON_INDEX", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

