/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StringResourceWriter;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.FileExtensions;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.SigningConfig;
import com.google.urlassistant.util.UrlAssistantToken;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.net.MalformedURLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DalUtils {
    private static final String ASSET_STATEMENTS = "asset_statements";
    private static final String STRING_ASSET_STATEMENTS = "@string/asset_statements";
    private static final String RESOURCE = "resource";
    private static final String AUTO_VERIFY = "autoVerify";
    private static final String DAL_HANDLE_URL_STATEMENT = "{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%1$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%2$s\"]\n  }\n}";
    private static final String DAL_SMART_LOCK_STATEMENT = ",\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"web\",\n    \"site\": \"%1$s\"\n  }\n},\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%2$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%3$s\"]\n  }\n}";
    private static final String DAL_STRING_RES = "[{ \"include\": \"%1$s/.well-known/assetlinks.json\" }]";

    private static Logger getLog() {
        return Logger.getInstance(DalUtils.class);
    }

    @NotNull
    public static FullUrl getFullUrlWithHttps(@NotNull String domain) throws MalformedURLException {
        FullUrl fullUrl = new FullUrl((String)(domain.contains("://") ? domain : "https://" + domain));
        fullUrl.setScheme("https");
        return fullUrl;
    }

    @NotNull
    public static String getDalFileText(@NotNull String packageId, @NotNull String keystoreFingerprint, @Nullable String signInUrl) {
        Object res = String.format(DAL_HANDLE_URL_STATEMENT, packageId, keystoreFingerprint);
        if (signInUrl != null) {
            res = (String)res + String.format(DAL_SMART_LOCK_STATEMENT, signInUrl, packageId, keystoreFingerprint);
        }
        return "[" + (String)res + "]";
    }

    @NotNull
    public static String getDalStringResText(@NotNull String domain) {
        return String.format(DAL_STRING_RES, domain);
    }

    @RequiresWriteLock
    @Nullable
    public static VirtualFile addDalStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        if (facet == null) {
            return null;
        }
        List itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.RES_AUTO, ResourceType.STRING, ASSET_STATEMENTS);
        if (itemList.isEmpty()) {
            List resourceFolders = ResourceFolderManager.getInstance((AndroidFacet)facet).getFolders();
            if (resourceFolders.isEmpty()) {
                return null;
            }
            VirtualFile resourceFolderToUse = (VirtualFile)resourceFolders.get(0);
            XmlFile resultFile = DalUtils.createItem(facet, resourceFolderToUse, statementText);
            return resultFile == null ? null : resultFile.getVirtualFile();
        }
        boolean hasFailed = false;
        for (ResourceItem item : itemList) {
            if (StringResourceWriter.INSTANCE.setItemText(project, item, statementText)) continue;
            hasFailed = true;
        }
        return hasFailed ? null : DalUtils.findContainingFile((ResourceItem)itemList.get(0));
    }

    @Nullable
    private static XmlFile createItem(@NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, @NotNull String value) {
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringResourceWriter.INSTANCE.getStringResourceFile(project, resFolder);
        if (resourceFile == null) {
            return null;
        }
        XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        return (XmlFile)WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
            XmlTag childTag = root.createChildTag("string", root.getNamespace(), CharacterDataEscaper.escape((String)value), false);
            if (childTag == null) {
                return null;
            }
            childTag.setAttribute("name", ASSET_STATEMENTS);
            childTag.setAttribute("translatable", "false");
            root.addSubTag(childTag, false);
            return resourceFile;
        });
    }

    public static boolean addStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        List itemList;
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        if ((itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.RES_AUTO, ResourceType.STRING, ASSET_STATEMENTS)).isEmpty()) {
            List resourceFolders = ResourceFolderManager.getInstance((AndroidFacet)facet).getFolders();
            if (resourceFolders.isEmpty()) {
                return false;
            }
            XmlTag newTag = DalUtils.makeItem(facet, (VirtualFile)resourceFolders.get(resourceFolders.size() - 1), statementText);
            return newTag != null;
        }
        for (ResourceItem item : itemList) {
            boolean successfullyChanged = StringResourceWriter.INSTANCE.setItemText(project, item, statementText);
            if (!successfullyChanged) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static XmlTag makeItem(@NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, @NotNull String value) {
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringResourceWriter.INSTANCE.getStringResourceFile(project, resFolder);
        if (resourceFile == null) {
            return null;
        }
        XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        return (XmlTag)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{resourceFile}).withName("Creating string asset_statements").compute(() -> {
            String escapedText;
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            try {
                escapedText = CharacterDataEscaper.escape((String)value);
            }
            catch (IllegalArgumentException exception) {
                Logger.getInstance(DalUtils.class).warn((Throwable)exception);
                escapedText = value;
            }
            XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), escapedText, false);
            child.setAttribute("name", ASSET_STATEMENTS);
            child.setAttribute("translatable", "false");
            root.addSubTag(child, false);
            return child;
        });
    }

    @Nullable
    private static VirtualFile findContainingFile(@Nullable ResourceItem resourceItem) {
        if (resourceItem == null) {
            return null;
        }
        PathString source = resourceItem.getSource();
        if (source == null) {
            DalUtils.getLog().warn(String.format("Couldn't find the resource file containing \"%s\"", resourceItem.getQualifiedNameWithType()));
            return null;
        }
        VirtualFile file = FileExtensions.toVirtualFile((PathString)source);
        if (file == null) {
            DalUtils.getLog().warn(String.format("Couldn't find string resource file (%s) when adding asset statements", source.getNativePath()));
        }
        return file;
    }

    public static boolean checkDalStringResourceExists(@NotNull AndroidFacet facet, @NotNull String statementText) {
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        List itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.TODO(), ResourceType.STRING, ASSET_STATEMENTS);
        for (ResourceItem item : itemList) {
            XmlTag tag = IdeResourcesUtil.getItemTag((Project)project, (ResourceItem)item);
            if (tag == null || statementText.equals(CharacterDataEscaper.unescape((String)tag.getValue().getText()))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String loadSigningConfigs(@NotNull Module module, @NotNull List<SigningConfig> result) {
        result.clear();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)module.getProject());
        UrlAssistantToken token = UrlAssistantToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token == null) {
            return "";
        }
        String packageId = token.loadSigningConfigs(projectSystem, module, result);
        return packageId == null ? "" : packageId;
    }

    @WorkerThread
    @NotNull
    public static Map<AndroidFacet, Manifest> getManifestsNeedingMetadataForFacet(@NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        List<Object> facetList = baseModule == null ? new ArrayList<AndroidFacet>(Collections.singletonList(facet)) : ProjectSystemUtil.getAndroidFacets((Project)project);
        return facetList.stream().filter(f -> SourceProviderManager.getInstance((AndroidFacet)f).getMainManifestFile() != null).map(f -> new AbstractMap.SimpleEntry<AndroidFacet, Manifest>((AndroidFacet)f, Manifest.getMainManifest((AndroidFacet)f))).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @RequiresWriteLock
    public static boolean addMetaDataToAndroidManifest(@NotNull Manifest manifest) {
        XmlTag xmlTag = manifest.getXmlTag();
        if (xmlTag == null) {
            return false;
        }
        List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(xmlTag, "application");
        return !applications.isEmpty() && DalUtils.setAttributeOnTag(applications.get(0));
    }

    public static boolean checkMetaDataInAndroidManifestExists(@NotNull Manifest manifest) {
        XmlTag xmlTag = manifest.getXmlTag();
        if (xmlTag == null) {
            return false;
        }
        List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(xmlTag, "application");
        if (!applications.isEmpty()) {
            XmlTag applicationTag = applications.get(0);
            List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) || STRING_ASSET_STATEMENTS.equals(subTag.getAttributeValue(RESOURCE, "http://schemas.android.com/apk/res/android"))) continue;
                return true;
            }
        }
        return false;
    }

    @RequiresWriteLock
    private static boolean setAttributeOnTag(@NotNull XmlTag applicationTag) {
        List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
        try {
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
                subTag.setAttribute(RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
                return true;
            }
            String prefix = applicationTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            XmlTag metaData = applicationTag.createChildTag("meta-data", null, null, false);
            if (metaData == null) {
                return false;
            }
            metaData.setAttribute(prefix + ":name", "http://schemas.android.com/apk/res/android", ASSET_STATEMENTS);
            metaData.setAttribute(prefix + ":resource", "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
            applicationTag.addSubTag(metaData, true);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    @RequiresWriteLock
    public static boolean addAutoVerifyToAppLinks(@NotNull Manifest manifest) {
        Application application = manifest.getApplication();
        if (application == null) {
            return false;
        }
        List activityList = application.getActivities();
        for (Activity activity : activityList) {
            for (IntentFilter intentFilter : activity.getIntentFilters()) {
                if (!ManifestUtils.isValidAppLink(intentFilter.getXmlTag())) continue;
                XmlTag xmlTag = intentFilter.getXmlTag();
                xmlTag.setAttribute(AUTO_VERIFY, "http://schemas.android.com/apk/res/android", "true");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getDalJsonFileUrl(@NotNull String domain) {
        return domain + "/.well-known/assetlinks.json";
    }

    public static class SigningConfigComboBoxModel
    implements ComboBoxModel<String> {
        private final List<SigningConfig> configList;
        private int selectedIndex = 0;

        public SigningConfigComboBoxModel(@NotNull List<SigningConfig> list) {
            this.configList = list;
        }

        @Nullable
        public SigningConfig getSelectedSigningConfig() {
            try {
                return this.configList.get(this.selectedIndex);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.configList.size(); ++i) {
                if (!this.configList.get(i).getName().equals(anItem)) continue;
                this.selectedIndex = i;
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                return this.configList.get(this.selectedIndex).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this.configList.size();
        }

        @Override
        public String getElementAt(int index) {
            try {
                return this.configList.get(index).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

