/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLLPReader;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class MinLowerLayerProtocol
extends LowerLayerProtocol {
    private Charset charset;

    public HL7Reader getReader(InputStream in) throws LLPException {
        try {
            if (this.charset != null) {
                return new MinLLPReader(in, this.charset);
            }
            return new MinLLPReader(in);
        }
        catch (IOException e) {
            throw new LLPException("Can't create MinLLPReader with the given input stream: " + e.getMessage(), e);
        }
    }

    public HL7Writer getWriter(OutputStream out) throws LLPException {
        try {
            if (this.charset != null) {
                return new MinLLPWriter(out, this.charset);
            }
            return new MinLLPWriter(out);
        }
        catch (IOException e) {
            throw new LLPException("Can't create MinLLPWriter with the given output stream: " + e.getMessage(), e);
        }
    }

    public void setCharset(Charset theCharset) {
        this.charset = theCharset;
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }
}

