/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v23.datatype.CQ;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXD
extends AbstractSegment {
    public RXD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Dispense/Give Code");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time Dispensed");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Actual Dispense Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Actual Dispense Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Actual Dosage Form");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Dispense Notes");
            this.add(XCN.class, false, 1, 200, new Object[]{this.getMessage()}, "Dispensing Provider");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(CM_LA1.class, false, 1, 200, new Object[]{this.getMessage()}, "Dispense-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Pharmacy/Treatment Supplier's Special Dispensing Instructions");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Actual Strength");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Actual Strength Unit");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Indication");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Dispense Package Size");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Dispense Package Size Unit");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(321)}, "Dispense Package Method");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RXD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxd1_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getDispenseGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRxd2_DispenseGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimeDispensed() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getRxd3_DateTimeDispensed() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxd4_ActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getActualDispenseUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxd5_ActualDispenseUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getActualDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRxd6_ActualDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getRxd7_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getRxd8_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CE[] getDispenseNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxd9_DispenseNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public int getDispenseNotesReps() {
        return this.getReps(9);
    }

    public CE getDispenseNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getRxd9_DispenseNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxd9_DispenseNotesReps() {
        return this.getReps(9);
    }

    public CE insertDispenseNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeDispenseNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public XCN getDispensingProvider() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public XCN getRxd10_DispensingProvider() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getRxd11_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getTotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getRxd12_TotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CM_LA1 getDispenseToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(13, 0);
        return retVal;
    }

    public CM_LA1 getRxd13_DispenseToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getRxd14_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public CE[] getPharmacyTreatmentSupplierSSpecialDispensingInstructions() {
        CE[] retVal = (CE[])this.getTypedField(15, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxd15_PharmacyTreatmentSupplierSSpecialDispensingInstructions() {
        CE[] retVal = (CE[])this.getTypedField(15, (Type[])new CE[0]);
        return retVal;
    }

    public int getPharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        return this.getReps(15);
    }

    public CE getPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public CE getRxd15_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRxd15_PharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        return this.getReps(15);
    }

    public CE insertPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertRxd15_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removePharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removeRxd15_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public NM getActualStrength() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getRxd16_ActualStrength() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getActualStrengthUnit() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getRxd17_ActualStrengthUnit() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(18, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getRxd18_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(18, (Type[])new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(18);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(18, rep);
        return retVal;
    }

    public ST getRxd18_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(18, rep);
        return retVal;
    }

    public int getRxd18_SubstanceLotNumberReps() {
        return this.getReps(18);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(18, rep);
    }

    public ST insertRxd18_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(18, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(18, rep);
    }

    public ST removeRxd18_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(18, rep);
    }

    public TS[] getSubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(19, (Type[])new TS[0]);
        return retVal;
    }

    public TS[] getRxd19_SubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(19, (Type[])new TS[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(19);
    }

    public TS getSubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(19, rep);
        return retVal;
    }

    public TS getRxd19_SubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxd19_SubstanceExpirationDateReps() {
        return this.getReps(19);
    }

    public TS insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(19, rep);
    }

    public TS insertRxd19_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(19, rep);
    }

    public TS removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(19, rep);
    }

    public TS removeRxd19_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(19, rep);
    }

    public CE[] getSubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(20, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxd20_SubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(20, (Type[])new CE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(20);
    }

    public CE getSubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(20, rep);
        return retVal;
    }

    public CE getRxd20_SubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getRxd20_SubstanceManufacturerNameReps() {
        return this.getReps(20);
    }

    public CE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(20, rep);
    }

    public CE insertRxd20_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(20, rep);
    }

    public CE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(20, rep);
    }

    public CE removeRxd20_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(20, rep);
    }

    public CE getIndication() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getRxd21_Indication() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getDispensePackageSize() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getRxd22_DispensePackageSize() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getDispensePackageSizeUnit() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getRxd23_DispensePackageSizeUnit() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getRxd24_DispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new CM_LA1(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new TS(this.getMessage());
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new CE(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(321));
            }
        }
        return null;
    }
}

