/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RAS_O17_TIMING_ENCODED;
import ca.uhn.hl7v2.model.v26.segment.RXC;
import ca.uhn.hl7v2.model.v26.segment.RXE;
import ca.uhn.hl7v2.model.v26.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O17_ENCODING
extends AbstractGroup {
    public RAS_O17_ENCODING(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXE.class, true, false, false);
            this.add(RAS_O17_TIMING_ENCODED.class, true, true, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAS_O17_ENCODING - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public RXE getRXE() {
        RXE retVal = (RXE)this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public RAS_O17_TIMING_ENCODED getTIMING_ENCODED() {
        RAS_O17_TIMING_ENCODED retVal = (RAS_O17_TIMING_ENCODED)this.getTyped("TIMING_ENCODED", RAS_O17_TIMING_ENCODED.class);
        return retVal;
    }

    public RAS_O17_TIMING_ENCODED getTIMING_ENCODED(int rep) {
        RAS_O17_TIMING_ENCODED retVal = (RAS_O17_TIMING_ENCODED)this.getTyped("TIMING_ENCODED", rep, RAS_O17_TIMING_ENCODED.class);
        return retVal;
    }

    public int getTIMING_ENCODEDReps() {
        return this.getReps("TIMING_ENCODED");
    }

    public List<RAS_O17_TIMING_ENCODED> getTIMING_ENCODEDAll() throws HL7Exception {
        return this.getAllAsList("TIMING_ENCODED", RAS_O17_TIMING_ENCODED.class);
    }

    public void insertTIMING_ENCODED(RAS_O17_TIMING_ENCODED structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_ENCODED", (Structure)structure, rep);
    }

    public RAS_O17_TIMING_ENCODED insertTIMING_ENCODED(int rep) throws HL7Exception {
        return (RAS_O17_TIMING_ENCODED)super.insertRepetition("TIMING_ENCODED", rep);
    }

    public RAS_O17_TIMING_ENCODED removeTIMING_ENCODED(int rep) throws HL7Exception {
        return (RAS_O17_TIMING_ENCODED)super.removeRepetition("TIMING_ENCODED", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }
}

