/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CM2
extends AbstractSegment {
    public CM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID- CM2");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Scheduled Time Point");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "Description of Time Point");
            this.add(CWE.class, true, 200, 250, new Object[]{this.getMessage()}, "Events Scheduled This Time Point");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CM2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDCM2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getCm21_SetIDCM2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getScheduledTimePoint() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getCm22_ScheduledTimePoint() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getDescriptionOfTimePoint() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCm23_DescriptionOfTimePoint() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE[] getEventsScheduledThisTimePoint() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCm24_EventsScheduledThisTimePoint() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getEventsScheduledThisTimePointReps() {
        return this.getReps(4);
    }

    public CWE getEventsScheduledThisTimePoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getCm24_EventsScheduledThisTimePoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getCm24_EventsScheduledThisTimePointReps() {
        return this.getReps(4);
    }

    public CWE insertEventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertCm24_EventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeEventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeCm24_EventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

