/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractCrawlingJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;

class ArrayElementJsonAccessor
extends AbstractCrawlingJsonAccessor<JsonArray> {
    private final int index;

    public ArrayElementJsonAccessor(JsonCompositeAccessor<JsonArray> parentAccessor, int index) {
        super(parentAccessor);
        this.index = index;
    }

    @Override
    protected JsonElement doGet(JsonArray parent) {
        if (parent != null && this.index < parent.size()) {
            return parent.get(this.index);
        }
        return null;
    }

    @Override
    protected void doSet(JsonArray parent, JsonElement newValue) {
        ArrayElementJsonAccessor.fillTo(parent, this.index);
        parent.set(this.index, newValue);
    }

    private static void fillTo(JsonArray array, int index) {
        for (int i = array.size(); i <= index; ++i) {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
    }

    @Override
    protected void appendRuntimeRelativePath(StringBuilder path) {
        path.append("[").append(this.index).append("]");
    }

    @Override
    protected void appendStaticRelativePath(StringBuilder path, boolean first) {
    }
}

