/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.dsl.spi.HighlightProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

public class LuceneFieldHighlightProjection
implements LuceneSearchProjection<List<String>> {
    private final Set<String> indexNames;
    private final Analyzer analyzer;
    private final String absoluteFieldPath;
    private final String highlighterName;
    private final String nestedDocumentPath;
    private final LuceneSearchIndexValueFieldTypeContext<?> typeContext;

    private LuceneFieldHighlightProjection(Builder builder) {
        this(builder.scope, builder.field, builder.highlighterName());
    }

    LuceneFieldHighlightProjection(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, String highlighterName) {
        this.indexNames = scope.hibernateSearchIndexNames();
        this.analyzer = field.type().searchAnalyzerOrNormalizer();
        this.absoluteFieldPath = field.absolutePath();
        this.highlighterName = highlighterName;
        this.nestedDocumentPath = field.nestedDocumentPath();
        this.typeContext = field.type();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + "highlighterName=" + this.highlighterName + "]";
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    public FieldHighlightExtractor<?> request(ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() != null) {
            throw log.cannotHighlightInNestedContext(context.absoluteCurrentFieldPath(), EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        context.checkValidField(this.absoluteFieldPath);
        LuceneAbstractSearchHighlighter highlighter = context.highlighter(this.highlighterName);
        if (!this.typeContext.highlighterTypeSupported(highlighter.type())) {
            throw log.highlighterTypeNotSupported(highlighter.type(), this.absoluteFieldPath);
        }
        highlighter.request(context, this.absoluteFieldPath);
        return new FieldHighlightExtractor(context.absoluteCurrentNestedFieldPath(), highlighter, ProjectionAccumulator.list().get());
    }

    public static class Builder
    extends HighlightProjectionBuilder {
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<?> field;

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(field.absolutePath());
            this.scope = scope;
            this.field = field;
        }

        protected String highlighterName() {
            return this.highlighterName;
        }

        public LuceneFieldHighlightProjection build() {
            return new LuceneFieldHighlightProjection(this);
        }
    }

    private class FieldHighlightExtractor<A>
    implements LuceneSearchProjection.Extractor<A, List<String>> {
        private final String parentDocumentPath;
        private final LuceneAbstractSearchHighlighter highlighter;
        private final ProjectionAccumulator<String, String, A, List<String>> accumulator;

        private FieldHighlightExtractor(String parentDocumentPath, LuceneAbstractSearchHighlighter highlighter, ProjectionAccumulator<String, String, A, List<String>> accumulator) {
            this.parentDocumentPath = parentDocumentPath;
            this.highlighter = highlighter;
            this.accumulator = accumulator;
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            return this.highlighter.createValues(this.parentDocumentPath, LuceneFieldHighlightProjection.this.nestedDocumentPath, LuceneFieldHighlightProjection.this.absoluteFieldPath, LuceneFieldHighlightProjection.this.analyzer, context, this.accumulator);
        }

        @Override
        public List<String> transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            return (List)this.accumulator.finish(extractedData);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<HighlightProjectionBuilder, F> {
        @Override
        public HighlightProjectionBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            if (field.nestedDocumentPath() != null) {
                throw LuceneSearchProjection.log.cannotHighlightFieldFromNestedObjectStructure(EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
            }
            return new Builder(scope, field);
        }
    }

    public static abstract class HighlighterValues<A>
    extends AbstractNestingAwareAccumulatingValues<String, A> {
        protected LeafReaderContext leafReaderContext;

        protected HighlighterValues(String parentDocumentPath, String nestedDocumentPath, TopDocsDataCollectorExecutionContext context, ProjectionAccumulator<String, ?, A, List<String>> accumulator) {
            super(parentDocumentPath, nestedDocumentPath, accumulator, context);
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            super.context(context);
            this.leafReaderContext = context;
        }

        @Override
        protected A accumulate(A accumulated, int docId) throws IOException {
            return (A)this.accumulator.accumulateAll(accumulated, this.highlight(docId));
        }

        protected abstract List<String> highlight(int var1) throws IOException;
    }
}

