/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;

public class LuceneObjectExistsPredicate
extends AbstractLuceneSingleFieldPredicate {
    private final List<LuceneSearchPredicate> children;

    private LuceneObjectExistsPredicate(Builder builder) {
        super(builder);
        this.children = builder.children;
        builder.children = null;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LuceneSearchPredicate child : this.children) {
            builder.add(child.toQuery(context), BooleanClause.Occur.SHOULD);
        }
        builder.add((Query)new TermQuery(new Term(MetadataFields.fieldNamesFieldName(), this.absoluteFieldPath)), BooleanClause.Occur.SHOULD);
        return builder.build();
    }

    private static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements ExistsPredicateBuilder {
        private List<LuceneSearchPredicate> children = new ArrayList<LuceneSearchPredicate>();

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(scope, node);
        }

        public void addChild(LuceneSearchIndexNodeContext child) {
            if (child.isComposite() && child.toComposite().type().nested()) {
                return;
            }
            this.children.add(LuceneSearchPredicate.from(this.scope, ((ExistsPredicateBuilder)child.queryElement(PredicateTypeKeys.EXISTS, this.scope)).build()));
        }

        public SearchPredicate build() {
            return new LuceneObjectExistsPredicate(this);
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<ExistsPredicateBuilder> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public ExistsPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            Builder builder = new Builder(scope, node);
            for (LuceneSearchIndexNodeContext luceneSearchIndexNodeContext : node.staticChildrenByName().values()) {
                builder.addChild(luceneSearchIndexNodeContext);
            }
            return builder;
        }
    }
}

