/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.threads.DirectExecutor;

class ThreadNameNotatingExecutor
implements DirectExecutor {
    private final String notation;
    private final DirectExecutor delegate;

    ThreadNameNotatingExecutor(String notation, DirectExecutor delegate) {
        this.notation = notation;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Thread thr = Thread.currentThread();
        String oldName = thr.getName();
        thr.setName(oldName + " (" + this.notation + ')');
        try {
            this.delegate.execute(command);
        }
        finally {
            thr.setName(oldName);
        }
    }

    public String toString() {
        return String.format("%s notation=\"%s\" -> %s", super.toString(), this.notation, this.delegate);
    }
}

