/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleUtil;
import org.openmrs.util.OpenmrsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleResourcesServlet
extends HttpServlet {
    private static final String MODULE_PATH = "/WEB-INF/view/module/";
    private static final long serialVersionUID = 1239820102030344L;
    private static final Logger log = LoggerFactory.getLogger(ModuleResourcesServlet.class);

    protected long getLastModified(HttpServletRequest req) {
        File f = this.getFile(req);
        if (f == null) {
            return super.getLastModified(req);
        }
        return f.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("In service method for module servlet: " + request.getPathInfo());
        File f = this.getFile(request);
        if (f == null) {
            response.setStatus(404);
            return;
        }
        response.setDateHeader("Last-Modified", f.lastModified());
        response.setContentLength(Long.valueOf(f.length()).intValue());
        String mimeType = this.getServletContext().getMimeType(f.getName());
        response.setContentType(mimeType);
        FileInputStream is = new FileInputStream(f);
        try {
            OpenmrsUtil.copyFile((InputStream)is, (OutputStream)response.getOutputStream());
        }
        finally {
            OpenmrsUtil.closeStream((Closeable)is);
        }
    }

    protected File getFile(HttpServletRequest request) {
        File f;
        String path = request.getPathInfo();
        Module module = ModuleUtil.getModuleForPath((String)path);
        if (module == null) {
            log.warn("No module handles the path: " + path);
            return null;
        }
        String relativePath = ModuleUtil.getPathForResource((Module)module, (String)path);
        String realPath = this.getServletContext().getRealPath("") + MODULE_PATH + module.getModuleIdAsPath() + "/resources" + relativePath;
        File devDir = ModuleUtil.getDevelopmentDirectory((String)module.getModuleId());
        if (devDir != null) {
            realPath = devDir.getAbsolutePath() + "/omod/target/classes/web/module/resources" + relativePath;
        }
        if (!(f = new File(realPath = realPath.replace("/", File.separator))).exists()) {
            log.warn("No file with path '" + realPath + "' exists for module '" + module.getModuleId() + "'");
            return null;
        }
        return f;
    }
}

