/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleFactory;
import org.openmrs.module.web.WebModuleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1239820102030303L;
    private static final Logger log = LoggerFactory.getLogger(ModuleServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("In service method for module servlet: " + request.getPathInfo());
        String servletName = request.getPathInfo();
        int end = servletName.indexOf("/", 1);
        String moduleId = null;
        if (end > 0) {
            moduleId = servletName.substring(1, end);
        }
        log.debug("ModuleId: " + moduleId);
        Module mod = ModuleFactory.getModuleById((String)moduleId);
        int start = 1;
        if (mod != null) {
            log.debug("Module with id " + moduleId + " found.  Looking for servlet name after " + moduleId + " in url path");
            start = moduleId.length() + 2;
        }
        if ((end = servletName.indexOf("/", start)) == -1 || end > servletName.length()) {
            end = servletName.length();
        }
        servletName = servletName.substring(start, end);
        log.debug("Servlet name: " + servletName);
        HttpServlet servlet = WebModuleUtil.getServlet(servletName);
        if (servlet == null) {
            log.warn("No servlet with name: " + servletName + " was found");
            response.setStatus(404);
            return;
        }
        servlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public static class SimpleServletConfig
    implements ServletConfig {
        private String name;
        private ServletContext servletContext;
        private final Map<String, String> initParameters;

        public SimpleServletConfig(String name, ServletContext servletContext, Map<String, String> initParameters) {
            this.name = name;
            this.servletContext = servletContext;
            this.initParameters = initParameters;
        }

        public String getServletName() {
            return this.name;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return this.initParameters.get(paramName);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.initParameters.keySet());
        }
    }
}

