/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.TldCache;
import org.apache.jasper.servlet.JspServlet;
import org.apache.jasper.servlet.TldScanner;
import org.openmrs.util.OpenmrsClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OpenmrsJspServlet
extends JspServlet {
    private static final Logger log = LoggerFactory.getLogger(OpenmrsJspServlet.class);
    public static final String OPENMRS_TLD_SCAN_NEEDED = "OPENMRS_TLD_SCAN_NEEDED";

    public void init(ServletConfig config) throws ServletException {
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.rescanTldsIfNeeded();
        super.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void rescanTldsIfNeeded() throws ServletException {
        if (this.getBooleanAttribute(OPENMRS_TLD_SCAN_NEEDED, true)) {
            log.warn("Rescanning TLDs");
            boolean namespaceAware = true;
            boolean validate = this.getBooleanParameter("org.apache.jasper.XML_VALIDATE_TLD", false);
            boolean blockExternalString = this.getBooleanParameter("org.apache.jasper.XML_BLOCK_EXTERNAL", true);
            try {
                TldScanner scanner = new TldScanner(this.getServletContext(), namespaceAware, validate, blockExternalString);
                try {
                    scanner.scan();
                }
                catch (IOException | SAXException e) {
                    throw new ServletException((Throwable)e);
                }
                for (String listener : scanner.getListeners()) {
                    this.getServletContext().addListener(listener);
                }
                TldCache tldCache = new TldCache(this.getServletContext(), scanner.getUriTldResourcePathMap(), scanner.getTldResourcePathTaglibXmlMap());
                this.getServletContext().setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, (Object)tldCache);
                log.info("TldCache updated on ServletContext");
                try {
                    Options options = (Options)FieldUtils.readField((Object)((Object)this), (String)"options", (boolean)true);
                    if (options instanceof EmbeddedServletOptions) {
                        EmbeddedServletOptions embeddedServletOptions = (EmbeddedServletOptions)options;
                        embeddedServletOptions.setTldCache(tldCache);
                        log.info("TldCache updated on JspServlet");
                    }
                }
                catch (IllegalAccessException e) {
                    throw new ServletException("Unable to set TldCache on JspServlet options", (Throwable)e);
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Got NoClassDefFound error, skipping additional TLD scanning step");
            }
            finally {
                log.info("Scanning completed successfully");
                this.getServletContext().setAttribute(OPENMRS_TLD_SCAN_NEEDED, (Object)false);
            }
        }
    }

    private boolean getBooleanParameter(String parameter, boolean defaultValue) {
        String val = this.getServletContext().getInitParameter(parameter);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    private boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        Boolean val = (Boolean)this.getServletContext().getAttribute(attribute);
        if (val != null) {
            return val;
        }
        return defaultValue;
    }
}

