/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openmrs.api.APIException;
import org.openmrs.api.context.Context;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleException;
import org.openmrs.module.ModuleFactory;
import org.openmrs.module.ModuleUtil;
import org.openmrs.module.web.ModuleServlet;
import org.openmrs.module.web.filter.ModuleFilterConfig;
import org.openmrs.module.web.filter.ModuleFilterDefinition;
import org.openmrs.module.web.filter.ModuleFilterMapping;
import org.openmrs.scheduler.SchedulerException;
import org.openmrs.scheduler.SchedulerService;
import org.openmrs.scheduler.TaskDefinition;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.web.DispatcherServlet;
import org.openmrs.web.StaticDispatcherServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebModuleUtil {
    private static final Logger log = LoggerFactory.getLogger(WebModuleUtil.class);
    private static final Lock SERVLET_LOCK = new ReentrantLock();
    private static final Lock FILTERS_LOCK = new ReentrantLock();
    private static final Map<String, HttpServlet> MODULE_SERVLETS = new HashMap<String, HttpServlet>();
    private static final Map<Module, Collection<Filter>> MODULE_FILTERS = new HashMap<Module, Collection<Filter>>();
    private static final Map<String, Filter> MODULE_FILTERS_BY_NAME = new HashMap<String, Filter>();
    private static final Deque<ModuleFilterMapping> MODULE_FILTER_MAPPINGS = new ArrayDeque<ModuleFilterMapping>();
    private static DispatcherServlet dispatcherServlet = null;
    private static StaticDispatcherServlet staticDispatcherServlet = null;

    private WebModuleUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startModule(Module mod, ServletContext servletContext, boolean delayContextRefresh) {
        log.debug("Trying to start module {}", (Object)mod);
        if (ModuleFactory.isModuleStarted((Module)mod) && !mod.hasStartupError().booleanValue()) {
            String msg;
            File webInf;
            String realPath = WebModuleUtil.getRealPath(servletContext);
            if (realPath == null) {
                realPath = System.getProperty("user.dir");
            }
            if (!(webInf = new File(realPath + "/WEB-INF".replace("/", File.separator))).exists()) {
                webInf.mkdir();
            }
            boolean moduleNeedsContextRefresh = false;
            ZipFile jarFile = null;
            OutputStream outStream = null;
            InputStream inStream = null;
            try {
                File modFile = mod.getFile();
                jarFile = new JarFile(modFile);
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (Paths.get(name, new String[0]).startsWith("..")) {
                        throw new UnsupportedOperationException("Attempted to write file '" + name + "' rejected as it attempts to write outside the chosen directory. This may be the result of a zip-slip style attack.");
                    }
                    log.debug("Entry name: {}", (Object)name);
                    if (name.startsWith("web/module/")) {
                        String filepath = name.substring(11);
                        StringBuilder absPath = new StringBuilder(realPath + "/WEB-INF");
                        if (filepath.startsWith("tags/")) {
                            filepath = filepath.substring(5);
                            absPath.append("/tags/module/");
                        } else {
                            absPath.append("/view/module/");
                        }
                        absPath.append(mod.getModuleIdAsPath()).append("/").append(filepath);
                        log.debug("Moving file from: {} to {}", (Object)name, (Object)absPath);
                        File outFile = new File(absPath.toString().replace("/", File.separator));
                        if (entry.isDirectory()) {
                            if (outFile.exists()) continue;
                            outFile.mkdirs();
                            continue;
                        }
                        File parentDir = outFile.getParentFile();
                        if (!parentDir.exists()) {
                            parentDir.mkdirs();
                        }
                        outStream = new FileOutputStream(outFile, false);
                        inStream = ((JarFile)jarFile).getInputStream(entry);
                        OpenmrsUtil.copyFile((InputStream)inStream, (OutputStream)outStream);
                        continue;
                    }
                    if ("moduleApplicationContext.xml".equals(name) || "webModuleApplicationContext.xml".equals(name)) {
                        moduleNeedsContextRefresh = true;
                        continue;
                    }
                    if (!name.equals(mod.getModuleId() + "Context.xml")) continue;
                    msg = "DEPRECATED: '" + name + "' should be named 'moduleApplicationContext.xml' now. Please update/upgrade. ";
                    throw new ModuleException(msg, mod.getModuleId());
                }
            }
            catch (IOException io) {
                log.warn("Unable to copy files from module " + mod.getModuleId() + " to the web layer", (Throwable)io);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException io) {
                        log.warn("Couldn't close jar file: " + jarFile.getName(), (Throwable)io);
                    }
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException io) {
                        log.warn("Couldn't close InputStream: " + io);
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException io) {
                        log.warn("Couldn't close OutputStream: " + io);
                    }
                }
            }
            InputStream inputStream = null;
            try {
                Document config = mod.getConfig();
                Element root = config.getDocumentElement();
                if (root.getElementsByTagName("dwr").getLength() > 0) {
                    File f = new File(realPath + "/WEB-INF/dwr-modules.xml".replace("/", File.separator));
                    if (!f.exists()) {
                        WebModuleUtil.createDwrModulesXml(realPath);
                    }
                    inputStream = new FileInputStream(f);
                    Document dwrmodulexml = WebModuleUtil.getDWRModuleXML(inputStream, realPath);
                    Element outputRoot = dwrmodulexml.getDocumentElement();
                    Node node = root.getElementsByTagName("dwr").item(0);
                    for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
                        if (!"allow".equals(current.getNodeName()) && !"signatures".equals(current.getNodeName()) && !"init".equals(current.getNodeName())) continue;
                        ((Element)current).setAttribute("moduleId", mod.getModuleId());
                        outputRoot.appendChild(dwrmodulexml.importNode(current, true));
                    }
                    moduleNeedsContextRefresh = true;
                    OpenmrsUtil.saveDocument((Document)dwrmodulexml, (File)f);
                }
            }
            catch (FileNotFoundException e) {
                throw new ModuleException(realPath + "/WEB-INF/dwr-modules.xml file doesn't exist.", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException io) {
                        log.error("Error while closing input stream", (Throwable)io);
                    }
                }
            }
            String folderPath = realPath + "/WEB-INF/view/module/" + mod.getModuleIdAsPath();
            File outFile = new File(folderPath.replace("/", File.separator));
            outFile.deleteOnExit();
            if (!moduleNeedsContextRefresh && mod.getAdvicePoints() != null && !mod.getAdvicePoints().isEmpty()) {
                moduleNeedsContextRefresh = true;
            }
            if (moduleNeedsContextRefresh && !delayContextRefresh) {
                log.debug("Refreshing context for module {}", (Object)mod.getModuleId());
                try {
                    WebModuleUtil.refreshWAC(servletContext, false, mod);
                    log.debug("Done refreshing context for module {}", (Object)mod.getModuleId());
                }
                catch (Exception e) {
                    block60: {
                        msg = "Unable to refresh the WebApplicationContext";
                        mod.setStartupErrorMessage(msg, (Throwable)e);
                        if (log.isWarnEnabled()) {
                            log.warn(msg + " for module: " + mod.getModuleId(), (Throwable)e);
                        }
                        try {
                            WebModuleUtil.stopModule(mod, servletContext, true);
                            ModuleFactory.stopModule((Module)mod, (boolean)true, (boolean)true);
                        }
                        catch (Exception e2) {
                            if (!log.isWarnEnabled()) break block60;
                            log.warn("Error while stopping a module that had an error on refreshWAC", (Throwable)e2);
                        }
                    }
                    log.debug("Refreshing context for module {} (re-trying)", (Object)mod.getModuleId());
                    WebModuleUtil.refreshWAC(servletContext, false, mod);
                    log.debug("Done refreshing context for module {} (re-trying)", (Object)mod.getModuleId());
                    WebModuleUtil.notifySuperUsersAboutModuleFailure(mod);
                }
            }
            if (!delayContextRefresh && ModuleFactory.isModuleStarted((Module)mod)) {
                log.debug("Loading servlets and filters for module {}", (Object)mod);
                servletContext.setAttribute("OPENMRS_TLD_SCAN_NEEDED", (Object)true);
                WebModuleUtil.loadServlets(mod, servletContext);
                WebModuleUtil.loadFilters(mod, servletContext);
            }
            return moduleNeedsContextRefresh && delayContextRefresh;
        }
        return false;
    }

    private static void stopTasks(Module mod) {
        SchedulerService schedulerService;
        try {
            schedulerService = Context.getSchedulerService();
        }
        catch (NullPointerException | APIException e) {
            return;
        }
        String modulePackageName = mod.getPackageName();
        for (TaskDefinition task : schedulerService.getRegisteredTasks()) {
            String taskClass = task.getTaskClass();
            if (!WebModuleUtil.isModulePackageNameInTaskClass(modulePackageName, taskClass)) continue;
            try {
                schedulerService.shutdownTask(task);
            }
            catch (SchedulerException e) {
                log.error("Couldn't stop task:" + task + " for module: " + mod);
            }
        }
    }

    public static boolean isModulePackageNameInTaskClass(String modulePackageName, String taskClass) {
        return modulePackageName.length() <= taskClass.length() && taskClass.matches(Pattern.quote(modulePackageName) + "(\\..*)+");
    }

    private static void notifySuperUsersAboutModuleFailure(Module mod) {
        try {
            Context.addProxyPrivilege((String)"Manage Alerts");
            Context.addProxyPrivilege((String)"Get Users");
            Context.getAlertService().notifySuperUsers("Module.startupError.notification.message", null, new Object[]{mod.getName()});
        }
        finally {
            Context.removeProxyPrivilege((String)"Get Users");
            Context.removeProxyPrivilege((String)"Manage Alerts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadServlets(Module mod, ServletContext servletContext) {
        Element rootNode = mod.getConfig().getDocumentElement();
        NodeList servletTags = rootNode.getElementsByTagName("servlet");
        for (int i = 0; i < servletTags.getLength(); ++i) {
            HttpServlet httpServlet;
            Node node = servletTags.item(i);
            NodeList childNodes = node.getChildNodes();
            String name = "";
            String className = "";
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                if ("servlet-name".equals(childNode.getNodeName())) {
                    if (childNode.getTextContent() == null) continue;
                    name = childNode.getTextContent().trim();
                    continue;
                }
                if ("servlet-class".equals(childNode.getNodeName()) && childNode.getTextContent() != null) {
                    className = childNode.getTextContent().trim();
                    continue;
                }
                if (!"init-param".equals(childNode.getNodeName())) continue;
                NodeList initParamChildren = childNode.getChildNodes();
                String paramName = null;
                String paramValue = null;
                for (int k = 0; k < initParamChildren.getLength(); ++k) {
                    Node initParamChild = initParamChildren.item(k);
                    if ("param-name".equals(initParamChild.getNodeName()) && initParamChild.getTextContent() != null) {
                        paramName = initParamChild.getTextContent().trim();
                        continue;
                    }
                    if (!"param-value".equals(initParamChild.getNodeName()) || initParamChild.getTextContent() == null) continue;
                    paramValue = initParamChild.getTextContent().trim();
                }
                if (paramName == null || paramValue == null) continue;
                initParams.put(paramName, paramValue);
            }
            if (name.length() == 0 || className.length() == 0) {
                log.warn("both 'servlet-name' and 'servlet-class' are required for the 'servlet' tag. Given '" + name + "' and '" + className + "' for module " + mod.getName());
                continue;
            }
            try {
                httpServlet = (HttpServlet)ModuleFactory.getModuleClassLoader((Module)mod).loadClass(className).newInstance();
            }
            catch (ClassCastException e) {
                log.warn("Class {} from module {} is not a valid HttpServlet", new Object[]{className, mod, e});
                continue;
            }
            catch (ClassNotFoundException e) {
                log.warn("Class {} not found for servlet {} from module {}", new Object[]{className, name, mod, e});
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn("Class {} cannot be accessed for servlet {} from module {}", new Object[]{className, name, mod, e});
                continue;
            }
            catch (InstantiationException e) {
                log.warn("Class {} cannot be instantiated for servlet {} from module {}", new Object[]{className, name, mod, e});
                continue;
            }
            try {
                log.debug("Initializing {} servlet. - {}.", (Object)name, (Object)httpServlet);
                ModuleServlet.SimpleServletConfig servletConfig = new ModuleServlet.SimpleServletConfig(name, servletContext, initParams);
                httpServlet.init((ServletConfig)servletConfig);
            }
            catch (Exception e) {
                log.warn("Unable to initialize servlet {}", (Object)name, (Object)e);
                throw new ModuleException("Unable to initialize servlet " + name, mod.getModuleId(), (Throwable)e);
            }
            HttpServlet otherServletUsingSameName = MODULE_SERVLETS.get(name);
            if (otherServletUsingSameName != null) {
                String otherServletName = otherServletUsingSameName.getClass().getName();
                throw new ModuleException("A servlet mapping with name " + name + " is already in use and pointing at: " + otherServletName + " from another installed module and this module is trying to use that same name.  Either the module attempting to be installed (" + mod + ") will not work or the other one will not.  Please consult the developers of these two modules to sort this out.");
            }
            log.debug("Caching the {} servlet.", (Object)name);
            SERVLET_LOCK.lock();
            try {
                MODULE_SERVLETS.put(name, httpServlet);
                continue;
            }
            finally {
                SERVLET_LOCK.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadServlets(Module mod) {
        Element rootNode = mod.getConfig().getDocumentElement();
        NodeList servletTags = rootNode.getElementsByTagName("servlet");
        for (int i = 0; i < servletTags.getLength(); ++i) {
            Node node = servletTags.item(i);
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                HttpServlet servlet;
                Node childNode = childNodes.item(j);
                if (!"servlet-name".equals(childNode.getNodeName()) || childNode.getTextContent() == null) continue;
                String name = childNode.getTextContent().trim();
                SERVLET_LOCK.lock();
                try {
                    servlet = MODULE_SERVLETS.get(name);
                }
                finally {
                    SERVLET_LOCK.unlock();
                }
                if (servlet != null) {
                    servlet.destroy();
                }
                SERVLET_LOCK.lock();
                try {
                    MODULE_SERVLETS.remove(name);
                    continue;
                }
                finally {
                    SERVLET_LOCK.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFilters(Module module, ServletContext servletContext) {
        HashMap<String, Filter> existingFilters;
        LinkedHashMap<String, Filter> filters = new LinkedHashMap<String, Filter>();
        FILTERS_LOCK.lock();
        try {
            existingFilters = new HashMap<String, Filter>(MODULE_FILTERS_BY_NAME);
        }
        finally {
            FILTERS_LOCK.unlock();
        }
        for (ModuleFilterDefinition def : ModuleFilterDefinition.retrieveFilterDefinitions(module)) {
            Filter filter;
            String name = def.getFilterName();
            String className = def.getFilterClass();
            if (existingFilters.containsKey(name)) {
                throw new ModuleException("A filter with the name " + name + " is already in use and pointing at: " + ((Filter)existingFilters.get(name)).getClass().getName() + " from another installed module and this module is trying to use that same name.  Either the module attempting to be installed (" + module + ") will not work or the other one will not.  Please consult the developers of these two modules to sort this out.");
            }
            ModuleFilterConfig config = ModuleFilterConfig.getInstance(def, servletContext);
            try {
                filter = (Filter)ModuleFactory.getModuleClassLoader((Module)module).loadClass(className).newInstance();
            }
            catch (ClassCastException e) {
                log.warn("Class {} from module {} is not a valid Filter", new Object[]{className, module, e});
                continue;
            }
            catch (ClassNotFoundException e) {
                log.warn("Class {} not found for servlet {} from module {}", new Object[]{className, name, module, e});
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn("Class {} cannot be accessed for servlet {} from module {}", new Object[]{className, name, module, e});
                continue;
            }
            catch (InstantiationException e) {
                log.warn("Class {} cannot be instantiated for servlet {} from module {}", new Object[]{className, name, module, e});
                continue;
            }
            try {
                log.debug("Initializing {} filter. - {}.", (Object)name, (Object)filter);
                filter.init((FilterConfig)config);
            }
            catch (Exception e) {
                log.warn("Unable to initialize servlet {}", (Object)name, (Object)e);
                throw new ModuleException("Unable to initialize servlet " + name, module.getModuleId(), (Throwable)e);
            }
            filters.put(name, filter);
        }
        FILTERS_LOCK.lock();
        try {
            MODULE_FILTERS.put(module, filters.values());
            MODULE_FILTERS_BY_NAME.putAll(filters);
            log.debug("Module {} successfully loaded {} filters.", (Object)module, (Object)filters.size());
            Deque<ModuleFilterMapping> modMappings = ModuleFilterMapping.retrieveFilterMappings(module);
            modMappings.descendingIterator().forEachRemaining(MODULE_FILTER_MAPPINGS::addFirst);
            log.debug("Module {} successfully loaded {} filter mappings.", (Object)module, (Object)modMappings.size());
        }
        finally {
            FILTERS_LOCK.unlock();
        }
    }

    public static void unloadFilters(Module module) {
        Iterator<ModuleFilterMapping> mapIter = MODULE_FILTER_MAPPINGS.iterator();
        while (mapIter.hasNext()) {
            ModuleFilterMapping mapping = mapIter.next();
            if (!module.equals((Object)mapping.getModule())) continue;
            mapIter.remove();
            log.debug("Removed ModuleFilterMapping: " + mapping);
        }
        Collection<Filter> filters = MODULE_FILTERS.get(module);
        if (filters != null) {
            try {
                for (Filter f : filters) {
                    f.destroy();
                }
            }
            catch (Exception e) {
                log.warn("An error occurred while trying to destroy and remove module Filter.", (Throwable)e);
            }
            log.debug("Module: " + module.getModuleId() + " successfully unloaded " + filters.size() + " filters.");
            MODULE_FILTERS.remove(module);
            MODULE_FILTERS_BY_NAME.values().removeIf(filters::contains);
        }
    }

    public static Collection<Filter> getFilters() {
        return MODULE_FILTERS_BY_NAME.values();
    }

    public static Collection<ModuleFilterMapping> getFilterMappings() {
        return new ArrayList<ModuleFilterMapping>(MODULE_FILTER_MAPPINGS);
    }

    public static List<Filter> getFiltersForRequest(ServletRequest request) {
        HttpServletRequest httpRequest;
        String requestPath;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (request != null && (requestPath = (httpRequest = (HttpServletRequest)request).getRequestURI()) != null) {
            if (requestPath.startsWith(httpRequest.getContextPath())) {
                requestPath = requestPath.substring(httpRequest.getContextPath().length());
            }
            for (ModuleFilterMapping filterMapping : WebModuleUtil.getFilterMappings()) {
                if (!ModuleFilterMapping.filterMappingPasses(filterMapping, requestPath)) continue;
                Filter passedFilter = MODULE_FILTERS_BY_NAME.get(filterMapping.getFilterName());
                if (passedFilter != null) {
                    filters.add(passedFilter);
                    continue;
                }
                log.warn("Unable to retrieve filter that has a name of " + filterMapping.getFilterName() + " in filter mapping.");
            }
        }
        return filters;
    }

    private static Document getDWRModuleXML(InputStream inputStream, String realPath) {
        Document dwrmodulexml;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            dwrmodulexml = db.parse(inputStream);
        }
        catch (Exception e) {
            throw new ModuleException("Error parsing dwr-modules.xml file", (Throwable)e);
        }
        return dwrmodulexml;
    }

    public static void shutdownModules(ServletContext servletContext) {
        String realPath = WebModuleUtil.getRealPath(servletContext);
        String messagesPath = realPath + "/WEB-INF/";
        File folder = new File(messagesPath.replace("/", File.separator));
        File[] files = folder.listFiles();
        if (folder.exists() && files != null) {
            Properties emptyProperties = new Properties();
            for (File f : files) {
                if (!f.getName().startsWith("module_messages")) continue;
                OpenmrsUtil.storeProperties((Properties)emptyProperties, (File)f, (String)"");
            }
        }
        for (Module mod : ModuleFactory.getLoadedModules()) {
            WebModuleUtil.stopModule(mod, servletContext, true);
        }
    }

    public static void stopModule(Module mod, ServletContext servletContext) {
        WebModuleUtil.stopModule(mod, servletContext, false);
    }

    public static void stopModule(Module mod, ServletContext servletContext, boolean skipRefresh) {
        String moduleId = mod.getModuleId();
        String modulePackage = mod.getPackageName();
        for (Module dependentModule : ModuleFactory.getStartedModules()) {
            if (dependentModule.equals((Object)mod) || !dependentModule.getRequiredModules().contains(modulePackage)) continue;
            WebModuleUtil.stopModule(dependentModule, servletContext, skipRefresh);
        }
        String realPath = WebModuleUtil.getRealPath(servletContext);
        String absPath = realPath + "/WEB-INF/view/module/" + moduleId;
        File moduleWebFolder = new File(absPath.replace("/", File.separator));
        if (moduleWebFolder.exists()) {
            try {
                OpenmrsUtil.deleteDirectory((File)moduleWebFolder);
            }
            catch (IOException io) {
                log.warn("Couldn't delete: " + moduleWebFolder.getAbsolutePath(), (Throwable)io);
            }
        }
        WebModuleUtil.unloadServlets(mod);
        WebModuleUtil.unloadFilters(mod);
        WebModuleUtil.stopTasks(mod);
        InputStream inputStream = null;
        try {
            Document config = mod.getConfig();
            Element root = config.getDocumentElement();
            if (root.getElementsByTagName("dwr").getLength() > 0) {
                File f = new File(realPath + "/WEB-INF/dwr-modules.xml".replace("/", File.separator));
                if (!f.exists()) {
                    WebModuleUtil.createDwrModulesXml(realPath);
                }
                inputStream = new FileInputStream(f);
                Document dwrmodulexml = WebModuleUtil.getDWRModuleXML(inputStream, realPath);
                Element outputRoot = dwrmodulexml.getDocumentElement();
                NodeList nodeList = outputRoot.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node current = nodeList.item(i);
                    if ("allow".equals(current.getNodeName()) || "signatures".equals(current.getNodeName())) {
                        NamedNodeMap attrs = current.getAttributes();
                        Node attr = attrs.getNamedItem("moduleId");
                        if (attr != null && moduleId.equals(attr.getNodeValue())) {
                            outputRoot.removeChild(current);
                            continue;
                        }
                        ++i;
                        continue;
                    }
                    ++i;
                }
                OpenmrsUtil.saveDocument((Document)dwrmodulexml, (File)f);
            }
        }
        catch (FileNotFoundException e) {
            throw new ModuleException(realPath + "/WEB-INF/dwr-modules.xml file doesn't exist.", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException io) {
                    log.error("Error while closing input stream", (Throwable)io);
                }
            }
        }
        if (!skipRefresh) {
            WebModuleUtil.refreshWAC(servletContext, false, null);
        }
    }

    public static XmlWebApplicationContext refreshWAC(ServletContext servletContext, boolean isOpenmrsStartup, Module startedModule) {
        XmlWebApplicationContext wac = (XmlWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        log.debug("Refreshing Web Application Context of class: {}", (Object)wac.getClass().getName());
        if (dispatcherServlet != null) {
            dispatcherServlet.stopAndCloseApplicationContext();
        }
        if (staticDispatcherServlet != null) {
            staticDispatcherServlet.stopAndCloseApplicationContext();
        }
        XmlWebApplicationContext newAppContext = (XmlWebApplicationContext)ModuleUtil.refreshApplicationContext((AbstractRefreshableApplicationContext)wac, (boolean)isOpenmrsStartup, (Module)startedModule);
        try {
            if (dispatcherServlet != null) {
                dispatcherServlet.reInitFrameworkServlet();
            }
            if (staticDispatcherServlet != null) {
                staticDispatcherServlet.refreshApplicationContext();
            }
        }
        catch (ServletException se) {
            log.warn("Caught a servlet exception while refreshing the dispatcher servlet", (Throwable)se);
        }
        return newAppContext;
    }

    public static void setDispatcherServlet(DispatcherServlet ds) {
        log.debug("Setting dispatcher servlet: " + (Object)((Object)ds));
        dispatcherServlet = ds;
    }

    public static void setStaticDispatcherServlet(StaticDispatcherServlet ds) {
        log.debug("Setting dispatcher servlet for static content: " + (Object)((Object)ds));
        staticDispatcherServlet = ds;
    }

    public static HttpServlet getServlet(String servletName) {
        return MODULE_SERVLETS.get(servletName);
    }

    public static String getModuleWebFolder(String moduleId) {
        if (dispatcherServlet == null) {
            throw new ModuleException("Dispatcher servlet must be present in the web environment");
        }
        String moduleFolder = "WEB-INF/view/module/";
        String realPath = dispatcherServlet.getServletContext().getRealPath("");
        String moduleWebFolder = realPath.endsWith(File.separator) || realPath.endsWith("/") ? realPath + moduleFolder : realPath + "/" + moduleFolder;
        moduleWebFolder = moduleWebFolder + moduleId;
        return moduleWebFolder.replace("/", File.separator);
    }

    public static void createDwrModulesXml(String realPath) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("dwr");
            doc.appendChild(rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(realPath + "/WEB-INF/dwr-modules.xml".replace("/", File.separator)));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            log.error("Failed to parse document", (Throwable)pce);
        }
        catch (TransformerException tfe) {
            log.error("Failed to transorm xml source", (Throwable)tfe);
        }
    }

    public static String getRealPath(ServletContext servletContext) {
        return servletContext.getRealPath("");
    }
}

