/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleFilterDefinition
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ModuleFilterDefinition.class);
    private Module module;
    private String filterName;
    private String filterClass;
    private Map<String, String> initParameters = new HashMap<String, String>();

    public ModuleFilterDefinition(Module module) {
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public void addInitParameter(String parameterName, String parameterValue) {
        this.initParameters.put(parameterName, parameterValue);
    }

    public static List<ModuleFilterDefinition> retrieveFilterDefinitions(Module module) {
        ArrayList<ModuleFilterDefinition> filters = new ArrayList<ModuleFilterDefinition>();
        try {
            Element rootNode = module.getConfig().getDocumentElement();
            NodeList filterNodes = rootNode.getElementsByTagName("filter");
            if (filterNodes.getLength() > 0) {
                for (int i = 0; i < filterNodes.getLength(); ++i) {
                    ModuleFilterDefinition filter = new ModuleFilterDefinition(module);
                    Node node = filterNodes.item(i);
                    NodeList configNodes = node.getChildNodes();
                    block13: for (int j = 0; j < configNodes.getLength(); ++j) {
                        Node configNode = configNodes.item(j);
                        switch (configNode.getNodeName()) {
                            case "filter-name": {
                                filter.setFilterName(configNode.getTextContent().trim());
                                continue block13;
                            }
                            case "filter-class": {
                                filter.setFilterClass(configNode.getTextContent().trim());
                                continue block13;
                            }
                            case "init-param": {
                                NodeList paramNodes = configNode.getChildNodes();
                                String paramName = "";
                                String paramValue = "";
                                for (int k = 0; k < paramNodes.getLength(); ++k) {
                                    Node paramNode = paramNodes.item(k);
                                    if ("param-name".equals(paramNode.getNodeName())) {
                                        paramName = paramNode.getTextContent().trim();
                                        continue;
                                    }
                                    if (!"param-value".equals(paramNode.getNodeName())) continue;
                                    paramValue = paramNode.getTextContent().trim();
                                }
                                filter.addInitParameter(paramName, paramValue);
                            }
                        }
                    }
                    filters.add(filter);
                }
            }
        }
        catch (Exception e) {
            throw new ModuleException("Unable to parse filters in module configuration.", (Throwable)e);
        }
        log.debug("Retrieved {} filters for {}: {}", new Object[]{filters.size(), module, filters});
        return filters;
    }
}

