/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.module.web.filter;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleFilterMapping
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ModuleFilterMapping.class);
    private static final Deque<ModuleFilterMapping> EMPTY_DEQUE = new ArrayDeque<ModuleFilterMapping>(0);
    private Module module;
    private String filterName;
    private List<String> servletNames = new ArrayList<String>();
    private List<String> urlPatterns = new ArrayList<String>();

    public ModuleFilterMapping(Module module) {
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public List<String> getServletNames() {
        return this.servletNames;
    }

    public void setServletNames(List<String> servletNames) {
        this.servletNames = servletNames;
    }

    public void addServletName(String servletName) {
        this.servletNames.add(servletName);
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(List<String> urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public void addUrlPattern(String urlPattern) {
        this.urlPatterns.add(urlPattern);
    }

    public static boolean filterMappingPasses(ModuleFilterMapping filterMapping, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        for (String patternToCheck : filterMapping.getUrlPatterns()) {
            if (!ModuleFilterMapping.urlPatternMatches(patternToCheck, requestPath)) continue;
            return true;
        }
        for (String patternToCheck : filterMapping.getServletNames()) {
            if (!ModuleFilterMapping.servletNameMatches(patternToCheck, requestPath)) continue;
            return true;
        }
        return false;
    }

    public static boolean urlPatternMatches(String patternToCheck, String requestPath) {
        if (patternToCheck == null) {
            return false;
        }
        log.debug("Checking URL <" + requestPath + "> against pattern <" + patternToCheck + ">");
        if ("*".equals(patternToCheck) || "/*".equals(patternToCheck) || patternToCheck.equals(requestPath)) {
            return true;
        }
        if (patternToCheck.endsWith("/*")) {
            int patternLength = patternToCheck.length() - 2;
            if (patternToCheck.regionMatches(0, requestPath, 0, patternLength)) {
                return requestPath.length() == patternLength || '/' == requestPath.charAt(patternLength);
            }
            return false;
        }
        if (patternToCheck.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            int reqLen = requestPath.length();
            int patLen = patternToCheck.length();
            if (slash >= 0 && period > slash && period != reqLen - 1 && reqLen - period == patLen - 1) {
                return patternToCheck.regionMatches(2, requestPath, period + 1, patLen - 2);
            }
        }
        return false;
    }

    public static boolean servletNameMatches(String patternToCheck, String servletName) {
        if (servletName == null) {
            return false;
        }
        log.debug("Checking servlet <" + servletName + "> against pattern <" + patternToCheck + ">");
        return "*".equals(patternToCheck) || servletName.equals(patternToCheck);
    }

    public static Deque<ModuleFilterMapping> retrieveFilterMappings(Module module) {
        try {
            Element rootNode = module.getConfig().getDocumentElement();
            NodeList mappingNodes = rootNode.getElementsByTagName("filter-mapping");
            if (mappingNodes.getLength() > 0) {
                ArrayDeque<ModuleFilterMapping> mappings = new ArrayDeque<ModuleFilterMapping>(mappingNodes.getLength());
                for (int i = 0; i < mappingNodes.getLength(); ++i) {
                    ModuleFilterMapping mapping = new ModuleFilterMapping(module);
                    Node node = mappingNodes.item(i);
                    NodeList configNodes = node.getChildNodes();
                    block13: for (int j = 0; j < configNodes.getLength(); ++j) {
                        Node configNode = configNodes.item(j);
                        switch (configNode.getNodeName()) {
                            case "filter-name": {
                                mapping.setFilterName(configNode.getTextContent());
                                continue block13;
                            }
                            case "url-pattern": {
                                mapping.addUrlPattern(configNode.getTextContent());
                                continue block13;
                            }
                            case "servlet-name": {
                                mapping.addServletName(configNode.getTextContent());
                            }
                        }
                    }
                    mappings.add(mapping);
                }
                log.debug("Retrieved {} filter-mappings for {}: {}", new Object[]{mappings.size(), module, mappings});
                return mappings;
            }
        }
        catch (Exception e) {
            throw new ModuleException("Unable to parse filters in module configuration.", (Throwable)e);
        }
        return EMPTY_DEQUE;
    }
}

