/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleFactory;
import org.openmrs.module.web.WebModuleUtil;
import org.openmrs.util.DatabaseUpdater;
import org.openmrs.util.OpenmrsClassLoader;
import org.openmrs.web.filter.initialization.InitializationFilter;
import org.openmrs.web.filter.update.UpdateFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class DispatcherServlet
extends org.springframework.web.servlet.DispatcherServlet {
    private static final long serialVersionUID = -6925172744402818729L;
    private static final Logger log = LoggerFactory.getLogger(DispatcherServlet.class);

    protected void initFrameworkServlet() throws ServletException, BeansException {
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        log.debug("Framework being initialized");
        WebModuleUtil.setDispatcherServlet(this);
        super.initFrameworkServlet();
    }

    public void reInitFrameworkServlet() throws ServletException {
        log.debug("Framework being REinitialized");
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        ((XmlWebApplicationContext)this.getWebApplicationContext()).setClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        this.init();
        for (Module module : ModuleFactory.getStartedModules()) {
            ModuleFactory.loadAdvice((Module)module);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (UpdateFilter.updatesRequired() && !DatabaseUpdater.allowAutoUpdate().booleanValue()) {
            log.info("DB updates are required, the update wizard must be run");
        }
        if (InitializationFilter.initializationRequired()) {
            log.info("Runtime properties were not found or the database is empty, so initialization is required");
        }
    }

    public void stopAndCloseApplicationContext() {
        try {
            XmlWebApplicationContext ctx = (XmlWebApplicationContext)this.getWebApplicationContext();
            ctx.stop();
            ctx.close();
        }
        catch (Exception e) {
            log.error("Exception while stopping and closing dispatcherServlet context: ", (Throwable)e);
        }
    }
}

