/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.openmrs.api.context.Context;
import org.openmrs.module.MandatoryModuleException;
import org.openmrs.module.Module;
import org.openmrs.module.ModuleFactory;
import org.openmrs.module.ModuleMustStartException;
import org.openmrs.module.web.WebModuleUtil;
import org.openmrs.scheduler.SchedulerUtil;
import org.openmrs.util.DatabaseUpdateException;
import org.openmrs.util.DatabaseUpdater;
import org.openmrs.util.InputRequiredException;
import org.openmrs.util.MemoryLeakUtil;
import org.openmrs.util.OpenmrsClassLoader;
import org.openmrs.util.OpenmrsConstants;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.web.WebConstants;
import org.openmrs.web.WebDaemon;
import org.openmrs.web.filter.initialization.DatabaseDetective;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class Listener
extends ContextLoader
implements ServletContextListener,
HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private static boolean runtimePropertiesFound = false;
    private static Throwable errorAtStartup = null;
    private static boolean setupNeeded = false;
    private static boolean openmrsStarted = false;

    public static boolean runtimePropertiesFound() {
        return runtimePropertiesFound;
    }

    public static boolean errorOccurredAtStartup() {
        return errorAtStartup != null;
    }

    public static boolean isSetupNeeded() {
        return setupNeeded;
    }

    public static boolean isOpenmrsStarted() {
        return openmrsStarted;
    }

    public static Throwable getErrorAtStartup() {
        return errorAtStartup;
    }

    public static void setRuntimePropertiesFound(boolean runtimePropertiesFound) {
        Listener.runtimePropertiesFound = runtimePropertiesFound;
    }

    public static void setErrorAtStartup(Throwable errorAtStartup) {
        Listener.errorAtStartup = errorAtStartup;
    }

    public void sessionCreated(HttpSessionEvent se) {
        for (HttpSessionListener listener : this.getHttpSessionListeners()) {
            listener.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        for (HttpSessionListener listener : this.getHttpSessionListeners()) {
            listener.sessionDestroyed(se);
        }
    }

    private List<HttpSessionListener> getHttpSessionListeners() {
        List httpSessionListeners = Collections.emptyList();
        if (openmrsStarted) {
            try {
                httpSessionListeners = Context.getRegisteredComponents(HttpSessionListener.class);
            }
            catch (Exception e) {
                log.warn("An error occurred trying to retrieve HttpSessionListener beans from the context", (Throwable)e);
            }
        }
        return httpSessionListeners;
    }

    public void contextInitialized(ServletContextEvent event) {
        log.debug("Starting the OpenMRS webapp");
        try {
            OpenmrsUtil.validateJavaVersion();
            ServletContext servletContext = event.getServletContext();
            this.loadConstants(servletContext);
            this.clearDWRFile(servletContext);
            this.setApplicationDataDirectory(servletContext);
            Properties props = Listener.getRuntimeProperties();
            if (props != null) {
                Listener.setRuntimePropertiesFound(true);
                Context.setRuntimeProperties((Properties)props);
                String appDataRuntimeProperty = props.getProperty("application_data_directory", null);
                if (StringUtils.hasLength((String)appDataRuntimeProperty)) {
                    OpenmrsUtil.setApplicationDataDirectory(null);
                }
                log.warn("Using runtime properties file: {}", (Object)OpenmrsUtil.getRuntimePropertiesFilePathName((String)WebConstants.WEBAPP_NAME));
            }
            this.loadCsrfGuardProperties(servletContext);
            Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
            if (!this.setupNeeded()) {
                this.copyCustomizationIntoWebapp(servletContext, props);
                log.debug("Refreshing WAC");
                XmlWebApplicationContext context = (XmlWebApplicationContext)this.createWebApplicationContext(servletContext);
                this.configureAndRefreshWebApplicationContext((ConfigurableWebApplicationContext)context, servletContext);
                servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
                log.debug("Done refreshing WAC");
                WebDaemon.startOpenmrs(event.getServletContext());
            } else {
                setupNeeded = true;
            }
        }
        catch (Exception e) {
            Listener.setErrorAtStartup(e);
            log.error(MarkerFactory.getMarker((String)"FATAL"), "Failed to obtain JDBC connection", (Throwable)e);
        }
    }

    private void loadCsrfGuardProperties(ServletContext servletContext) throws IOException {
        Properties csrfGuardProperties;
        block32: {
            File csrfGuardFile = new File(OpenmrsUtil.getApplicationDataDirectory(), "csrfguard.properties");
            csrfGuardProperties = new Properties();
            if (csrfGuardFile.exists()) {
                try (InputStream csrfGuardInputStream = Files.newInputStream(csrfGuardFile.toPath(), new OpenOption[0]);){
                    csrfGuardProperties.load(csrfGuardInputStream);
                    break block32;
                }
                catch (Exception e) {
                    log.error("Error loading csrfguard.properties file at " + csrfGuardFile.getAbsolutePath(), (Throwable)e);
                    throw e;
                }
            }
            String fileName = servletContext.getRealPath("/WEB-INF/csrfguard.properties");
            try (InputStream csrfGuardInputStream = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);){
                csrfGuardProperties.load(csrfGuardInputStream);
            }
            catch (Exception e) {
                log.error("Error loading csrfguard.properties file at " + fileName, (Throwable)e);
                throw e;
            }
        }
        Properties runtimeProperties = Listener.getRuntimeProperties();
        if (runtimeProperties != null) {
            runtimeProperties.stringPropertyNames().forEach(property -> {
                if (property.startsWith("org.owasp.csrfguard")) {
                    csrfGuardProperties.setProperty((String)property, runtimeProperties.getProperty((String)property));
                }
            });
        }
        CsrfGuard.load((Properties)csrfGuardProperties);
        try {
            Field field = CsrfGuardServletContextListener.class.getDeclaredField("servletContext");
            field.setAccessible(true);
            field.set(null, servletContext.getContextPath());
        }
        catch (Exception ex) {
            log.error("Failed to set the CSRFGuard servlet context", (Throwable)ex);
        }
    }

    private boolean setupNeeded() throws Exception {
        if (!runtimePropertiesFound) {
            return true;
        }
        DatabaseDetective databaseDetective = new DatabaseDetective();
        if (databaseDetective.isDatabaseEmpty(OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME))) {
            return true;
        }
        return DatabaseUpdater.updatesRequired() && DatabaseUpdater.allowAutoUpdate() == false;
    }

    public static void startOpenmrs(ServletContext servletContext) throws ServletException {
        openmrsStarted = false;
        try {
            log.debug("Loading bundled modules");
            Listener.loadBundledModules(servletContext);
            Context.startup((Properties)Listener.getRuntimeProperties());
        }
        catch (DatabaseUpdateException | InputRequiredException updateEx) {
            throw new ServletException("Should not be here because updates were run previously", updateEx);
        }
        catch (MandatoryModuleException mandatoryModEx) {
            throw new ServletException((Throwable)mandatoryModEx);
        }
        try {
            log.debug("Performing start of modules");
            Listener.performWebStartOfModules(servletContext);
            SchedulerUtil.startup((Properties)Listener.getRuntimeProperties());
        }
        catch (Exception t) {
            try {
                Context.shutdown();
                WebModuleUtil.shutdownModules(servletContext);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ServletException((Throwable)t);
        }
        finally {
            Context.closeSession();
        }
        openmrsStarted = true;
    }

    private void loadConstants(ServletContext servletContext) {
        WebConstants.BUILD_TIMESTAMP = servletContext.getInitParameter("build.timestamp");
        WebConstants.WEBAPP_NAME = this.getContextPath(servletContext);
        WebConstants.MODULE_REPOSITORY_URL = servletContext.getInitParameter("module.repository.url");
        if (!"openmrs".equalsIgnoreCase(WebConstants.WEBAPP_NAME)) {
            OpenmrsConstants.KEY_OPENMRS_APPLICATION_DATA_DIRECTORY = WebConstants.WEBAPP_NAME + "_APPLICATION_DATA_DIRECTORY";
        }
    }

    private void setApplicationDataDirectory(ServletContext servletContext) {
        String appDataDir = servletContext.getInitParameter("application.data.directory");
        if (StringUtils.hasLength((String)appDataDir)) {
            OpenmrsUtil.setApplicationDataDirectory((String)appDataDir);
        } else if (!"openmrs".equalsIgnoreCase(WebConstants.WEBAPP_NAME)) {
            OpenmrsUtil.setApplicationDataDirectory((String)Paths.get(OpenmrsUtil.getApplicationDataDirectory(), WebConstants.WEBAPP_NAME).toString());
        }
    }

    private String getContextPath(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDWRFile(ServletContext servletContext) {
        File dwrFile = Paths.get(servletContext.getRealPath(""), "WEB-INF", "dwr-modules.xml").toFile();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = db.parse(dwrFile);
            Element elem = doc.getDocumentElement();
            elem.setTextContent("");
            OpenmrsUtil.saveDocument((Document)doc, (File)dwrFile);
        }
        catch (Exception e) {
            log.debug("Error clearing dwr-modules.xml", (Throwable)e);
            dwrFile.delete();
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dwrFile), StandardCharsets.UTF_8);
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE dwr PUBLIC \"-//GetAhead Limited//DTD Direct Web Remoting 2.0//EN\" \"http://directwebremoting.org/schema/dwr20.dtd\">\n<dwr></dwr>");
            }
            catch (IOException io) {
                log.error("Unable to clear out the " + dwrFile.getAbsolutePath() + " file.  Please redeploy the openmrs war file", (Throwable)io);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException io) {
                        log.warn("Couldn't close Writer: " + io);
                    }
                }
            }
        }
    }

    private void copyCustomizationIntoWebapp(ServletContext servletContext, Properties props) {
        String realPath = servletContext.getRealPath("");
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("custom.template.dir", "/WEB-INF/template");
        custom.put("custom.index.jsp.file", "/WEB-INF/view/index.jsp");
        custom.put("custom.login.jsp.file", "/WEB-INF/view/login.jsp");
        custom.put("custom.patientDashboardForm.jsp.file", "/WEB-INF/view/patientDashboardForm.jsp");
        custom.put("custom.images.dir", "/images");
        custom.put("custom.style.css.file", "/style.css");
        custom.put("custom.messages", "/WEB-INF/custom_messages.properties");
        custom.put("custom.messages_fr", "/WEB-INF/custom_messages_fr.properties");
        custom.put("custom.messages_es", "/WEB-INF/custom_messages_es.properties");
        custom.put("custom.messages_de", "/WEB-INF/custom_messages_de.properties");
        for (Map.Entry entry : custom.entrySet()) {
            String prop = (String)entry.getKey();
            String webappPath = (String)entry.getValue();
            String userOverridePath = props.getProperty(prop);
            if (userOverridePath == null) continue;
            String absolutePath = realPath + webappPath;
            File file = new File(userOverridePath);
            if (!file.exists() || userOverridePath.startsWith(".")) continue;
            log.debug("Overriding file: " + absolutePath);
            log.debug("Overriding file with: " + userOverridePath);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    String tmpAbsolutePath;
                    userOverridePath = f.getAbsolutePath();
                    if (f.getName().startsWith(".") || this.copyFile(userOverridePath, tmpAbsolutePath = absolutePath + "/" + f.getName())) continue;
                    log.warn("Unable to copy file in folder defined by runtime property: " + prop);
                    log.warn("Your source directory (or a file in it) '" + userOverridePath + " cannot be loaded or destination '" + tmpAbsolutePath + "' cannot be found");
                }
                continue;
            }
            if (this.copyFile(userOverridePath, absolutePath)) continue;
            log.warn("Unable to copy file defined by runtime property: " + prop);
            log.warn("Your source file '" + userOverridePath + " cannot be loaded or destination '" + absolutePath + "' cannot be found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(String fromPath, String toPath) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(fromPath);
            outputStream = new FileOutputStream(toPath);
            OpenmrsUtil.copyFile((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException io) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException io) {
                log.warn("Unable to close input stream", (Throwable)io);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException io) {
                log.warn("Unable to close input stream", (Throwable)io);
            }
        }
        return true;
    }

    public static void loadBundledModules(ServletContext servletContext) {
        File folder = Paths.get(servletContext.getRealPath(""), "WEB-INF", "bundledModules").toFile();
        if (!folder.exists()) {
            log.warn("Bundled module folder doesn't exist: " + folder.getAbsolutePath());
            return;
        }
        if (!folder.isDirectory()) {
            log.warn("Bundled module folder isn't really a directory: " + folder.getAbsolutePath());
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().startsWith(".")) continue;
                try {
                    Module mod = ModuleFactory.loadModule((File)f);
                    log.debug("Loaded bundled module: " + mod + " successfully");
                }
                catch (Exception e) {
                    log.warn("Error while trying to load bundled module " + f.getName() + "", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        try {
            openmrsStarted = false;
            Context.openSession();
            Context.shutdown();
            WebModuleUtil.shutdownModules(event.getServletContext());
        }
        catch (Exception e) {
            if (!"contextDAO is null".equals(e.getMessage())) {
                System.out.println("Listener.contextDestroyed: Error while shutting down openmrs: ");
                log.error("Listener.contextDestroyed: Error while shutting down openmrs: ", (Throwable)e);
            }
        }
        finally {
            if ("true".equalsIgnoreCase(System.getProperty("FUNCTIONAL_TEST_MODE"))) {
                String filename = WebConstants.WEBAPP_NAME + "-test-runtime.properties";
                File file = new File(OpenmrsUtil.getApplicationDataDirectory(), filename);
                System.out.println(filename + " delete=" + file.delete());
            }
            Context.closeSession();
        }
        try {
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                ClassLoader classLoader = driver.getClass().getClassLoader();
                if (classLoader == null || classLoader == ((Object)((Object)this)).getClass().getClassLoader()) {
                    DriverManager.deregisterDriver(driver);
                    continue;
                }
                System.err.println("Didn't remove driver class: " + driver.getClass() + " with classloader of: " + driver.getClass().getClassLoader());
            }
        }
        catch (Exception e) {
            System.err.println("Listener.contextDestroyed: Failed to cleanup drivers in webapp");
            log.error("Listener.contextDestroyed: Failed to cleanup drivers in webapp", (Throwable)e);
        }
        MemoryLeakUtil.shutdownMysqlCancellationTimer();
        OpenmrsClassLoader.onShutdown();
        LogManager.shutdown();
        System.gc();
        System.gc();
    }

    public static Properties getRuntimeProperties() {
        return OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME);
    }

    public static void performWebStartOfModules(ServletContext servletContext) throws ModuleMustStartException, Exception {
        ArrayList<Module> startedModules = new ArrayList<Module>(ModuleFactory.getStartedModules());
        Listener.performWebStartOfModules(startedModules, servletContext);
    }

    public static void performWebStartOfModules(Collection<Module> startedModules, ServletContext servletContext) throws ModuleMustStartException, Exception {
        boolean someModuleNeedsARefresh = false;
        for (Module mod : startedModules) {
            log.debug("Staring module: {}", (Object)mod.getModuleId());
            try {
                boolean thisModuleCausesRefresh = WebModuleUtil.startModule(mod, servletContext, true);
                someModuleNeedsARefresh = someModuleNeedsARefresh || thisModuleCausesRefresh;
            }
            catch (Exception e) {
                mod.setStartupErrorMessage("Unable to start module", (Throwable)e);
            }
        }
        if (someModuleNeedsARefresh) {
            try {
                log.debug("Refreshing WAC as required by some module");
                WebModuleUtil.refreshWAC(servletContext, true, null);
                log.debug("Done refreshing WAC as required by some module");
            }
            catch (ModuleMustStartException | BeanCreationException ex) {
                throw ex;
            }
            catch (Exception e) {
                Throwable rootCause = Listener.getActualRootCause(e, true);
                if (rootCause != null) {
                    log.error(MarkerFactory.getMarker((String)"FATAL"), "Unable to refresh the spring application context.  Root Cause was:", rootCause);
                } else {
                    log.error(MarkerFactory.getMarker((String)"FATAL"), "nable to refresh the spring application context. Unloading all modules,  Error was:", (Throwable)e);
                }
                try {
                    WebModuleUtil.shutdownModules(servletContext);
                    for (Module mod : ModuleFactory.getLoadedModules()) {
                        if (mod.isMandatory()) continue;
                        try {
                            ModuleFactory.stopModule((Module)mod, (boolean)true, (boolean)true);
                        }
                        catch (Exception t3) {
                            log.trace("Unable to shutdown module:" + mod, (Throwable)t3);
                        }
                    }
                    log.debug("Retrying refreshing WebApplicationContext");
                    WebModuleUtil.refreshWAC(servletContext, true, null);
                    log.debug("Done refreshing WebApplicationContext");
                }
                catch (MandatoryModuleException ex) {
                    throw new MandatoryModuleException(ex.getModuleId(), "Got an error while starting a mandatory module: " + e.getMessage() + ". Check the server logs for more information");
                }
                catch (Exception t2) {
                    log.warn("caught another error: ", (Throwable)t2);
                    throw t2;
                }
            }
        }
        for (Module mod : ModuleFactory.getStartedModulesInOrder()) {
            log.debug("Loading servlets and filters for module: {}", (Object)mod.getModuleId());
            WebModuleUtil.loadServlets(mod, servletContext);
            WebModuleUtil.loadFilters(mod, servletContext);
        }
        servletContext.setAttribute("OPENMRS_TLD_SCAN_NEEDED", (Object)true);
    }

    private static Throwable getActualRootCause(Throwable t, boolean isOriginalError) {
        if (t.getCause() != null) {
            return Listener.getActualRootCause(t.getCause(), false);
        }
        if (!isOriginalError) {
            return t;
        }
        return null;
    }
}

