/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web;

import javax.servlet.ServletException;
import org.openmrs.module.web.WebModuleUtil;
import org.openmrs.util.OpenmrsClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class StaticDispatcherServlet
extends DispatcherServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(StaticDispatcherServlet.class);

    protected void initFrameworkServlet() throws ServletException, BeansException {
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        log.info("Framework being initialized for static content");
        WebModuleUtil.setStaticDispatcherServlet(this);
        super.initFrameworkServlet();
    }

    public void refreshApplicationContext() throws ServletException {
        log.info("Application context for the static content dispatcher servlet is being refreshed");
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        ((XmlWebApplicationContext)this.getWebApplicationContext()).setClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        this.refresh();
    }

    public void stopAndCloseApplicationContext() {
        try {
            XmlWebApplicationContext ctx = (XmlWebApplicationContext)this.getWebApplicationContext();
            ctx.stop();
            ctx.close();
        }
        catch (Exception e) {
            log.error("Exception while stopping and closing static content dispatcher servlet context: ", (Throwable)e);
        }
    }
}

