/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web;

import java.util.concurrent.ExecutionException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.openmrs.api.context.Daemon;
import org.openmrs.module.ModuleException;
import org.openmrs.util.DatabaseUpdateException;
import org.openmrs.util.InputRequiredException;
import org.openmrs.web.Listener;

public final class WebDaemon {
    private WebDaemon() {
    }

    public static void startOpenmrs(ServletContext servletContext) throws DatabaseUpdateException, InputRequiredException {
        try {
            Daemon.runNewDaemonTask(() -> {
                try {
                    Listener.startOpenmrs(servletContext);
                }
                catch (ServletException e) {
                    throw new ModuleException("Unable to start OpenMRS. Error thrown was: " + e.getMessage(), (Throwable)e);
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DatabaseUpdateException) {
                throw (DatabaseUpdateException)cause;
            }
            if (cause instanceof InputRequiredException) {
                throw (InputRequiredException)cause;
            }
            if (!(cause instanceof ModuleException)) {
                throw new ModuleException("Unable to start OpenMRS. Error thrown was: " + cause.getMessage(), cause);
            }
            throw (ModuleException)cause;
        }
    }
}

