/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openmrs.GlobalProperty;
import org.openmrs.api.GlobalPropertyListener;
import org.openmrs.api.context.Context;
import org.openmrs.util.Format;
import org.openmrs.util.LocaleUtility;
import org.openmrs.util.OpenmrsDateFormat;
import org.openmrs.web.WebConstants;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil
implements GlobalPropertyListener {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);

    public static String escapeHTML(String s) {
        return Encode.forHtml((String)s);
    }

    public static String encodeForCDATA(String s) {
        return Encode.forCDATA((String)s);
    }

    public static String encodeForCssString(String s) {
        return Encode.forCssString((String)s);
    }

    public static String encodeForCssUrl(String s) {
        return Encode.forCssUrl((String)s);
    }

    public static String encodeForHtmlAttribute(String s) {
        return Encode.forHtmlAttribute((String)s);
    }

    public static String encodeForHtmlContent(String s) {
        return Encode.forHtmlContent((String)s);
    }

    public static String encodeForHtmlUnquotedAttribute(String s) {
        return Encode.forHtmlUnquotedAttribute((String)s);
    }

    public static String encodeForJava(String s) {
        return Encode.forJava((String)s);
    }

    public static String encodeForJavaScript(String s) {
        return Encode.forJavaScript((String)s);
    }

    public static String encodeForJavaScriptAttribute(String s) {
        return Encode.forJavaScriptAttribute((String)s);
    }

    public static String encodeForJavaScriptBlock(String s) {
        return Encode.forJavaScriptBlock((String)s);
    }

    public static String encodeForJavaScriptSource(String s) {
        return Encode.forJavaScriptSource((String)s);
    }

    public static String encodeForUri(String s) {
        return Encode.forUri((String)s);
    }

    public static String encodeForUriComponent(String s) {
        return Encode.forUriComponent((String)s);
    }

    public static String encodeForXml(String s) {
        return Encode.forXml((String)s);
    }

    public static String encodeForXmlAttribute(String s) {
        return Encode.forXmlAttribute((String)s);
    }

    public static String encodeForXmlComment(String s) {
        return Encode.forXmlComment((String)s);
    }

    public static String encodeForXmlContent(String s) {
        return Encode.forXmlContent((String)s);
    }

    public static String escapeQuotes(String s) {
        String tmpS = s;
        if (tmpS == null) {
            return "";
        }
        tmpS = tmpS.replace("\"", "\\\"");
        return tmpS;
    }

    public static String escapeNewlines(String s) {
        String tmpS = s;
        if (tmpS == null) {
            return "";
        }
        tmpS = tmpS.replace("\n", "\\n");
        return tmpS;
    }

    public static String escapeQuotesAndNewlines(String s) {
        String tmpS = s;
        if (tmpS == null) {
            return "";
        }
        tmpS = tmpS.replace("\"", "\\\"");
        tmpS = tmpS.replace("\r\n", "\\r\\n");
        tmpS = tmpS.replace("\n", "\\n");
        return tmpS;
    }

    public static String stripFilename(String filename) {
        log.debug("Stripping filename from: {}", (Object)filename);
        String tmpFilename = filename;
        int index = tmpFilename.lastIndexOf("/");
        if (index != -1) {
            tmpFilename = tmpFilename.substring(index + 1);
        }
        if ((index = tmpFilename.lastIndexOf("\\")) != -1) {
            tmpFilename = tmpFilename.substring(index + 1);
        }
        log.debug("Returning stripped down filename: {}", (Object)tmpFilename);
        return tmpFilename;
    }

    public static Locale normalizeLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        if ((localeString = localeString.trim()).isEmpty() || "_".equals(localeString)) {
            return null;
        }
        int len = localeString.length();
        for (int i = 0; i < len; ++i) {
            char c = localeString.charAt(i);
            if (c > ' ' && c < '\u007f' && (c < ' ' && c > '\u007f' || Character.isLetter(c) || c == '_') || c == '\t') continue;
            localeString = localeString.replaceFirst(Character.valueOf(c).toString(), "");
            --len;
            --i;
        }
        Locale locale = LocaleUtility.fromSpecification((String)localeString);
        if (LocaleUtility.isValid((Locale)locale)) {
            return locale;
        }
        return null;
    }

    public static String sanitizeLocales(String localesString) {
        if (localesString == null) {
            return null;
        }
        StringBuilder outputString = new StringBuilder();
        boolean first = true;
        for (String locale : Arrays.asList(localesString.split(","))) {
            Locale loc = WebUtil.normalizeLocale(locale);
            if (loc == null) continue;
            if (!first) {
                outputString.append(", ");
            } else {
                first = false;
            }
            outputString.append(loc.toString());
        }
        if (outputString.length() > 0) {
            return outputString.toString();
        }
        return null;
    }

    public static String getContextPath() {
        return StringUtils.isEmpty((CharSequence)WebConstants.WEBAPP_NAME) ? "" : "/" + WebConstants.WEBAPP_NAME;
    }

    public static String formatDate(Date date) {
        return WebUtil.formatDate(date, Context.getLocale(), Format.FORMAT_TYPE.DATE);
    }

    public static String formatDate(Date date, Locale locale, Format.FORMAT_TYPE type) {
        log.debug("Formatting date: " + date + " with locale " + locale);
        DateFormat dateFormat = null;
        if (type == Format.FORMAT_TYPE.TIMESTAMP) {
            String dateTimeFormat = (String)Context.getAdministrationService().getGlobalPropertyValue("searchWidget.dateDisplayFormat", null);
            dateFormat = StringUtils.isEmpty((CharSequence)dateTimeFormat) ? DateFormat.getDateTimeInstance(1, 1, locale) : new OpenmrsDateFormat(new SimpleDateFormat(dateTimeFormat), locale);
        } else if (type == Format.FORMAT_TYPE.TIME) {
            String timeFormat = (String)Context.getAdministrationService().getGlobalPropertyValue("searchWidget.dateDisplayFormat", null);
            dateFormat = StringUtils.isEmpty((CharSequence)timeFormat) ? DateFormat.getTimeInstance(2, locale) : new OpenmrsDateFormat(new SimpleDateFormat(timeFormat), locale);
        } else if (type == Format.FORMAT_TYPE.DATE) {
            String formatValue = (String)Context.getAdministrationService().getGlobalPropertyValue("searchWidget.dateDisplayFormat", (Object)"");
            dateFormat = StringUtils.isEmpty((CharSequence)formatValue) ? DateFormat.getDateInstance(2, locale) : new OpenmrsDateFormat(new SimpleDateFormat(formatValue), locale);
        }
        return date == null ? "" : dateFormat.format(date);
    }

    public boolean supportsPropertyName(String propertyName) {
        return "searchWidget.dateDisplayFormat".equals(propertyName);
    }

    public void globalPropertyChanged(GlobalProperty newValue) {
    }

    public void globalPropertyDeleted(String propertyName) {
    }
}

