/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.controller;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmrs.GlobalProperty;
import org.openmrs.api.GlobalPropertyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.LastModified;

public class PseudoStaticContentController
implements Controller,
LastModified,
GlobalPropertyListener {
    private static final Logger log = LoggerFactory.getLogger(PseudoStaticContentController.class);
    private Boolean interpretJstl = false;
    private Map<String, String> rewrites;
    private static Long lastModified = System.currentTimeMillis();

    public Boolean getInterpretJstl() {
        return this.interpretJstl;
    }

    public void setInterpretJstl(Boolean interpretJstl) {
        this.interpretJstl = interpretJstl;
    }

    public Map<String, String> getRewrites() {
        return this.rewrites;
    }

    public void setRewrites(Map<String, String> rewrites) {
        this.rewrites = rewrites;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getServletPath() + request.getPathInfo();
        if (this.rewrites != null && this.rewrites.containsKey(path)) {
            path = this.rewrites.get(path);
        }
        if (this.interpretJstl.booleanValue()) {
            path = path + ".withjstl";
        }
        return new ModelAndView(path);
    }

    public long getLastModified(HttpServletRequest request) {
        if (this.interpretJstl.booleanValue()) {
            log.debug("returning last modified date of : {} for : {}", (Object)lastModified, (Object)request.getPathInfo());
            return lastModified;
        }
        return -1L;
    }

    public static void setLastModified(Long lastModified) {
        PseudoStaticContentController.lastModified = lastModified;
    }

    public void globalPropertyChanged(GlobalProperty newValue) {
        PseudoStaticContentController.setLastModified(System.currentTimeMillis());
    }

    public void globalPropertyDeleted(String propertyName) {
        PseudoStaticContentController.setLastModified(System.currentTimeMillis());
    }

    public boolean supportsPropertyName(String propertyName) {
        return true;
    }

    public static void invalidateCachedResources(Map<String, String> newValue) {
        PseudoStaticContentController.setLastModified(System.currentTimeMillis());
    }
}

