/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.openmrs.api.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class CookieClearingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CookieClearingFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpSession session;
        if (response.isCommitted()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String[] cookiesToClear = new String[]{};
        try {
            Properties properties = Context.getRuntimeProperties();
            String cookiesToClearSetting = properties.getProperty("cookieClearingFilter.toClear", "JSESSIONID");
            if (StringUtils.isNotBlank((CharSequence)cookiesToClearSetting)) {
                cookiesToClear = (String[])Arrays.stream(cookiesToClearSetting.split("\\s*,\\s*")).map(String::trim).toArray(String[]::new);
            }
        }
        catch (Exception e) {
            log.warn("Caught exception while trying to determine cookies to clear", (Throwable)e);
        }
        boolean requestHasSession = false;
        if (cookiesToClear.length > 0) {
            requestHasSession = request.getRequestedSessionId() != null;
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable throwable) {
            HttpSession session2;
            if (cookiesToClear.length > 0 && !response.isCommitted() && (session2 = request.getSession(false)) == null && requestHasSession) {
                block6: for (Cookie cookie : request.getCookies()) {
                    for (String cookieToClear : cookiesToClear) {
                        if (!cookieToClear.equalsIgnoreCase(cookie.getName())) continue;
                        Cookie clearedCookie = new Cookie(cookie.getName(), null);
                        String contextPath = request.getContextPath();
                        clearedCookie.setPath(contextPath == null || contextPath.trim().equals("") ? "/" : contextPath);
                        clearedCookie.setMaxAge(0);
                        clearedCookie.setHttpOnly(true);
                        clearedCookie.setSecure(request.isSecure());
                        response.addCookie(clearedCookie);
                        continue block6;
                    }
                }
            }
            throw throwable;
        }
        if (cookiesToClear.length > 0 && !response.isCommitted() && (session = request.getSession(false)) == null && requestHasSession) {
            block4: for (Cookie cookie : request.getCookies()) {
                for (String cookieToClear : cookiesToClear) {
                    if (!cookieToClear.equalsIgnoreCase(cookie.getName())) continue;
                    Cookie clearedCookie = new Cookie(cookie.getName(), null);
                    String contextPath = request.getContextPath();
                    clearedCookie.setPath(contextPath == null || contextPath.trim().equals("") ? "/" : contextPath);
                    clearedCookie.setMaxAge(0);
                    clearedCookie.setHttpOnly(true);
                    clearedCookie.setSecure(request.isSecure());
                    response.addCookie(clearedCookie);
                    continue block4;
                }
            }
        }
    }
}

