/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmrs.api.APIException;
import org.openmrs.api.context.Context;
import org.openmrs.web.filter.GZIPRequestWrapper;
import org.openmrs.web.filter.GZIPResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class GZIPFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(GZIPFilter.class);
    private Boolean cachedGZipEnabledFlag = null;
    private String cachedGZipCompressedRequestForPathAccepted = null;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            request = this.performGZIPRequest(request);
        }
        catch (APIException e) {
            response.sendError(415);
            return;
        }
        if (this.isGZIPSupported(request) && this.isGZIPEnabled()) {
            log.debug("GZIP supported and enabled, compressing response");
            GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
            wrappedResponse.finishResponse();
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public HttpServletRequest performGZIPRequest(HttpServletRequest req) {
        String contentEncoding = req.getHeader("Content-encoding");
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            if (!this.isCompressedRequestForPathAccepted(req.getRequestURI())) {
                throw new APIException("Unsupported Media Type");
            }
            log.debug("GZIP request supported");
            try {
                GZIPRequestWrapper wrapperRequest = new GZIPRequestWrapper(req);
                log.debug("GZIP request wrapped successfully");
                return wrapperRequest;
            }
            catch (IOException e) {
                log.error("Error during wrapping GZIP request " + e);
                return req;
            }
        }
        return req;
    }

    private boolean isGZIPSupported(HttpServletRequest req) {
        String browserEncodings = req.getHeader("accept-encoding");
        boolean supported = browserEncodings != null && browserEncodings.contains("gzip");
        String userAgent = req.getHeader("user-agent");
        if (userAgent != null && userAgent.startsWith("httpunit")) {
            log.debug("httpunit detected, disabling filter...");
            return false;
        }
        return supported;
    }

    private boolean isGZIPEnabled() {
        if (this.cachedGZipEnabledFlag != null) {
            return this.cachedGZipEnabledFlag;
        }
        try {
            Context.addProxyPrivilege((String)"Get Global Properties");
            String gzipEnabled = Context.getAdministrationService().getGlobalProperty("gzip.enabled", "");
            this.cachedGZipEnabledFlag = Boolean.valueOf(gzipEnabled);
            boolean bl = this.cachedGZipEnabledFlag;
            return bl;
        }
        catch (Exception e) {
            log.warn("Unable to get the global property: gzip.enabled", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Context.removeProxyPrivilege((String)"Get Global Properties");
        }
    }

    private boolean isCompressedRequestForPathAccepted(String path) {
        try {
            if (this.cachedGZipCompressedRequestForPathAccepted == null) {
                this.cachedGZipCompressedRequestForPathAccepted = Context.getAdministrationService().getGlobalProperty("gzip.acceptCompressedRequestsForPaths", "");
            }
            for (String acceptPath : this.cachedGZipCompressedRequestForPathAccepted.split(",")) {
                if (!path.matches(acceptPath)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.warn("Unable to process the global property: gzip.acceptCompressedRequestsForPaths", (Throwable)e);
            return false;
        }
    }
}

