/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.openmrs.web.filter.GZIPResponseStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(GZIPResponseWrapper.class);
    protected HttpServletResponse origResponse;
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected int error = 0;

    public GZIPResponseWrapper(HttpServletResponse response) {
        super(response);
        this.origResponse = response;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new GZIPResponseStream(this.origResponse);
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null && !((GZIPResponseStream)this.stream).closed()) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            log.error("Error during closing writer or stream", (Throwable)e);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.origResponse != null && this.origResponse.isCommitted()) {
            return super.getWriter();
        }
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.origResponse.getCharacterEncoding()));
        return this.writer;
    }

    public void sendError(int error, String message) throws IOException {
        super.sendError(error, message);
        this.error = error;
        log.debug("sending error: {} [{}]", (Object)error, (Object)message);
    }

    public void setContentLength(int length) {
    }
}

