/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openmrs.User;
import org.openmrs.api.context.Context;
import org.openmrs.api.context.UserContext;
import org.openmrs.util.OpenmrsClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenmrsFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(OpenmrsFilter.class);

    public void destroy() {
        log.debug("Destroying filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        HttpSession httpSession = httpRequest.getSession();
        httpRequest.setAttribute("__INIT_REQ_UNIQUE_ID__", (Object)String.valueOf(System.currentTimeMillis()));
        log.debug("requestURI {}", (Object)httpRequest.getRequestURI());
        log.debug("requestURL {}", (Object)httpRequest.getRequestURL());
        log.debug("request path info {}", (Object)httpRequest.getPathInfo());
        UserContext userContext = (UserContext)httpSession.getAttribute("__openmrs_user_context");
        httpSession.setAttribute("username", (Object)"-anonymous user-");
        if (userContext == null) {
            userContext = new UserContext(Context.getAuthenticationScheme());
            httpSession.setAttribute("__openmrs_user_context", (Object)userContext);
            log.debug("Just set user context {} as attribute on session", (Object)userContext);
        } else {
            User user = userContext.getAuthenticatedUser();
            if (user != null) {
                httpSession.setAttribute("username", (Object)user.getUsername());
            }
        }
        httpSession.setAttribute("locale", (Object)userContext.getLocale());
        if (httpRequest.getRequestURI().endsWith("csrfguard")) {
            httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setHeader("Expires", "0");
        }
        Context.setUserContext((UserContext)userContext);
        Thread.currentThread().setContextClassLoader((ClassLoader)OpenmrsClassLoader.getInstance());
        log.debug("before chain.Filter");
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            Context.clearUserContext();
        }
        log.debug("after chain.doFilter");
    }
}

