/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter;

import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.openmrs.OpenmrsCharacterEscapes;
import org.openmrs.api.APIException;
import org.openmrs.api.context.Context;
import org.openmrs.logging.MemoryAppender;
import org.openmrs.logging.OpenmrsLoggingUtil;
import org.openmrs.util.LocaleUtility;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.web.Listener;
import org.openmrs.web.WebConstants;
import org.openmrs.web.filter.initialization.InitializationFilter;
import org.openmrs.web.filter.util.LocalizationTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public abstract class StartupFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(StartupFilter.class);
    protected static VelocityEngine velocityEngine = null;
    public static final String AUTO_RUN_OPENMRS = "auto_run_openmrs";
    protected FilterConfig filterConfig = null;
    protected Map<String, Object[]> errors = new HashMap<String, Object[]>();
    protected Map<String, Object[]> msgs = new HashMap<String, Object[]>();
    private ToolContext toolContext = null;

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (((HttpServletRequest)request).getServletPath().equals("/health/started")) {
            ((HttpServletResponse)response).setStatus(Listener.isOpenmrsStarted() ? 200 : 503);
        } else if (((HttpServletRequest)request).getServletPath().equals("/health/alive")) {
            boolean isOpenmrsLive = Listener.isSetupNeeded() || Listener.isOpenmrsStarted() || InitializationFilter.isInstallationStarted();
            ((HttpServletResponse)response).setStatus(isOpenmrsLive ? 200 : 503);
        } else if (this.skipFilter((HttpServletRequest)request)) {
            chain.doFilter(request, response);
        } else {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String servletPath = httpRequest.getServletPath();
            if (servletPath.startsWith("/images") || servletPath.startsWith("/initfilter/scripts")) {
                Path filePath;
                servletPath = servletPath.replaceFirst("/initfilter", "/WEB-INF/view");
                Path fullFilePath = filePath = Paths.get(this.filterConfig.getServletContext().getRealPath(servletPath), new String[0]).normalize();
                if (httpRequest.getPathInfo() != null && !(fullFilePath = fullFilePath.resolve(httpRequest.getPathInfo())).normalize().startsWith(filePath)) {
                    log.warn("Detected attempted directory traversal in request for {}", (Object)httpRequest.getPathInfo());
                    return;
                }
                String contentType = httpRequest.getServletContext().getMimeType(fullFilePath.toString());
                if (contentType == null || contentType.isEmpty()) {
                    try {
                        contentType = Files.probeContentType(fullFilePath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                MediaType mediaType = contentType != null && !contentType.isEmpty() ? MediaType.parseMediaType((String)contentType) : MediaType.APPLICATION_OCTET_STREAM;
                response.setContentType(mediaType.toString());
                try (FileInputStream fis = new FileInputStream(fullFilePath.normalize().toFile());){
                    OpenmrsUtil.copyFile((InputStream)fis, (OutputStream)httpResponse.getOutputStream());
                }
                catch (FileNotFoundException e) {
                    log.error("Unable to find file: {}", (Object)filePath, (Object)e);
                }
                catch (IOException e) {
                    log.warn("An error occurred while handling file {}", (Object)filePath, (Object)e);
                }
            } else if (servletPath.startsWith("/scripts")) {
                log.error("Calling /scripts during the initializationfilter pages will cause the openmrs_static_context-servlet.xml to initialize too early and cause errors after startup.  Use '/initfilter" + servletPath + "' instead.");
            } else if (!httpRequest.getServletPath().equals("/initialsetup") && !httpRequest.getServletPath().equals("/auto_run_openmrs")) {
                httpResponse.sendRedirect("/" + WebConstants.WEBAPP_NAME + "/" + "initialsetup");
            } else if ("GET".equals(httpRequest.getMethod())) {
                this.doGet(httpRequest, httpResponse);
            } else if ("POST".equals(httpRequest.getMethod())) {
                this.errors.clear();
                this.msgs.clear();
                this.doPost(httpRequest, httpResponse);
            }
        }
    }

    private void initializeVelocity() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            Properties props = new Properties();
            props.setProperty("runtime.log", "startup_wizard_vel.log");
            props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.CommonsLogLogChute");
            props.setProperty("runtime.log.logsystem.commons.logging.name", "initial_wizard_velocity");
            props.setProperty("resource.loader", "class");
            props.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            try {
                velocityEngine.init(props);
            }
            catch (Exception e) {
                log.error("velocity init failed, because: {}", (Object)e, (Object)e);
            }
        }
    }

    protected abstract void doGet(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected abstract void doPost(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected void renderTemplate(String templateName, Map<String, Object> referenceMap, HttpServletResponse httpResponse) throws IOException {
        if (referenceMap == null) {
            return;
        }
        Object locale = referenceMap.get("locale");
        ToolContext velocityToolContext = this.getToolContext(locale != null ? locale.toString() : Context.getLocale().toString());
        VelocityContext velocityContext = new VelocityContext((org.apache.velocity.context.Context)velocityToolContext);
        for (Map.Entry<String, Object> entry : referenceMap.entrySet()) {
            velocityContext.put(entry.getKey(), entry.getValue());
        }
        Object model = this.getUpdateFilterModel();
        for (Field field : model.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                velocityContext.put(field.getName(), field.get(model));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Error generated while getting field value: " + field.getName(), (Throwable)e);
            }
        }
        String string = this.getTemplatePrefix() + templateName;
        InputStream templateInputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (templateInputStream == null) {
            throw new IOException("Unable to find " + string);
        }
        velocityContext.put("errors", this.errors);
        velocityContext.put("msgs", this.msgs);
        httpResponse.setContentType("text/html");
        try {
            velocityEngine.evaluate((org.apache.velocity.context.Context)velocityContext, (Writer)httpResponse.getWriter(), this.getClass().getName(), (Reader)new InputStreamReader(templateInputStream, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new APIException("Unable to process template: " + string, (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.initializeVelocity();
    }

    public void destroy() {
    }

    protected String getTemplatePrefix() {
        return "org/openmrs/web/filter/";
    }

    protected abstract Object getUpdateFilterModel();

    public abstract boolean skipFilter(HttpServletRequest var1);

    protected void addLogLinesToResponse(Map<String, Object> result) {
        MemoryAppender appender = OpenmrsLoggingUtil.getMemoryAppender();
        if (appender != null) {
            List logLines = appender.getLogLines();
            if (logLines.size() > 5) {
                logLines = logLines.subList(logLines.size() - 5, logLines.size());
            }
            result.put("logLines", logLines);
        } else {
            result.put("logLines", Collections.emptyList());
        }
    }

    protected String toJSONString(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getFactory().setCharacterEscapes((CharacterEscapes)new OpenmrsCharacterEscapes());
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            log.error("Failed to convert object to JSON");
            throw new APIException((Throwable)e);
        }
    }

    public ToolContext getToolContext(String locale) {
        Locale systemLocale = LocaleUtility.fromSpecification((String)locale);
        if (systemLocale == null || !ArrayUtils.contains((Object[])Locale.getAvailableLocales(), (Object)systemLocale)) {
            systemLocale = Locale.ENGLISH;
        }
        if (this.toolContext == null) {
            ToolManager velocityToolManager = new ToolManager();
            FactoryConfiguration factoryConfig = new FactoryConfiguration();
            ToolboxConfiguration toolbox = new ToolboxConfiguration();
            toolbox.setScope("application");
            ToolConfiguration localizationTool = new ToolConfiguration();
            localizationTool.setClassname(LocalizationTool.class.getName());
            localizationTool.setProperty("locale", (Object)systemLocale);
            localizationTool.setProperty("bundles", (Object)"messages");
            toolbox.addTool(localizationTool);
            factoryConfig.addToolbox(toolbox);
            velocityToolManager.configure(factoryConfig);
            this.toolContext = velocityToolManager.createContext();
            this.toolContext.setUserCanOverwriteTools(true);
        } else {
            DefaultKey annotation = LocalizationTool.class.getAnnotation(DefaultKey.class);
            String key = annotation.value();
            LocalizationTool localizationTool = (LocalizationTool)((Object)this.toolContext.get(key));
            localizationTool.setLocale(systemLocale);
            this.toolContext.put(key, (Object)localizationTool);
        }
        return this.toolContext;
    }
}

