/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.initialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.zip.ZipInputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.openmrs.api.APIAuthenticationException;
import org.openmrs.api.PasswordException;
import org.openmrs.api.context.Context;
import org.openmrs.util.DatabaseUtil;
import org.openmrs.util.OpenmrsThreadPoolHolder;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.web.WebConstants;
import org.openmrs.web.filter.StartupFilter;
import org.openmrs.web.filter.initialization.DatabaseDetective;
import org.openmrs.web.filter.initialization.InitializationWizardModel;
import org.openmrs.web.filter.initialization.TestInstallUtil;
import org.openmrs.web.filter.initialization.WizardTask;
import org.openmrs.web.filter.util.CustomResourceLoader;
import org.openmrs.web.filter.util.SessionModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InitializationFilter
extends StartupFilter {
    private static final Logger log = LoggerFactory.getLogger(InitializationFilter.class);
    private static final String DATABASE_POSTGRESQL = "postgresql";
    private static final String DATABASE_MYSQL = "mysql";
    private static final String DATABASE_SQLSERVER = "sqlserver";
    private static final String DATABASE_H2 = "h2";
    private static final String DATABASE_MARIADB = "mariadb";
    private static final String CHOOSE_LANG = "chooselang.vm";
    private static final String INSTALL_METHOD = "installmethod.vm";
    private static final String SIMPLE_SETUP = "simplesetup.vm";
    private static final String DATABASE_SETUP = "databasesetup.vm";
    private static final String TESTING_REMOTE_DETAILS_SETUP = "remotedetails.vm";
    private static final String DEFAULT_PAGE = "chooselang.vm";
    private static final String DATABASE_TABLES_AND_USER = "databasetablesanduser.vm";
    private static final String ADMIN_USER_SETUP = "adminusersetup.vm";
    private static final String IMPLEMENTATION_ID_SETUP = "implementationidsetup.vm";
    private static final String OTHER_RUNTIME_PROPS = "otherruntimeproperties.vm";
    private static final String WIZARD_COMPLETE = "wizardcomplete.vm";
    private static final String PROGRESS_VM = "progress.vm";
    private static final String PROGRESS_VM_AJAXREQUEST = "progress.vm.ajaxRequest";
    public static final String RELEASE_TESTING_MODULE_PATH = "/module/releasetestinghelper/";
    protected InitializationWizardModel wizardModel = null;
    private InitializationCompletion initJob;
    private static boolean isInstallationStarted = false;
    private String loadedDriverString;
    private static final Set<String> NON_NORMALIZED_KEYS = new HashSet<String>(Arrays.asList("INSTALL_METHOD", "DATABASE_NAME", "HAS_CURRENT_OPENMRS_DATABASE", "CREATE_DATABASE_USER", "CREATE_TABLES", "ADD_DEMO_DATA", "MODULE_WEB_ADMIN", "AUTO_UPDATE_DATABASE", "ADMIN_USER_PASSWORD"));
    private static boolean initializationComplete = false;

    protected synchronized void setInitializationComplete(boolean initializationComplete) {
        InitializationFilter.initializationComplete = initializationComplete;
    }

    @Override
    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        log.debug("Entered initialization filter");
        SessionModelUtils.loadFromSession(httpRequest.getSession(), this.wizardModel);
        this.initializeWizardFromResolvedPropertiesIfPresent();
        if (httpRequest.getSession().getAttribute("locale") == null) {
            this.checkLocaleAttributesForFirstTime(httpRequest);
        }
        HashMap<String, Object> referenceMap = new HashMap<String, Object>();
        String page = httpRequest.getParameter("page");
        referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
        httpResponse.setHeader("Cache-Control", "no-cache");
        if (InitializationFilter.isInstallationStarted() && !PROGRESS_VM_AJAXREQUEST.equals(page)) {
            referenceMap.put("isInstallationStarted", true);
            httpResponse.setContentType("text/html");
            this.renderTemplate(PROGRESS_VM, referenceMap, httpResponse);
        } else if (PROGRESS_VM_AJAXREQUEST.equals(page)) {
            httpResponse.setContentType("text/json");
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (this.initJob != null) {
                result.put("hasErrors", this.initJob.hasErrors());
                if (this.initJob.hasErrors()) {
                    result.put("errorPage", this.initJob.getErrorPage());
                    this.errors.putAll(this.initJob.getErrors());
                }
                result.put("initializationComplete", InitializationFilter.isInitializationComplete());
                result.put("message", this.initJob.getMessage());
                result.put("actionCounter", this.initJob.getStepsComplete());
                if (!InitializationFilter.isInitializationComplete()) {
                    result.put("executingTask", (Object)this.initJob.getExecutingTask());
                    result.put("executedTasks", this.initJob.getExecutedTasks());
                    result.put("completedPercentage", this.initJob.getCompletedPercentage());
                }
                SessionModelUtils.clearWizardSessionAttributes(httpRequest.getSession());
                this.addLogLinesToResponse(result);
            }
            PrintWriter writer = httpResponse.getWriter();
            writer.write(this.toJSONString(result));
            writer.close();
        } else if ("auto".equals(this.wizardModel.installMethod) || httpRequest.getServletPath().equals("/auto_run_openmrs")) {
            this.autoRunOpenMRS(httpRequest);
            referenceMap.put("isInstallationStarted", true);
            httpResponse.setContentType("text/html");
            this.renderTemplate(PROGRESS_VM, referenceMap, httpResponse);
        } else if (page == null) {
            httpResponse.setContentType("text/html");
            this.clearPasswords();
            this.renderTemplate("chooselang.vm", referenceMap, httpResponse);
        } else if (INSTALL_METHOD.equals(page)) {
            File runtimeProperties = this.getRuntimePropertiesFile();
            if (!runtimeProperties.exists()) {
                try {
                    runtimeProperties.createNewFile();
                    this.wizardModel.canCreate = true;
                    this.wizardModel.cannotCreateErrorMessage = "";
                }
                catch (IOException io) {
                    this.wizardModel.canCreate = false;
                    this.wizardModel.cannotCreateErrorMessage = io.getMessage();
                }
                this.wizardModel.canWrite = runtimeProperties.canWrite();
                runtimeProperties.delete();
            } else {
                this.wizardModel.canWrite = runtimeProperties.canWrite();
                this.wizardModel.databaseConnection = Context.getRuntimeProperties().getProperty("connection.url", this.wizardModel.databaseConnection);
                this.wizardModel.currentDatabaseUsername = Context.getRuntimeProperties().getProperty("connection.username", this.wizardModel.currentDatabaseUsername);
                this.wizardModel.currentDatabasePassword = Context.getRuntimeProperties().getProperty("connection.password", this.wizardModel.currentDatabasePassword);
            }
            this.wizardModel.runtimePropertiesPath = runtimeProperties.getAbsolutePath();
            httpResponse.setContentType("text/html");
            this.renderTemplate(INSTALL_METHOD, referenceMap, httpResponse);
        }
    }

    protected void initializeWizardFromResolvedPropertiesIfPresent() {
        Properties script = new Properties();
        Properties installScript = this.getInstallationScript();
        script.putAll((Map<?, ?>)installScript);
        this.getEnvironmentVariables().forEach((key, value) -> {
            String normalizedKey = this.normalizeEnvVariableKey((String)key);
            script.setProperty(normalizedKey, (String)value);
        });
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> script.setProperty(key.toString(), value.toString())));
        if (log.isDebugEnabled()) {
            for (String key2 : script.stringPropertyNames()) {
                String value2 = script.getProperty(key2);
                log.debug("{} = {}", (Object)key2, (Object)(key2.toLowerCase().contains("password") ? "*******" : value2));
            }
        }
        if (!script.isEmpty()) {
            String autoUpdateDatabase;
            String createDatabaseUser;
            this.wizardModel.installMethod = script.getProperty("install_method", this.wizardModel.installMethod);
            this.wizardModel.databaseConnection = script.getProperty("connection.url", this.wizardModel.databaseConnection);
            this.wizardModel.databaseDriver = script.getProperty("connection.driver_class", this.wizardModel.databaseDriver);
            this.wizardModel.databaseName = script.getProperty("database_name", this.wizardModel.databaseName);
            this.wizardModel.currentDatabaseUsername = script.getProperty("connection.username", this.wizardModel.currentDatabaseUsername);
            this.wizardModel.currentDatabasePassword = script.getProperty("connection.password", this.wizardModel.currentDatabasePassword);
            String hasCurrentOpenmrsDatabase = script.getProperty("has_current_openmrs_database");
            if (hasCurrentOpenmrsDatabase != null) {
                this.wizardModel.hasCurrentOpenmrsDatabase = Boolean.parseBoolean(hasCurrentOpenmrsDatabase);
            }
            this.wizardModel.createDatabaseUsername = script.getProperty("create_database_username", this.wizardModel.createDatabaseUsername);
            this.wizardModel.createDatabasePassword = script.getProperty("create_database_password", this.wizardModel.createDatabasePassword);
            String createTables = script.getProperty("create_tables");
            if (createTables != null) {
                this.wizardModel.createTables = Boolean.parseBoolean(createTables);
            }
            if ((createDatabaseUser = script.getProperty("create_database_user")) != null) {
                this.wizardModel.createDatabaseUser = Boolean.parseBoolean(createDatabaseUser);
            }
            this.wizardModel.createUserUsername = script.getProperty("create_user_username", this.wizardModel.createUserUsername);
            this.wizardModel.createUserPassword = script.getProperty("create_user_password", this.wizardModel.createUserPassword);
            String moduleWebAdmin = script.getProperty("module_web_admin");
            if (moduleWebAdmin != null) {
                this.wizardModel.moduleWebAdmin = Boolean.parseBoolean(moduleWebAdmin);
            }
            if ((autoUpdateDatabase = script.getProperty("auto_update_database")) != null) {
                this.wizardModel.autoUpdateDatabase = Boolean.parseBoolean(autoUpdateDatabase);
            }
            this.wizardModel.adminUserPassword = script.getProperty("admin_user_password", this.wizardModel.adminUserPassword);
            for (Map.Entry<Object, Object> entry : installScript.entrySet()) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith("property.")) continue;
                this.wizardModel.additionalPropertiesFromInstallationScript.put(((String)entry.getKey()).substring(9), entry.getValue());
            }
        }
    }

    private void clearPasswords() {
        this.wizardModel.databaseRootPassword = "";
        this.wizardModel.createDatabasePassword = "";
        this.wizardModel.createUserPassword = "";
        this.wizardModel.currentDatabasePassword = "";
        this.wizardModel.remotePassword = "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        HashMap<String, Object> referenceMap;
        String page;
        block62: {
            block63: {
                page = httpRequest.getParameter("page");
                referenceMap = new HashMap<String, Object>();
                if (httpRequest.getSession().getAttribute("locale") != null) {
                    referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
                }
                if (InitializationFilter.isInstallationStarted()) {
                    referenceMap.put("isInstallationStarted", true);
                    httpResponse.setContentType("text/html");
                    this.renderTemplate(PROGRESS_VM, referenceMap, httpResponse);
                    return;
                }
                if ("chooselang.vm".equals(page)) {
                    File runtimeProperties = this.getRuntimePropertiesFile();
                    if (!runtimeProperties.exists()) {
                        try {
                            runtimeProperties.createNewFile();
                            this.wizardModel.canCreate = true;
                            this.wizardModel.cannotCreateErrorMessage = "";
                        }
                        catch (IOException io) {
                            this.wizardModel.canCreate = false;
                            this.wizardModel.cannotCreateErrorMessage = io.getMessage();
                        }
                        this.wizardModel.canWrite = runtimeProperties.canWrite();
                        runtimeProperties.delete();
                    } else {
                        this.wizardModel.canWrite = runtimeProperties.canWrite();
                        this.wizardModel.databaseConnection = Context.getRuntimeProperties().getProperty("connection.url", this.wizardModel.databaseConnection);
                        this.wizardModel.currentDatabaseUsername = Context.getRuntimeProperties().getProperty("connection.username", this.wizardModel.currentDatabaseUsername);
                        this.wizardModel.currentDatabasePassword = Context.getRuntimeProperties().getProperty("connection.password", this.wizardModel.currentDatabasePassword);
                    }
                    this.wizardModel.runtimePropertiesPath = runtimeProperties.getAbsolutePath();
                    this.checkLocaleAttributes(httpRequest);
                    referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
                    log.info("Locale stored in session is " + httpRequest.getSession().getAttribute("locale"));
                    httpResponse.setContentType("text/html");
                    this.renderTemplate(INSTALL_METHOD, referenceMap, httpResponse);
                    return;
                }
                if (INSTALL_METHOD.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        referenceMap.put("remember", httpRequest.getSession().getAttribute("remember") != null);
                        referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
                        this.renderTemplate("chooselang.vm", referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.installMethod = httpRequest.getParameter("install_method");
                    if ("simple".equals(this.wizardModel.installMethod)) {
                        page = SIMPLE_SETUP;
                    } else if ("testing".equals(this.wizardModel.installMethod)) {
                        page = TESTING_REMOTE_DETAILS_SETUP;
                        this.wizardModel.currentStepNumber = 1;
                        this.wizardModel.numberOfSteps = InitializationFilter.skipDatabaseSetupPage() ? 1 : 3;
                    } else {
                        page = DATABASE_SETUP;
                        this.wizardModel.currentStepNumber = 1;
                        this.wizardModel.numberOfSteps = 5;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (SIMPLE_SETUP.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        this.renderTemplate(INSTALL_METHOD, referenceMap, httpResponse);
                        return;
                    }
                    String databaseType = httpRequest.getParameter("database_type");
                    if (databaseType != null) {
                        this.wizardModel.databaseType = databaseType;
                        if (DATABASE_POSTGRESQL.equals(databaseType)) {
                            this.wizardModel.databaseConnection = "jdbc:postgresql://localhost:5432/postgres";
                            String postgresUsername = httpRequest.getParameter("create_database_username");
                            this.wizardModel.createDatabaseUsername = StringUtils.hasText((String)postgresUsername) ? postgresUsername : Context.getRuntimeProperties().getProperty("connection.username", "postgres");
                        } else {
                            this.wizardModel.databaseConnection = "jdbc:mysql://localhost:3306/@DBNAME@?autoReconnect=true&sessionVariables=default_storage_engine=InnoDB&useUnicode=true&characterEncoding=UTF-8";
                            this.wizardModel.createDatabaseUsername = Context.getRuntimeProperties().getProperty("connection.username", this.wizardModel.createDatabaseUsername);
                        }
                    }
                    this.wizardModel.databaseRootPassword = httpRequest.getParameter("database_root_password");
                    this.checkForEmptyValue(this.wizardModel.databaseRootPassword, this.errors, "install.error.dbPasswd");
                    this.wizardModel.createUserUsername = this.wizardModel.createDatabaseUsername;
                    this.wizardModel.hasCurrentOpenmrsDatabase = false;
                    this.wizardModel.createTables = true;
                    this.wizardModel.createDatabasePassword = this.wizardModel.databaseRootPassword;
                    this.wizardModel.hasCurrentDatabaseUser = false;
                    this.wizardModel.createDatabaseUser = true;
                    this.wizardModel.createUserPassword = this.wizardModel.databaseRootPassword;
                    this.wizardModel.moduleWebAdmin = true;
                    this.wizardModel.autoUpdateDatabase = false;
                    this.wizardModel.adminUserPassword = "Admin123";
                    this.createSimpleSetup(httpRequest.getParameter("database_root_password"));
                    try {
                        this.loadedDriverString = DatabaseUtil.loadDatabaseDriver((String)this.wizardModel.databaseConnection, (String)this.wizardModel.databaseDriver);
                    }
                    catch (ClassNotFoundException e) {
                        this.errors.put("install.error.dbDriverClass", null);
                        this.renderTemplate(page, referenceMap, httpResponse);
                        return;
                    }
                    if (this.errors.isEmpty()) {
                        page = WIZARD_COMPLETE;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (DATABASE_SETUP.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        --this.wizardModel.currentStepNumber;
                        if ("testing".equals(this.wizardModel.installMethod)) {
                            this.renderTemplate(TESTING_REMOTE_DETAILS_SETUP, referenceMap, httpResponse);
                            return;
                        }
                        this.renderTemplate(INSTALL_METHOD, referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.databaseConnection = httpRequest.getParameter("database_connection");
                    this.checkForEmptyValue(this.wizardModel.databaseConnection, this.errors, "install.error.dbConn");
                    this.wizardModel.databaseDriver = httpRequest.getParameter("database_driver");
                    this.checkForEmptyValue(this.wizardModel.databaseConnection, this.errors, "install.error.dbDriver");
                    this.loadedDriverString = InitializationFilter.loadDriver(this.wizardModel.databaseConnection, this.wizardModel.databaseDriver);
                    if (!StringUtils.hasText((String)this.loadedDriverString)) {
                        this.errors.put("install.error.dbDriverClass", null);
                        this.renderTemplate(page, referenceMap, httpResponse);
                        return;
                    }
                    if ("yes".equals(httpRequest.getParameter("current_openmrs_database"))) {
                        this.wizardModel.databaseName = httpRequest.getParameter("openmrs_current_database_name");
                        this.checkForEmptyValue(this.wizardModel.databaseName, this.errors, "install.error.dbCurrName");
                        this.wizardModel.hasCurrentOpenmrsDatabase = true;
                    } else {
                        this.wizardModel.hasCurrentOpenmrsDatabase = false;
                        this.wizardModel.createTables = true;
                        this.wizardModel.databaseName = httpRequest.getParameter("openmrs_new_database_name");
                        this.checkForEmptyValue(this.wizardModel.databaseName, this.errors, "install.error.dbNewName");
                        this.wizardModel.createDatabaseUsername = httpRequest.getParameter("create_database_username");
                        this.checkForEmptyValue(this.wizardModel.createDatabaseUsername, this.errors, "install.error.dbUserName");
                        this.wizardModel.createDatabasePassword = httpRequest.getParameter("create_database_password");
                        this.checkForEmptyValue(this.wizardModel.createDatabasePassword, this.errors, "install.error.dbUserPswd");
                    }
                    if (this.errors.isEmpty()) {
                        page = DATABASE_TABLES_AND_USER;
                        this.wizardModel.currentStepNumber = "testing".equals(this.wizardModel.installMethod) ? 3 : 2;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (DATABASE_TABLES_AND_USER.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        --this.wizardModel.currentStepNumber;
                        this.renderTemplate(DATABASE_SETUP, referenceMap, httpResponse);
                        return;
                    }
                    if (this.wizardModel.hasCurrentOpenmrsDatabase.booleanValue()) {
                        this.wizardModel.createTables = "yes".equals(httpRequest.getParameter("create_tables"));
                    }
                    if ("yes".equals(httpRequest.getParameter("current_database_user"))) {
                        this.wizardModel.currentDatabaseUsername = httpRequest.getParameter("current_database_username");
                        this.checkForEmptyValue(this.wizardModel.currentDatabaseUsername, this.errors, "install.error.dbCurUserName");
                        this.wizardModel.currentDatabasePassword = httpRequest.getParameter("current_database_password");
                        this.checkForEmptyValue(this.wizardModel.currentDatabasePassword, this.errors, "install.error.dbCurUserPswd");
                        this.wizardModel.hasCurrentDatabaseUser = true;
                        this.wizardModel.createDatabaseUser = false;
                    } else {
                        this.wizardModel.hasCurrentDatabaseUser = false;
                        this.wizardModel.createDatabaseUser = true;
                        this.wizardModel.createUserUsername = httpRequest.getParameter("create_user_username");
                        this.checkForEmptyValue(this.wizardModel.createUserUsername, this.errors, "install.error.dbUserName");
                        this.wizardModel.createUserPassword = httpRequest.getParameter("create_user_password");
                        this.checkForEmptyValue(this.wizardModel.createUserPassword, this.errors, "install.error.dbUserPswd");
                    }
                    if (this.errors.isEmpty()) {
                        page = "testing".equals(this.wizardModel.installMethod) ? WIZARD_COMPLETE : OTHER_RUNTIME_PROPS;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (OTHER_RUNTIME_PROPS.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        this.renderTemplate(DATABASE_TABLES_AND_USER, referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.moduleWebAdmin = "yes".equals(httpRequest.getParameter("module_web_admin"));
                    this.wizardModel.autoUpdateDatabase = "yes".equals(httpRequest.getParameter("auto_update_database"));
                    page = this.wizardModel.createTables ? ADMIN_USER_SETUP : IMPLEMENTATION_ID_SETUP;
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (ADMIN_USER_SETUP.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        this.renderTemplate(OTHER_RUNTIME_PROPS, referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.adminUserPassword = httpRequest.getParameter("new_admin_password");
                    String adminUserConfirm = httpRequest.getParameter("new_admin_password_confirm");
                    if (!this.wizardModel.adminUserPassword.equals(adminUserConfirm)) {
                        this.errors.put("install.error.adminPswdMatch", null);
                        this.renderTemplate(ADMIN_USER_SETUP, referenceMap, httpResponse);
                        return;
                    }
                    if ("".equals(this.wizardModel.adminUserPassword)) {
                        this.errors.put("install.error.adminPswdEmpty", null);
                        this.renderTemplate(ADMIN_USER_SETUP, referenceMap, httpResponse);
                        return;
                    }
                    try {
                        OpenmrsUtil.validatePassword((String)"admin", (String)this.wizardModel.adminUserPassword, (String)"admin");
                    }
                    catch (PasswordException p) {
                        this.errors.put("install.error.adminPswdWeak", null);
                        this.renderTemplate(ADMIN_USER_SETUP, referenceMap, httpResponse);
                        return;
                    }
                    if (this.errors.isEmpty()) {
                        page = IMPLEMENTATION_ID_SETUP;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (IMPLEMENTATION_ID_SETUP.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        if (this.wizardModel.createTables) {
                            this.renderTemplate(ADMIN_USER_SETUP, referenceMap, httpResponse);
                            return;
                        }
                        this.renderTemplate(OTHER_RUNTIME_PROPS, referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.implementationIdName = httpRequest.getParameter("implementation_name");
                    this.wizardModel.implementationId = httpRequest.getParameter("implementation_id");
                    this.wizardModel.implementationIdPassPhrase = httpRequest.getParameter("pass_phrase");
                    this.wizardModel.implementationIdDescription = httpRequest.getParameter("description");
                    if (this.wizardModel.implementationId.indexOf(94) != -1 || this.wizardModel.implementationId.indexOf(124) != -1) {
                        this.errors.put("install.error.implID", null);
                        this.renderTemplate(IMPLEMENTATION_ID_SETUP, referenceMap, httpResponse);
                        return;
                    }
                    if (this.errors.isEmpty()) {
                        page = WIZARD_COMPLETE;
                    }
                    this.renderTemplate(page, referenceMap, httpResponse);
                    return;
                }
                if (WIZARD_COMPLETE.equals(page)) {
                    if (InitializationFilter.goBack(httpRequest)) {
                        page = "simple".equals(this.wizardModel.installMethod) ? SIMPLE_SETUP : ("testing".equals(this.wizardModel.installMethod) ? (InitializationFilter.skipDatabaseSetupPage() ? TESTING_REMOTE_DETAILS_SETUP : DATABASE_TABLES_AND_USER) : IMPLEMENTATION_ID_SETUP);
                        this.renderTemplate(page, referenceMap, httpResponse);
                        return;
                    }
                    this.wizardModel.tasksToExecute = new ArrayList<WizardTask>();
                    this.createDatabaseTask();
                    if ("testing".equals(this.wizardModel.installMethod)) {
                        this.wizardModel.importTestData = true;
                        this.wizardModel.createTables = false;
                        if (InitializationFilter.skipDatabaseSetupPage()) {
                            this.wizardModel.hasCurrentOpenmrsDatabase = false;
                            this.wizardModel.hasCurrentDatabaseUser = true;
                            this.wizardModel.createDatabaseUser = false;
                            Properties props = OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME);
                            this.wizardModel.currentDatabaseUsername = props.getProperty("connection.username");
                            this.wizardModel.currentDatabasePassword = props.getProperty("connection.password");
                            this.wizardModel.createDatabaseUsername = this.wizardModel.currentDatabaseUsername;
                            this.wizardModel.createDatabasePassword = this.wizardModel.currentDatabasePassword;
                        }
                        this.wizardModel.tasksToExecute.add(WizardTask.IMPORT_TEST_DATA);
                        this.wizardModel.tasksToExecute.add(WizardTask.ADD_MODULES);
                    } else {
                        this.createTablesTask();
                    }
                    this.wizardModel.tasksToExecute.add(WizardTask.UPDATE_TO_LATEST);
                    referenceMap.put("tasksToExecute", this.wizardModel.tasksToExecute);
                    this.startInstallation();
                    this.renderTemplate(PROGRESS_VM, referenceMap, httpResponse);
                    return;
                }
                if (!TESTING_REMOTE_DETAILS_SETUP.equals(page)) return;
                if (InitializationFilter.goBack(httpRequest)) {
                    --this.wizardModel.currentStepNumber;
                    this.renderTemplate(INSTALL_METHOD, referenceMap, httpResponse);
                    return;
                }
                this.wizardModel.remoteUrl = httpRequest.getParameter("remoteUrl");
                this.checkForEmptyValue(this.wizardModel.remoteUrl, this.errors, "install.testing.remote.url.required");
                if (!this.errors.isEmpty()) break block62;
                if (!TestInstallUtil.testConnection(this.wizardModel.remoteUrl)) break block63;
                if (TestInstallUtil.testConnection(this.wizardModel.remoteUrl.concat("/module/releasetestinghelper/settings.htm"))) {
                    this.wizardModel.remoteUsername = httpRequest.getParameter("username");
                    this.wizardModel.remotePassword = httpRequest.getParameter("password");
                    this.checkForEmptyValue(this.wizardModel.remoteUsername, this.errors, "install.testing.username.required");
                    this.checkForEmptyValue(this.wizardModel.remotePassword, this.errors, "install.testing.password.required");
                    if (!this.errors.isEmpty()) {
                        this.renderTemplate(page, referenceMap, httpResponse);
                        return;
                    }
                    try {
                        TestInstallUtil.getResourceInputStream(this.wizardModel.remoteUrl + RELEASE_TESTING_MODULE_PATH + "verifycredentials.htm", this.wizardModel.remoteUsername, this.wizardModel.remotePassword);
                    }
                    catch (APIAuthenticationException e) {
                        log.debug("Error generated: ", (Throwable)e);
                        page = TESTING_REMOTE_DETAILS_SETUP;
                        this.errors.put("update.error.unableAuthenticate", null);
                        this.renderTemplate(page, referenceMap, httpResponse);
                        return;
                    }
                    if (InitializationFilter.skipDatabaseSetupPage()) {
                        Properties props = OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME);
                        this.wizardModel.databaseConnection = props.getProperty("connection.url");
                        this.loadedDriverString = InitializationFilter.loadDriver(this.wizardModel.databaseConnection, this.wizardModel.databaseDriver);
                        if (!StringUtils.hasText((String)this.loadedDriverString)) {
                            page = TESTING_REMOTE_DETAILS_SETUP;
                            this.errors.put("install.error.dbDriverClass", null);
                            this.renderTemplate(page, referenceMap, httpResponse);
                            return;
                        }
                        this.wizardModel.databaseName = InitializationWizardModel.DEFAULT_DATABASE_NAME;
                        page = WIZARD_COMPLETE;
                    } else {
                        page = DATABASE_SETUP;
                        this.wizardModel.currentStepNumber = 2;
                    }
                    this.msgs.put("install.testing.testingModuleFound", null);
                    break block62;
                } else {
                    this.errors.put("install.testing.noTestingModule", null);
                }
                break block62;
            }
            this.errors.put("install.testing.invalidProductionUrl", new Object[]{this.wizardModel.remoteUrl});
        }
        SessionModelUtils.saveToSession(httpRequest.getSession(), this.wizardModel);
        this.renderTemplate(page, referenceMap, httpResponse);
    }

    private void startInstallation() {
        if (!InitializationFilter.isInstallationStarted()) {
            this.initJob = new InitializationCompletion();
            InitializationFilter.setInstallationStarted(true);
            this.initJob.start();
        }
    }

    private void createTablesTask() {
        if (this.wizardModel.createTables) {
            this.wizardModel.tasksToExecute.add(WizardTask.CREATE_TABLES);
            this.wizardModel.tasksToExecute.add(WizardTask.ADD_CORE_DATA);
        }
    }

    private void createDatabaseTask() {
        if (!this.wizardModel.hasCurrentOpenmrsDatabase.booleanValue()) {
            this.wizardModel.tasksToExecute.add(WizardTask.CREATE_SCHEMA);
        }
        if (this.wizardModel.createDatabaseUser) {
            this.wizardModel.tasksToExecute.add(WizardTask.CREATE_DB_USER);
        }
    }

    private void createSimpleSetup(String databaseRootPassword) {
        this.setDatabaseNameIfInTestMode();
        this.wizardModel.databaseConnection = Context.getRuntimeProperties().getProperty("connection.url", this.wizardModel.databaseConnection);
        this.wizardModel.createUserUsername = this.wizardModel.createDatabaseUsername = Context.getRuntimeProperties().getProperty("connection.username", this.wizardModel.createDatabaseUsername);
        this.wizardModel.databaseRootPassword = databaseRootPassword;
        this.checkForEmptyValue(this.wizardModel.databaseRootPassword, this.errors, "install.error.dbPasswd");
        this.wizardModel.hasCurrentOpenmrsDatabase = false;
        this.wizardModel.createTables = true;
        this.wizardModel.createDatabasePassword = this.wizardModel.databaseRootPassword;
        this.wizardModel.hasCurrentDatabaseUser = false;
        this.wizardModel.createDatabaseUser = true;
        this.wizardModel.createUserPassword = this.wizardModel.databaseRootPassword;
        this.wizardModel.moduleWebAdmin = true;
        this.wizardModel.autoUpdateDatabase = false;
        this.wizardModel.adminUserPassword = "Admin123";
    }

    private void setDatabaseNameIfInTestMode() {
        if (OpenmrsUtil.isTestMode()) {
            this.wizardModel.databaseName = OpenmrsUtil.getOpenMRSVersionInTestMode();
        }
    }

    private void autoRunOpenMRS(HttpServletRequest httpRequest) {
        File runtimeProperties = this.getRuntimePropertiesFile();
        this.wizardModel.runtimePropertiesPath = runtimeProperties.getAbsolutePath();
        if (!"auto".equals(this.wizardModel.installMethod)) {
            if (httpRequest.getParameter("database_user_name") != null) {
                this.wizardModel.createDatabaseUsername = httpRequest.getParameter("database_user_name");
            }
            this.createSimpleSetup(httpRequest.getParameter("database_root_password"));
        }
        this.checkLocaleAttributes(httpRequest);
        try {
            this.loadedDriverString = DatabaseUtil.loadDatabaseDriver((String)this.wizardModel.databaseConnection, (String)this.wizardModel.databaseDriver);
        }
        catch (ClassNotFoundException e) {
            this.errors.put("install.error.dbDriverClass", null);
            return;
        }
        this.wizardModel.tasksToExecute = new ArrayList<WizardTask>();
        this.createDatabaseTask();
        this.createTablesTask();
        this.wizardModel.tasksToExecute.add(WizardTask.UPDATE_TO_LATEST);
        this.startInstallation();
    }

    private void checkLocaleAttributes(HttpServletRequest httpRequest) {
        String localeParameter = httpRequest.getParameter("locale");
        Boolean rememberLocale = false;
        if (httpRequest.getParameter("remember") != null) {
            rememberLocale = true;
        }
        if (localeParameter != null) {
            String storedLocale = null;
            if (httpRequest.getSession().getAttribute("locale") != null) {
                storedLocale = httpRequest.getSession().getAttribute("locale").toString();
            }
            if (storedLocale == null || !storedLocale.equals(localeParameter)) {
                log.info("Stored locale parameter to session " + localeParameter);
                httpRequest.getSession().setAttribute("locale", (Object)localeParameter);
            }
            if (rememberLocale.booleanValue()) {
                httpRequest.getSession().setAttribute("locale", (Object)localeParameter);
                httpRequest.getSession().setAttribute("remember", (Object)true);
                this.wizardModel.localeToSave = localeParameter;
            } else {
                httpRequest.getSession().setAttribute("remember", null);
                this.wizardModel.localeToSave = null;
            }
        }
    }

    public void checkLocaleAttributesForFirstTime(HttpServletRequest httpRequest) {
        Locale locale = httpRequest.getLocale();
        if (CustomResourceLoader.getInstance(httpRequest).getAvailablelocales().contains(locale)) {
            httpRequest.getSession().setAttribute("locale", (Object)locale.toString());
        } else {
            httpRequest.getSession().setAttribute("locale", (Object)Locale.ENGLISH.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyConnection(String connectionUsername, String connectionPassword, String databaseConnectionFinalUrl) {
        try {
            Class.forName(this.loadedDriverString).newInstance();
            try (Connection ignored = DriverManager.getConnection(databaseConnectionFinalUrl, connectionUsername, connectionPassword);){
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.errors.put("User account " + connectionUsername + " does not work. " + e.getMessage() + " See the error log for more details", null);
            log.warn("Error while checking the connection user account", (Throwable)e);
            return false;
        }
    }

    private File getRuntimePropertiesFile() {
        String pathName = OpenmrsUtil.getRuntimePropertiesFilePathName((String)WebConstants.WEBAPP_NAME);
        File file = pathName != null ? new File(pathName) : new File(OpenmrsUtil.getApplicationDataDirectory(), this.getRuntimePropertiesFileName());
        log.debug("Using file: " + file.getAbsolutePath());
        return file;
    }

    private String getRuntimePropertiesFileName() {
        String fileName = OpenmrsUtil.getRuntimePropertiesFileNameInTestMode();
        if (fileName == null) {
            fileName = WebConstants.WEBAPP_NAME + "-runtime.properties";
        }
        return fileName;
    }

    @Override
    protected String getTemplatePrefix() {
        return "org/openmrs/web/filter/initialization/";
    }

    @Override
    protected Object getUpdateFilterModel() {
        return this.wizardModel;
    }

    @Override
    public boolean skipFilter(HttpServletRequest httpRequest) {
        return !PROGRESS_VM_AJAXREQUEST.equals(httpRequest.getParameter("page")) && !InitializationFilter.initializationRequired();
    }

    public static boolean initializationRequired() {
        return !InitializationFilter.isInitializationComplete();
    }

    protected static synchronized void setInstallationStarted(boolean isInstallationStarted) {
        InitializationFilter.isInstallationStarted = isInstallationStarted;
    }

    public static boolean isInstallationStarted() {
        return isInstallationStarted;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.wizardModel = new InitializationWizardModel();
        DatabaseDetective databaseDetective = new DatabaseDetective();
        if (databaseDetective.isDatabaseEmpty(OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME))) {
            this.setInitializationComplete(false);
        } else {
            this.setInitializationComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTestDataSet(InputStream in, String connectionUrl, String connectionUsername, String connectionPassword) throws IOException {
        File tempFile = null;
        FileOutputStream fileOut = null;
        try {
            ZipInputStream zipIn = new ZipInputStream(in);
            zipIn.getNextEntry();
            tempFile = File.createTempFile("testDataSet", "dump");
            fileOut = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)zipIn, (OutputStream)fileOut);
            fileOut.close();
            zipIn.close();
            if (connectionUrl.contains(":mxj:")) {
                connectionUrl = connectionUrl.replace(":mxj:", ":");
            }
            URI uri = URI.create(connectionUrl.substring(5));
            String host = uri.getHost();
            int port = uri.getPort();
            TestInstallUtil.addTestData(host, port, this.wizardModel.databaseName, connectionUsername, connectionPassword, tempFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(fileOut);
            if (tempFile != null) {
                tempFile.delete();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fileOut);
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    private boolean isCurrentDatabase(String database) {
        return this.wizardModel.databaseConnection.contains(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeStatement(boolean silent, String user, String pw, String sql, String ... args) {
        Connection connection = null;
        Statement statement = null;
        try {
            String replacedSql = sql;
            if (this.isCurrentDatabase(DATABASE_MYSQL)) {
                Class.forName("com.mysql.cj.jdbc.Driver").newInstance();
            } else if (this.isCurrentDatabase(DATABASE_POSTGRESQL)) {
                Class.forName("org.postgresql.Driver").newInstance();
                replacedSql = replacedSql.replaceAll("`", "\"");
            } else {
                replacedSql = replacedSql.replaceAll("`", "\"");
            }
            String tempDatabaseConnection = sql.contains("create database") ? this.wizardModel.databaseConnection.replace("@DBNAME@", "") : this.wizardModel.databaseConnection.replace("@DBNAME@", this.wizardModel.databaseName);
            connection = DriverManager.getConnection(tempDatabaseConnection, user, pw);
            for (String arg : args) {
                arg = arg.replace(";", "&#094");
                replacedSql = replacedSql.replaceFirst("\\?", arg);
            }
            statement = connection.createStatement();
            int n = statement.executeUpdate(replacedSql);
            return n;
        }
        catch (SQLException sqlex) {
            if (!silent) {
                log.warn("error executing sql: " + sql, (Throwable)sqlex);
                this.errors.put("Error executing sql: " + sql + " - " + sqlex.getMessage(), null);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Error generated", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.warn("Error while closing statement");
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                log.warn("Error while closing connection", (Throwable)e);
            }
        }
        return -1;
    }

    private static synchronized boolean isInitializationComplete() {
        return initializationComplete;
    }

    private void checkForEmptyValue(String value, Map<String, Object[]> errors, String errorMessageCode) {
        if (!StringUtils.hasText((String)value)) {
            errors.put(errorMessageCode, null);
        }
    }

    public static String loadDriver(String connection, String databaseDriver) {
        String loadedDriverString = null;
        try {
            loadedDriverString = DatabaseUtil.loadDatabaseDriver((String)connection, (String)databaseDriver);
            log.info("using database driver :" + loadedDriverString);
        }
        catch (ClassNotFoundException e) {
            log.error("The given database driver class was not found. Please ensure that the database driver jar file is on the class path (like in the webapp's lib folder)");
        }
        return loadedDriverString;
    }

    private static boolean skipDatabaseSetupPage() {
        Properties props = OpenmrsUtil.getRuntimeProperties((String)WebConstants.WEBAPP_NAME);
        return props != null && StringUtils.hasText((String)props.getProperty("connection.url")) && StringUtils.hasText((String)props.getProperty("connection.username")) && StringUtils.hasText((String)props.getProperty("connection.password"));
    }

    private static boolean goBack(HttpServletRequest httpRequest) {
        return "Back".equals(httpRequest.getParameter("back")) || httpRequest.getParameter("back.x") != null && httpRequest.getParameter("back.y") != null;
    }

    private String normalizeEnvVariableKey(String envVarKey) {
        if (NON_NORMALIZED_KEYS.contains(envVarKey)) {
            return envVarKey.toLowerCase();
        }
        return envVarKey.toLowerCase().replace('_', '.');
    }

    protected Map<String, String> getEnvironmentVariables() {
        return System.getenv();
    }

    protected Properties getInstallationScript() {
        Properties prop;
        block12: {
            String fileName;
            block13: {
                InputStream input;
                block11: {
                    prop = new Properties();
                    fileName = System.getProperty("OPENMRS_INSTALLATION_SCRIPT");
                    if (fileName == null) {
                        return prop;
                    }
                    if (!fileName.startsWith("classpath:")) break block13;
                    fileName = fileName.substring(10);
                    input = null;
                    input = this.getClass().getClassLoader().getResourceAsStream(fileName);
                    if (input != null) break block11;
                    Properties properties = null;
                    IOUtils.closeQuietly((InputStream)input);
                    return properties;
                }
                try {
                    prop.load(input);
                    log.info("Using installation script from classpath: {}", (Object)fileName);
                    input.close();
                }
                catch (IOException ex) {
                    try {
                        log.error("Failed to load installation script from classpath: {}", (Object)fileName, (Object)ex);
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(input);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)input);
                break block12;
            }
            File file = new File(fileName);
            if (file.exists()) {
                FileInputStream input = null;
                try {
                    input = new FileInputStream(fileName);
                    prop.load(input);
                    log.info("Using installation script from absolute path: {}", (Object)file.getAbsolutePath());
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    try {
                        log.error("Failed to load installation script from absolute path: {}", (Object)file.getAbsolutePath(), (Object)ex);
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(input);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        return prop;
    }

    static /* synthetic */ boolean access$100(InitializationFilter x0, String x1) {
        return x0.isCurrentDatabase(x1);
    }

    static /* synthetic */ int access$200(InitializationFilter x0, boolean x1, String x2, String x3, String x4, String[] x5) {
        return x0.executeStatement(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ boolean access$300(InitializationFilter x0, String x1, String x2, String x3) {
        return x0.verifyConnection(x1, x2, x3);
    }

    static /* synthetic */ void access$400(InitializationFilter x0, InputStream x1, String x2, String x3, String x4) throws IOException {
        x0.importTestDataSet(x1, x2, x3, x4);
    }

    static /* synthetic */ FilterConfig access$500(InitializationFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ File access$600(InitializationFilter x0) {
        return x0.getRuntimePropertiesFile();
    }

    static /* synthetic */ FilterConfig access$700(InitializationFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ FilterConfig access$800(InitializationFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ FilterConfig access$900(InitializationFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ FilterConfig access$1000(InitializationFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ FilterConfig access$1100(InitializationFilter x0) {
        return x0.filterConfig;
    }

    private class InitializationCompletion {
        private final Future<Void> future;
        private int steps = 0;
        private String message = "";
        private Map<String, Object[]> errors = new HashMap<String, Object[]>();
        private String errorPage = null;
        private boolean erroneous = false;
        private int completedPercentage = 0;
        private WizardTask executingTask;
        private List<WizardTask> executedTasks = new ArrayList<WizardTask>();

        public synchronized void reportError(String error, String errorPage, Object ... params) {
            this.errors.put(error, params);
            this.errorPage = errorPage;
            this.erroneous = true;
        }

        public synchronized boolean hasErrors() {
            return this.erroneous;
        }

        public synchronized String getErrorPage() {
            return this.errorPage;
        }

        public synchronized Map<String, Object[]> getErrors() {
            return this.errors;
        }

        public void start() {
            this.setStepsComplete(0);
            InitializationFilter.this.setInitializationComplete(false);
        }

        public void waitForCompletion() {
            try {
                this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        protected synchronized void setStepsComplete(int steps) {
            this.steps = steps;
        }

        protected synchronized int getStepsComplete() {
            return this.steps;
        }

        public synchronized String getMessage() {
            return this.message;
        }

        public synchronized void setMessage(String message) {
            log.debug(message);
            this.message = message;
            this.setStepsComplete(this.getStepsComplete() + 1);
        }

        protected synchronized WizardTask getExecutingTask() {
            return this.executingTask;
        }

        protected synchronized int getCompletedPercentage() {
            return this.completedPercentage;
        }

        protected synchronized void setCompletedPercentage(int completedPercentage) {
            this.completedPercentage = completedPercentage;
        }

        protected synchronized void addExecutedTask(WizardTask task) {
            this.executedTasks.add(task);
        }

        protected synchronized void setExecutingTask(WizardTask executingTask) {
            this.executingTask = executingTask;
        }

        protected synchronized List<WizardTask> getExecutedTasks() {
            return this.executedTasks;
        }

        public InitializationCompletion() {
            Runnable r = new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            this.future = OpenmrsThreadPoolHolder.threadExecutor.submit(() -> {
                r.run();
                return null;
            });
        }
    }
}

