/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.initialization;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openmrs.api.APIAuthenticationException;
import org.openmrs.api.APIException;
import org.openmrs.api.context.Context;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.web.filter.util.FilterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInstallUtil {
    private static final Logger log = LoggerFactory.getLogger(TestInstallUtil.class);

    private TestInstallUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addTestData(String host, int port, String databaseName, String user, String pwd, String filePath) {
        BufferedReader br = null;
        String errorMsg = null;
        String[] command = new String[]{"mysql", "--host=" + host, "--port=" + port, "--user=" + user, "--password=" + pwd, "--database=" + databaseName, "-e", "source " + filePath};
        String runDirectory = System.getProperties().getProperty("user.dir");
        File file = Paths.get(runDirectory, "database", "bin", "mysql").toFile();
        if (file.exists()) {
            command[0] = file.getAbsolutePath();
        }
        try {
            Process proc = Runtime.getRuntime().exec(command);
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(proc.getErrorStream(), StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(System.getProperty("line.separator"));
                    sb.append(line);
                }
                errorMsg = sb.toString();
            }
            catch (IOException e) {
                log.error("Failed to add test data:", (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        log.error("Failed to close the inputstream:", (Throwable)e);
                    }
                }
            }
            if (StringUtils.isNotBlank(errorMsg)) {
                log.error(errorMsg);
            }
            if (proc.waitFor() == 0) {
                log.debug("Added test data successfully");
                return true;
            }
            log.error("The process terminated abnormally while adding test data. Please look under the Configuration section at: https://wiki.openmrs.org/display/docs/Release+Testing+Helper+Module");
        }
        catch (IOException e) {
            log.error("Failed to create the sql dump", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("The back up was interrupted while adding test data", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addZippedTestModules(InputStream in) {
        ZipFile zipFile = null;
        FileOutputStream out = null;
        File tempFile = null;
        boolean successfullyAdded = true;
        try {
            tempFile = File.createTempFile("modules", null);
            out = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            zipFile = new ZipFile(tempFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    log.debug("Skipping directory: {}", (Object)entry.getName());
                    continue;
                }
                String fileName = entry.getName();
                if (fileName.endsWith(".omod")) {
                    String appDataDirectory;
                    if (fileName.contains(System.getProperty("file.separator"))) {
                        fileName = new File(entry.getName()).getName();
                    }
                    log.debug("Extracting module file: {}", (Object)fileName);
                    String moduleRepositoryFolder = FilterUtil.getGlobalPropertyValue("module_repository_folder");
                    if (StringUtils.isBlank((CharSequence)moduleRepositoryFolder)) {
                        moduleRepositoryFolder = "modules";
                    }
                    if (StringUtils.isNotBlank((CharSequence)(appDataDirectory = Context.getRuntimeProperties().getProperty("application_data_directory")))) {
                        OpenmrsUtil.setApplicationDataDirectory((String)appDataDirectory);
                    }
                    File moduleRepository = OpenmrsUtil.getDirectoryInApplicationDataDirectory((String)moduleRepositoryFolder);
                    FileUtils.cleanDirectory((File)moduleRepository);
                    File zipEntryFile = new File(moduleRepository, fileName);
                    if (!zipEntryFile.toPath().normalize().startsWith(moduleRepository.toPath().normalize())) {
                        throw new IOException("Bad zip entry");
                    }
                    OpenmrsUtil.copyFile((InputStream)zipFile.getInputStream(entry), (OutputStream)new BufferedOutputStream(new FileOutputStream(zipEntryFile)));
                    continue;
                }
                log.debug("Ignoring file that is not a .omod '{}'", (Object)fileName);
            }
        }
        catch (IOException e) {
            try {
                log.error("An error occured while copying modules to the test system:", (Throwable)e);
                successfullyAdded = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e2) {
                        log.error("Failed to close zip file: ", (Throwable)e2);
                    }
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e3) {
                    log.error("Failed to close zip file: ", (Throwable)e3);
                }
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                log.error("Failed to close zip file: ", (Throwable)e);
            }
        }
        if (tempFile != null) {
            tempFile.delete();
        }
        return successfullyAdded;
    }

    protected static boolean testConnection(String urlString) {
        try {
            HttpURLConnection urlConnect = (HttpURLConnection)new URL(urlString).openConnection();
            urlConnect.setConnectTimeout(15000);
            urlConnect.setUseCaches(false);
            urlConnect.getContent();
            return true;
        }
        catch (IOException e) {
            log.debug("Error generated:", (Throwable)e);
            return false;
        }
    }

    protected static InputStream getResourceInputStream(String url, String openmrsUsername, String openmrsPassword) throws MalformedURLException, IOException, APIException {
        HttpURLConnection connection = TestInstallUtil.createConnection(url);
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        out.write(TestInstallUtil.encodeCredentials(openmrsUsername, openmrsPassword));
        out.flush();
        out.close();
        log.info("Http response message: {}, Code: {}", (Object)connection.getResponseMessage(), (Object)connection.getResponseCode());
        if (connection.getResponseCode() == 401) {
            throw new APIAuthenticationException("Invalid username or password");
        }
        if (connection.getResponseCode() == 500) {
            throw new APIException("error.occurred.on.remote.server", (Object[])null);
        }
        return connection.getInputStream();
    }

    private static HttpURLConnection createConnection(String url) throws IOException, MalformedURLException {
        HttpURLConnection result = (HttpURLConnection)new URL(url).openConnection();
        result.setRequestMethod("POST");
        result.setConnectTimeout(15000);
        result.setUseCaches(false);
        result.setDoOutput(true);
        return result;
    }

    private static String encodeCredentials(String openmrsUsername, String openmrsPassword) {
        StringBuilder result = new StringBuilder();
        result.append("username=");
        Base64.Encoder encoder = Base64.getEncoder();
        Charset utf8 = StandardCharsets.UTF_8;
        result.append(new String(encoder.encode(openmrsUsername.getBytes(utf8)), utf8));
        result.append("&password=");
        result.append(new String(encoder.encode(openmrsPassword.getBytes(utf8)), utf8));
        return result.toString();
    }
}

