/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import liquibase.exception.LockException;
import org.apache.commons.lang3.StringUtils;
import org.openmrs.util.DatabaseUpdater;
import org.openmrs.util.OpenmrsThreadPoolHolder;
import org.openmrs.util.OpenmrsUtil;
import org.openmrs.util.Security;
import org.openmrs.web.Listener;
import org.openmrs.web.WebDaemon;
import org.openmrs.web.filter.StartupFilter;
import org.openmrs.web.filter.initialization.InitializationFilter;
import org.openmrs.web.filter.update.UpdateFilterModel;
import org.openmrs.web.filter.util.CustomResourceLoader;
import org.openmrs.web.filter.util.FilterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoader;

public class UpdateFilter
extends StartupFilter {
    protected final Logger log = LoggerFactory.getLogger(UpdateFilter.class);
    private static final String DEFAULT_PAGE = "maintenance.vm";
    private static final String REVIEW_CHANGES = "reviewchanges.vm";
    private static final String PROGRESS_VM_AJAXREQUEST = "updateProgress.vm.ajaxRequest";
    private UpdateFilterModel updateFilterModel = null;
    private static boolean updatesRequired = true;
    private volatile boolean authenticatedSuccessfully = false;
    private UpdateFilterCompletion updateJob;
    private static boolean isDatabaseUpdateInProgress = false;
    private static Boolean lockReleased = false;

    @Override
    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        HashMap<String, Object> referenceMap = new HashMap<String, Object>();
        this.checkLocaleAttributesForFirstTime(httpRequest);
        if (httpRequest.getSession().getAttribute("locale") != null) {
            referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
        }
        this.renderTemplate(DEFAULT_PAGE, referenceMap, httpResponse);
    }

    @Override
    protected synchronized void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String updJobStatus = "updateJobStarted";
        String page = httpRequest.getParameter("page");
        HashMap<String, Object> referenceMap = new HashMap<String, Object>();
        if (httpRequest.getSession().getAttribute("locale") != null) {
            referenceMap.put("locale", httpRequest.getSession().getAttribute("locale"));
        }
        if (DEFAULT_PAGE.equals(page)) {
            String username = httpRequest.getParameter("username");
            String password = httpRequest.getParameter("password");
            this.log.debug("Attempting to authenticate user: " + username);
            if (this.authenticateAsSuperUser(username, password)) {
                this.log.debug("Authentication successful.  Redirecting to 'reviewupdates' page.");
                this.authenticatedSuccessfully = true;
                referenceMap.put("isDatabaseUpdateInProgress", isDatabaseUpdateInProgress);
                if (isDatabaseUpdateInProgress) {
                    referenceMap.put("updateJobStarted", true);
                    httpResponse.setContentType("text/html");
                    this.renderTemplate(REVIEW_CHANGES, referenceMap, httpResponse);
                    return;
                }
                if (!UpdateFilter.isLockReleased().booleanValue() && DatabaseUpdater.isLocked()) {
                    try {
                        DatabaseUpdater.releaseDatabaseLock();
                        UpdateFilter.setLockReleased(true);
                    }
                    catch (LockException lockException) {
                        // empty catch block
                    }
                    this.updateFilterModel.updateChanges();
                }
                String localeParameter = FilterUtil.restoreLocale(username);
                httpRequest.getSession().setAttribute("locale", (Object)localeParameter);
                referenceMap.put("locale", localeParameter);
                this.renderTemplate(REVIEW_CHANGES, referenceMap, httpResponse);
            } else {
                try {
                    this.log.debug("Sleeping for 3 seconds because of a bad username/password");
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    this.log.error("Unable to sleep", (Throwable)e);
                    throw new ServletException("Got interrupted while trying to sleep thread", (Throwable)e);
                }
                this.errors.put("update.error.unableAuthenticate", null);
                this.renderTemplate(DEFAULT_PAGE, referenceMap, httpResponse);
            }
        } else if (REVIEW_CHANGES.equals(page)) {
            if (!this.authenticatedSuccessfully) {
                this.renderTemplate(DEFAULT_PAGE, referenceMap, httpResponse);
                return;
            }
            if (!isDatabaseUpdateInProgress) {
                isDatabaseUpdateInProgress = true;
                this.updateJob = new UpdateFilterCompletion();
                this.updateJob.start();
                referenceMap.put("updateJobStarted", true);
            } else {
                referenceMap.put("isDatabaseUpdateInProgress", true);
                referenceMap.put("updateJobStarted", true);
            }
            this.renderTemplate(REVIEW_CHANGES, referenceMap, httpResponse);
        } else if (PROGRESS_VM_AJAXREQUEST.equals(page)) {
            httpResponse.setContentType("text/json");
            httpResponse.setHeader("Cache-Control", "no-cache");
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (this.updateJob != null) {
                result.put("hasErrors", this.updateJob.hasErrors());
                if (this.updateJob.hasErrors()) {
                    this.errors.putAll(this.updateJob.getErrors());
                }
                if (this.updateJob.hasWarnings() && this.updateJob.getExecutingChangesetId() == null) {
                    result.put("hasWarnings", this.updateJob.hasWarnings());
                    StringBuilder sb = new StringBuilder("<ul>");
                    for (String warning : this.updateJob.getUpdateWarnings()) {
                        sb.append("<li>").append(warning).append("</li>");
                    }
                    sb.append("</ul>");
                    result.put("updateWarnings", sb.toString());
                    result.put("updateLogFile", StringUtils.replace((String)(OpenmrsUtil.getApplicationDataDirectory() + "liquibaseUpdateLogs.txt"), (String)"\\", (String)"\\\\"));
                    this.updateJob.hasUpdateWarnings = false;
                    this.updateJob.getUpdateWarnings().clear();
                }
                result.put("updatesRequired", UpdateFilter.updatesRequired());
                result.put("message", this.updateJob.getMessage());
                result.put("changesetIds", this.updateJob.getChangesetIds());
                result.put("executingChangesetId", this.updateJob.getExecutingChangesetId());
                this.addLogLinesToResponse(result);
            }
            String jsonText = this.toJSONString(result);
            httpResponse.getWriter().write(jsonText);
        }
    }

    public void checkLocaleAttributesForFirstTime(HttpServletRequest httpRequest) {
        Locale locale = httpRequest.getLocale();
        String systemDefaultLocale = FilterUtil.readSystemDefaultLocale(null);
        if (CustomResourceLoader.getInstance(httpRequest).getAvailablelocales().contains(locale)) {
            httpRequest.getSession().setAttribute("locale", (Object)locale.toString());
            this.log.info("Used client's locale " + locale.toString());
        } else if (StringUtils.isNotBlank((CharSequence)systemDefaultLocale)) {
            httpRequest.getSession().setAttribute("locale", (Object)systemDefaultLocale);
            this.log.info("Used system default locale " + systemDefaultLocale);
        } else {
            httpRequest.getSession().setAttribute("locale", (Object)Locale.ENGLISH.toString());
            this.log.info("Used default locale " + Locale.ENGLISH.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticateAsSuperUser(String usernameOrSystemId, String password) throws ServletException {
        block66: {
            Connection connection = null;
            try {
                connection = DatabaseUpdater.getConnection();
                String select = "select user_id, password, salt from users where (username = ? or system_id = ?) and retired = '0'";
                PreparedStatement statement = null;
                try {
                    statement = connection.prepareStatement(select);
                    statement.setString(1, usernameOrSystemId);
                    statement.setString(2, usernameOrSystemId);
                    if (!statement.execute()) break block66;
                    ResultSet results = null;
                    try {
                        results = statement.getResultSet();
                        if (results.next()) {
                            Integer userId = results.getInt(1);
                            DatabaseUpdater.setAuthenticatedUserId((Integer)userId);
                            String storedPassword = results.getString(2);
                            String salt = results.getString(3);
                            String passwordToHash = password + salt;
                            boolean bl = Security.hashMatches((String)storedPassword, (String)passwordToHash) && this.isSuperUser(connection, userId);
                            return bl;
                        }
                    }
                    finally {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Exception resultsCloseEx) {
                                this.log.error("Failed to quietly close ResultSet", (Throwable)resultsCloseEx);
                            }
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception statementCloseEx) {
                            this.log.error("Failed to quietly close Statement", (Throwable)statementCloseEx);
                        }
                    }
                }
            }
            catch (Exception connectionEx) {
                this.log.error("Error while trying to authenticate as super user. Ignore this if you are upgrading from OpenMRS 1.5 to 1.6", (Throwable)connectionEx);
                if (connection == null) break block66;
                String select = "select user_id, password, salt from users where (username = ? or system_id = ?) and voided = '0'";
                PreparedStatement statement = null;
                try {
                    statement = connection.prepareStatement(select);
                    statement.setString(1, usernameOrSystemId);
                    statement.setString(2, usernameOrSystemId);
                    if (!statement.execute()) break block66;
                    ResultSet results = null;
                    try {
                        results = statement.getResultSet();
                        if (results.next()) {
                            Integer userId = results.getInt(1);
                            DatabaseUpdater.setAuthenticatedUserId((Integer)userId);
                            String storedPassword = results.getString(2);
                            String salt = results.getString(3);
                            String passwordToHash = password + salt;
                            boolean bl = Security.hashMatches((String)storedPassword, (String)passwordToHash) && this.isSuperUser(connection, userId);
                            return bl;
                        }
                    }
                    finally {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Exception resultsCloseEx) {
                                this.log.error("Failed to quietly close ResultSet", (Throwable)resultsCloseEx);
                            }
                        }
                    }
                }
                catch (Exception unhandeledEx) {
                    this.log.error("Error while trying to authenticate as super user (voided version)", (Throwable)unhandeledEx);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception statementCloseEx) {
                            this.log.error("Failed to quietly close Statement", (Throwable)statementCloseEx);
                        }
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.log.debug("Error while closing the database", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    protected boolean isSuperUser(Connection connection, Integer userId) throws SQLException {
        ResultSet results;
        String select = "select 1 from user_role where user_id = ? and (role = ? or role = 'Administrator')";
        PreparedStatement statement = connection.prepareStatement(select);
        statement.setInt(1, userId);
        statement.setString(2, "System Developer");
        if (statement.execute() && (results = statement.getResultSet()).next()) {
            return results.getInt(1) == 1;
        }
        return false;
    }

    private void startOpenmrs(ServletContext servletContext) throws Exception {
        ContextLoader contextLoader = new ContextLoader();
        contextLoader.initWebApplicationContext(servletContext);
        try {
            WebDaemon.startOpenmrs(servletContext);
        }
        catch (Exception exception) {
            contextLoader.closeWebApplicationContext(servletContext);
            throw exception;
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.log.debug("Initializing the UpdateFilter");
        if (!InitializationFilter.initializationRequired() || Listener.isSetupNeeded() && Listener.runtimePropertiesFound()) {
            this.updateFilterModel = new UpdateFilterModel();
            try {
                if (this.updateFilterModel.updateRequired.booleanValue()) {
                    UpdateFilter.setUpdatesRequired(true);
                }
                if (this.updateFilterModel.changes == null) {
                    UpdateFilter.setUpdatesRequired(false);
                }
                this.log.debug("Setting updates required to {} because of the size of unrun changes", (Object)(!this.updateFilterModel.changes.isEmpty() ? 1 : 0));
                UpdateFilter.setUpdatesRequired(!this.updateFilterModel.changes.isEmpty());
            }
            catch (Exception e) {
                throw new ServletException("Unable to determine if updates are required", (Throwable)e);
            }
        } else {
            this.log.debug("Setting updates required to false because the user doesn't have any runtime properties yet or database is empty");
            UpdateFilter.setUpdatesRequired(false);
        }
    }

    @Override
    protected Object getUpdateFilterModel() {
        return this.updateFilterModel;
    }

    @Override
    public boolean skipFilter(HttpServletRequest httpRequest) {
        return !PROGRESS_VM_AJAXREQUEST.equals(httpRequest.getParameter("page")) && !UpdateFilter.updatesRequired();
    }

    public static synchronized boolean updatesRequired() {
        return updatesRequired;
    }

    public static synchronized void setUpdatesRequired(boolean updatesRequired) {
        UpdateFilter.updatesRequired = updatesRequired;
    }

    public static Boolean isLockReleased() {
        return lockReleased;
    }

    public static synchronized void setLockReleased(Boolean lockReleased) {
        UpdateFilter.lockReleased = lockReleased;
    }

    @Override
    protected String getTemplatePrefix() {
        return "org/openmrs/web/filter/update/";
    }

    static /* synthetic */ UpdateFilterModel access$200(UpdateFilter x0) {
        return x0.updateFilterModel;
    }

    static /* synthetic */ FilterConfig access$300(UpdateFilter x0) {
        return x0.filterConfig;
    }

    static /* synthetic */ void access$400(UpdateFilter x0, ServletContext x1) throws Exception {
        x0.startOpenmrs(x1);
    }

    static /* synthetic */ boolean access$502(boolean x0) {
        isDatabaseUpdateInProgress = x0;
        return isDatabaseUpdateInProgress;
    }

    private class UpdateFilterCompletion {
        private Runnable r;
        private String executingChangesetId = null;
        private List<String> changesetIds = new ArrayList<String>();
        private Map<String, Object[]> errors = new HashMap<String, Object[]>();
        private String message = null;
        private boolean erroneous = false;
        private boolean hasUpdateWarnings = false;
        private List<String> updateWarnings = new LinkedList<String>();

        public synchronized void reportError(String error, Object ... params) {
            HashMap<String, Object[]> reportedErrors = new HashMap<String, Object[]>();
            reportedErrors.put(error, params);
            this.reportErrors(reportedErrors);
        }

        public synchronized void reportErrors(Map<String, Object[]> errs) {
            this.errors.putAll(errs);
            this.erroneous = true;
        }

        public synchronized boolean hasErrors() {
            return this.erroneous;
        }

        public synchronized Map<String, Object[]> getErrors() {
            return this.errors;
        }

        public void start() {
            UpdateFilter.setUpdatesRequired(true);
            OpenmrsThreadPoolHolder.threadExecutor.submit(this.r);
        }

        public synchronized void setMessage(String message) {
            this.message = message;
        }

        public synchronized String getMessage() {
            return this.message;
        }

        public synchronized void addChangesetId(String changesetid) {
            this.changesetIds.add(changesetid);
            this.executingChangesetId = changesetid;
        }

        public synchronized List<String> getChangesetIds() {
            return this.changesetIds;
        }

        public synchronized String getExecutingChangesetId() {
            return this.executingChangesetId;
        }

        public synchronized List<String> getUpdateWarnings() {
            return this.updateWarnings;
        }

        public synchronized boolean hasWarnings() {
            return this.hasUpdateWarnings;
        }

        public synchronized void reportWarnings(List<String> warnings) {
            this.updateWarnings.addAll(warnings);
            this.hasUpdateWarnings = true;
        }

        public UpdateFilterCompletion() {
            this.r = new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
        }

        static /* synthetic */ String access$102(UpdateFilterCompletion x0, String x1) {
            x0.executingChangesetId = x1;
            return x0.executingChangesetId;
        }
    }
}

