/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.openmrs.util.LocaleUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CustomResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(CustomResourceLoader.class);
    public static final String PREFIX = "messages";
    private Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>();
    private Set<Locale> availablelocales = new HashSet<Locale>();
    private static CustomResourceLoader instance = null;

    private CustomResourceLoader(HttpServletRequest httpRequest) {
        try {
            Resource[] localResources;
            PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
            for (Resource localeResource : localResources = patternResolver.getResources("classpath*:messages*.properties")) {
                Locale locale = this.parseLocaleFrom(localeResource.getFilename(), PREFIX);
                PropertyResourceBundle rb = new PropertyResourceBundle(new InputStreamReader(localeResource.getInputStream(), StandardCharsets.UTF_8));
                this.getResource().put(locale, rb);
                this.getAvailablelocales().add(locale);
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static CustomResourceLoader getInstance(HttpServletRequest httpRequest) {
        if (instance == null) {
            instance = new CustomResourceLoader(httpRequest);
        }
        return instance;
    }

    private Locale parseLocaleFrom(String filename, String basename) {
        Locale result;
        String localespec;
        String tempFilename = filename;
        if (filename.startsWith(basename)) {
            tempFilename = filename.substring(basename.length());
        }
        if ("".equals(localespec = tempFilename.substring(0, tempFilename.indexOf(46)))) {
            result = Locale.ENGLISH;
        } else {
            localespec = localespec.substring(1);
            result = LocaleUtility.fromSpecification((String)localespec);
        }
        return result;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.resources.get(locale);
    }

    public Map<Locale, ResourceBundle> getResource() {
        return this.resources;
    }

    public Set<Locale> getAvailablelocales() {
        return this.availablelocales;
    }
}

