/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openmrs.util.DatabaseUpdater;
import org.openmrs.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtil {
    private static final Logger log = LoggerFactory.getLogger(FilterUtil.class);
    private static final String DATABASE_CLOSING_ERROR = "Error while closing the database";
    public static final String LOCALE_ATTRIBUTE = "locale";
    public static final String REMEMBER_ATTRIBUTE = "remember";
    public static final String ADMIN_USERNAME = "admin";

    private FilterUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String restoreLocale(String username) {
        String currentLocale = null;
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Statement statement = null;
            Connection connection = null;
            ResultSet results = null;
            try {
                connection = DatabaseUpdater.getConnection();
                Integer userId = FilterUtil.getUserIdByName(username, connection);
                if (userId != null) {
                    String select = "select property_value from user_property where user_id = ? and property = ?";
                    statement = connection.prepareStatement(select);
                    statement.setInt(1, userId);
                    statement.setString(2, "defaultLocale");
                    if (statement.execute() && (results = statement.getResultSet()).next()) {
                        currentLocale = results.getString(1);
                    }
                }
                if (currentLocale == null) {
                    currentLocale = FilterUtil.readSystemDefaultLocale(connection);
                }
            }
            catch (Exception e) {
                log.error("Error while retriving locale property", (Throwable)e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    log.warn("Error while closing statement");
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        log.debug(DATABASE_CLOSING_ERROR, (Throwable)e);
                    }
                }
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        log.warn("Error while closing ResultSet", (Throwable)e);
                    }
                }
            }
        }
        if (currentLocale == null) {
            currentLocale = "en_GB";
        }
        return currentLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSystemDefaultLocale(Connection connection) {
        String systemDefaultLocale = null;
        boolean needToCloseConection = false;
        try {
            ResultSet results;
            if (connection == null) {
                connection = DatabaseUpdater.getConnection();
                needToCloseConection = true;
            }
            String select = "select property_value from global_property where property = ?";
            PreparedStatement statement = connection.prepareStatement(select);
            statement.setString(1, "default_locale");
            if (statement.execute() && (results = statement.getResultSet()).next()) {
                systemDefaultLocale = results.getString(1);
            }
        }
        catch (Exception e) {
            log.error("Error while retrieving system default locale", (Throwable)e);
        }
        finally {
            if (needToCloseConection && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.debug(DATABASE_CLOSING_ERROR, (Throwable)e);
                }
            }
        }
        return systemDefaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeLocale(String locale) {
        if (StringUtils.isNotBlank((CharSequence)locale)) {
            Connection connection = null;
            Integer userId = null;
            try {
                PreparedStatement statement;
                connection = DatabaseUpdater.getConnection();
                userId = FilterUtil.getUserIdByName(ADMIN_USERNAME, connection);
                if (userId != null) {
                    String insert = "insert into user_property (user_id, property, property_value) values (?, 'defaultLocale', ?)";
                    statement = null;
                    try {
                        statement = connection.prepareStatement(insert);
                        statement.setInt(1, userId);
                        statement.setString(2, locale);
                        if (statement.executeUpdate() != 1) {
                            log.warn("Unable to save user locale as admin property.");
                        }
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception statementCloseEx) {
                                log.error("Failed to quietly close Statement", (Throwable)statementCloseEx);
                            }
                        }
                    }
                }
                String update = "update global_property set property_value = ? where property = ? ";
                statement = null;
                try {
                    statement = connection.prepareStatement(update);
                    statement.setString(1, locale);
                    statement.setString(2, "default_locale");
                    if (statement.executeUpdate() != 1) {
                        log.warn("Unable to set system default locale property.");
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception statementCloseEx) {
                            log.error("Failed to quietly close Statement", (Throwable)statementCloseEx);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("Locale " + locale + " could not be set for user with id " + userId + " .", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        log.debug(DATABASE_CLOSING_ERROR, (Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static Integer getUserIdByName(String userNameOrSystemId, Connection connection) throws SQLException {
        ResultSet results;
        String select = "select user_id from users where system_id = ? or username = ?";
        PreparedStatement statement = connection.prepareStatement(select);
        statement.setString(1, userNameOrSystemId);
        statement.setString(2, userNameOrSystemId);
        Integer userId = null;
        if (statement.execute() && (results = statement.getResultSet()).next()) {
            userId = results.getInt(1);
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalPropertyValue(String globalPropertyName) {
        String propertyValue = null;
        Connection connection = null;
        try {
            connection = DatabaseUpdater.getConnection();
            List results = DatabaseUtil.executeSQL((Connection)connection, (String)("select property_value from global_property where property = '" + globalPropertyName + "'"), (boolean)true);
            if (results.size() == 1 && ((List)results.get(0)).size() == 1) {
                propertyValue = ((List)results.get(0)).get(0).toString();
            }
        }
        catch (Exception e) {
            log.error("Error while retrieving value for global property:" + globalPropertyName, (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.debug("Error while closing the database connection", (Throwable)e);
                }
            }
        }
        return propertyValue;
    }
}

