/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.util;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.ResourceTool;
import org.openmrs.util.LocaleUtility;
import org.openmrs.web.filter.util.CustomResourceLoader;

@DefaultKey(value="l10n")
public class LocalizationTool
extends ResourceTool {
    private static ResourceBundle defaultResourceBundle = null;

    public void setLocale(Locale locale) {
        super.setLocale(locale);
    }

    public static ResourceBundle getDefaultResourceBundle() {
        if (defaultResourceBundle == null) {
            defaultResourceBundle = CustomResourceLoader.getInstance(null).getResourceBundle(Locale.ENGLISH);
        }
        return defaultResourceBundle;
    }

    protected ResourceBundle getBundle(String baseName, Object loc) {
        Locale locale;
        Locale locale2 = locale = loc == null ? this.getLocale() : LocaleUtility.fromSpecification((String)String.valueOf(loc));
        if (baseName == null || locale == null) {
            return null;
        }
        ResourceBundle rb = CustomResourceLoader.getInstance(null).getResourceBundle(locale);
        if (rb == null) {
            rb = LocalizationTool.getDefaultResourceBundle();
        }
        return rb;
    }

    public Object get(Object code, String[] resourceNamePrefixes, Object locale) {
        Object msg = super.get(code, resourceNamePrefixes, locale);
        if (msg == null || StringUtils.isBlank((CharSequence)msg.toString())) {
            msg = super.get(code, resourceNamePrefixes, (Object)Locale.ENGLISH.toString());
        }
        return msg;
    }
}

