/*
 * Decompiled with CFR 0.152.
 */
package org.openmrs.web.filter.util;

import java.lang.reflect.Field;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.openmrs.web.filter.initialization.InitializationWizardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionModelUtils {
    private static final Logger log = LoggerFactory.getLogger(SessionModelUtils.class);
    private static final String PREFIX = "setup.";

    public static void saveToSession(HttpSession session, InitializationWizardModel model) {
        if (session == null || model == null) {
            return;
        }
        for (Field field : model.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName().toLowerCase();
            if (fieldName.contains("password") || fieldName.equals("localetosave")) continue;
            try {
                Object value = field.get(model);
                if (value == null) continue;
                String key = PREFIX + field.getName();
                session.setAttribute(key, value);
            }
            catch (IllegalAccessException e) {
                log.error("Could not access field during save: {}", (Object)field.getName(), (Object)e);
            }
        }
    }

    public static void loadFromSession(HttpSession session, InitializationWizardModel model) {
        if (session == null || model == null) {
            return;
        }
        for (Field field : model.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName().toLowerCase();
            if (fieldName.contains("password") || fieldName.equals("localetosave")) continue;
            try {
                String key = PREFIX + field.getName();
                Object value = session.getAttribute(key);
                if (value == null) continue;
                field.set(model, value);
            }
            catch (IllegalAccessException e) {
                log.error("Could not set field during load: {}", (Object)field.getName(), (Object)e);
            }
        }
    }

    public static void clearWizardSessionAttributes(HttpSession session) {
        if (session == null) {
            return;
        }
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(PREFIX)) continue;
            session.removeAttribute(name);
        }
    }
}

