/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinDeprecatedMethodFilter
extends CoverageFilter {
    private boolean myShouldIgnore;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinUtils.isKotlinClass(context);
    }

    /*
     * WARNING - void declaration
     */
    public void initFilter(MethodVisitor methodVisitor, InstrumentationData context) {
        Set<String> deprecatedMethods;
        super.initFilter(methodVisitor, context);
        String name = context.getMethodName();
        if (name.endsWith("$default") && (deprecatedMethods = this.myContext.get(Key.DEPRECATED_METHODS)) != null) {
            void var1_1;
            void var2_2;
            String originalName = name.substring(0, name.length() - 8);
            if (var2_2.contains(var1_1)) {
                this.myContext.setIgnoreSection(true);
                this.myShouldIgnore = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var2_3;
        void var1_1;
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(var1_1)) {
            return av;
        }
        return new AnnotationVisitor(this, 589824, (AnnotationVisitor)var2_3){
            final /* synthetic */ KotlinDeprecatedMethodFilter this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2, (AnnotationVisitor)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            public void visitEnum(String name, String descriptor, String value) {
                void var3_3;
                void var2_2;
                super.visitEnum(name, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(var2_2)) {
                    return;
                }
                if ("ERROR".equals(value) || "HIDDEN".equals(var3_3)) {
                    void var1_1;
                    Set<String> deprecatedMethods;
                    if (!this.this$0.myShouldIgnore) {
                        this.this$0.myContext.setIgnoreSection(true);
                        KotlinDeprecatedMethodFilter.access$002(this.this$0, true);
                    }
                    if ((deprecatedMethods = this.this$0.myContext.get(Key.DEPRECATED_METHODS)) == null) {
                        deprecatedMethods = new HashSet<String>();
                        this.this$0.myContext.put(Key.DEPRECATED_METHODS, deprecatedMethods);
                    }
                    var1_1.add(this.this$0.myContext.getMethodName());
                }
            }
        };
    }

    public void visitCode() {
        super.visitCode();
        if (this.myShouldIgnore) {
            this.myContext.get(Key.PROJECT_DATA).getIgnoredStorage().addIgnoredMethod(this.myContext.get(Key.CLASS_NAME), this.myContext.getMethodName(), this.myContext.getMethodDesc());
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(KotlinDeprecatedMethodFilter x0, boolean x1) {
        void var1_1;
        x0.myShouldIgnore = var1_1;
        return x0.myShouldIgnore;
    }
}

