/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.psi.Angular2EmbeddedExpression;
import org.angular2.lang.expr.psi.Angular2PipeArgumentsList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J%\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/angular2/inspections/Angular2InspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "()V", "PREFIXES_TO_STRIP", "", "", "[Ljava/lang/String;", "getStatementToolSuppressedIn", "Lcom/intellij/psi/PsiElement;", "place", "toolId", "getSuppressActions", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "isSuppressedFor", "", "isSuppressedInStatement", "stripToolIdPrefix", "Angular2SuppressByCommentFix", "intellij.angular"})
public final class Angular2InspectionSuppressor
implements InspectionSuppressor {
    @NotNull
    public static final Angular2InspectionSuppressor INSTANCE = new Angular2InspectionSuppressor();
    @NonNls
    @NotNull
    private static final String[] PREFIXES_TO_STRIP;

    private Angular2InspectionSuppressor() {
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return this.isSuppressedInStatement(element, this.stripToolIdPrefix(toolId));
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new Angular2SuppressByCommentFix(this.stripToolIdPrefix(toolId))};
        return suppressQuickFixArray;
    }

    private final PsiElement getStatementToolSuppressedIn(PsiElement place, String toolId) {
        Angular2EmbeddedExpression statement = (Angular2EmbeddedExpression)PsiTreeUtil.getParentOfType((PsiElement)place, Angular2EmbeddedExpression.class);
        if (statement != null) {
            String text;
            Matcher matcher;
            PsiElement candidate = PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)statement));
            if (!(candidate instanceof PsiComment) && statement.getLastChild() instanceof Angular2PipeArgumentsList) {
                candidate = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement.getLastChild());
            }
            if (candidate instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = ((PsiComment)candidate).getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                return candidate;
            }
        }
        return null;
    }

    private final boolean isSuppressedInStatement(PsiElement place, String toolId) {
        return ReadAction.compute(() -> Angular2InspectionSuppressor.isSuppressedInStatement$lambda$0(place, toolId)) != null;
    }

    private final String stripToolIdPrefix(String toolId) {
        for (String prefix : PREFIXES_TO_STRIP) {
            if (!StringsKt.startsWith$default((String)toolId, (String)prefix, (boolean)false, (int)2, null)) continue;
            String string = toolId.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return toolId;
    }

    private static final PsiElement isSuppressedInStatement$lambda$0(PsiElement $place, String $toolId) {
        Intrinsics.checkNotNullParameter((Object)$place, (String)"$place");
        Intrinsics.checkNotNullParameter((Object)$toolId, (String)"$toolId");
        return INSTANCE.getStatementToolSuppressedIn($place, $toolId);
    }

    static {
        String[] stringArray = new String[]{"TypeScript", "JS", "Angular"};
        PREFIXES_TO_STRIP = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/angular2/inspections/Angular2InspectionSuppressor$Angular2SuppressByCommentFix;", "Lcom/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix;", "key", "", "(Ljava/lang/String;)V", "suppressText", "getSuppressText", "()Ljava/lang/String;", "createSuppression", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "container", "getCommentsFor", "", "getContainer", "context", "getText", "intellij.angular"})
    private static final class Angular2SuppressByCommentFix
    extends AbstractBatchSuppressByNoInspectionCommentFix {
        public Angular2SuppressByCommentFix(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, false);
        }

        @NotNull
        public final String getSuppressText() {
            return "noinspection " + this.myID;
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            PsiParserFacade parserFacade = PsiParserFacade.getInstance((Project)project);
            PsiComment psiComment = parserFacade.createLineOrBlockCommentFromText((Language)Angular2Language.INSTANCE, this.getSuppressText());
            Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"createLineOrBlockCommentFromText(...)");
            PsiComment comment = psiComment;
            container.getParent().addAfter((PsiElement)comment, container);
        }

        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return PsiTreeUtil.getParentOfType((PsiElement)context, Angular2EmbeddedExpression.class);
        }

        @NotNull
        public String getText() {
            return Angular2Bundle.Companion.message("angular.suppress.for-expression", new Object[0]);
        }

        @Nullable
        protected List<PsiElement> getCommentsFor(@NotNull PsiElement container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)container);
            if (psiElement == null) {
                return null;
            }
            PsiElement next = psiElement;
            return CollectionsKt.listOf((Object)next);
        }
    }
}

