/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.source.Angular2SourceEntityListProcessor;
import org.angular2.inspections.Angular2SourceEntityListValidator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0002\u001f B5\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0011H\u0002J;\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00012\b\b\u0001\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0004\u00a2\u0006\u0002\u0010\u001cJ3\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00012\b\b\u0001\u0010\u0016\u001a\u00020\r2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0004\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator;", "T", "Lorg/angular2/entities/Angular2Entity;", "E", "", "Lorg/angular2/entities/source/Angular2SourceEntityListProcessor;", "decorator", "Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;", "results", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "entityClass", "Ljava/lang/Class;", "propertyName", "", "(Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;Ljava/lang/Class;Ljava/lang/String;)V", "myIterator", "Lcom/intellij/util/containers/TreeTraversal$TracingIt;", "Lcom/intellij/psi/PsiElement;", "locateProblemElement", "registerProblem", "", "problemType", "message", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Ljava/lang/Enum;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "(Ljava/lang/Enum;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "validate", "ValidationProblem", "ValidationResults", "intellij.angular"})
public abstract class Angular2SourceEntityListValidator<T extends Angular2Entity, E extends Enum<?>>
extends Angular2SourceEntityListProcessor<T> {
    @NotNull
    private final ES6Decorator decorator;
    @NotNull
    private final ValidationResults<? super E> results;
    @NotNull
    private final String propertyName;
    private TreeTraversal.TracingIt<PsiElement> myIterator;

    protected Angular2SourceEntityListValidator(@NotNull ES6Decorator decorator, @NotNull ValidationResults<? super E> results, @NotNull Class<T> entityClass, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        super(entityClass);
        this.decorator = decorator;
        this.results = results;
        this.propertyName = propertyName;
    }

    public final void validate() {
        JSProperty jSProperty = Angular2DecoratorUtil.getProperty(this.decorator, this.propertyName);
        if (jSProperty == null) {
            return;
        }
        JSProperty property = jSProperty;
        AstLoadingFilter.forceAllowTreeLoading((PsiFile)property.getContainingFile(), () -> Angular2SourceEntityListValidator.validate$lambda$1(property, this));
    }

    private final PsiElement locateProblemElement() {
        PsiFile psiFile = this.decorator.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        TreeTraversal.TracingIt<PsiElement> tracingIt = this.myIterator;
        if (tracingIt == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
            tracingIt = null;
        }
        Iterable iterable = CollectionsKt.listOf((Object)tracingIt.current());
        TreeTraversal.TracingIt<PsiElement> tracingIt2 = this.myIterator;
        if (tracingIt2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
            tracingIt2 = null;
        }
        for (PsiElement el : ContainerUtil.concat((Iterable)iterable, (Iterable)((Iterable)tracingIt2.backtrace()))) {
            if (!Intrinsics.areEqual((Object)file, (Object)el.getContainingFile().getOriginalFile()) || !this.decorator.getTextRange().contains(el.getTextRange())) continue;
            Intrinsics.checkNotNull((Object)el);
            return el;
        }
        return (PsiElement)this.decorator;
    }

    protected final void registerProblem(@NotNull E problemType, @Nls @NotNull String message, LocalQuickFix ... quickFixes2) {
        Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)quickFixes2, (String)"quickFixes");
        this.results.registerProblem$intellij_angular(this.locateProblemElement(), problemType, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(quickFixes2, quickFixes2.length));
    }

    protected final void registerProblem(@NotNull E problemType, @Nls @NotNull String message, @NotNull ProblemHighlightType severity, LocalQuickFix ... quickFixes2) {
        Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)quickFixes2, (String)"quickFixes");
        this.results.registerProblem$intellij_angular(this.locateProblemElement(), problemType, message, severity, Arrays.copyOf(quickFixes2, quickFixes2.length));
    }

    private static final Iterable validate$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final void validate$lambda$1(JSProperty $property, Angular2SourceEntityListValidator this$0) {
        Intrinsics.checkNotNullParameter((Object)$property, (String)"$property");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JSExpression value = $property.getValue();
        if (value == null) {
            return;
        }
        HashSet<PsiElement> visited = new HashSet<PsiElement>();
        Iterator iterator = TreeTraversal.LEAVES_DFS.traversal((Iterable)CollectionsKt.listOf((Object)value), arg_0 -> Angular2SourceEntityListValidator.validate$lambda$1$lambda$0((Function1)new Function1<PsiElement, Iterable<? extends PsiElement>>(visited, this$0){
            final /* synthetic */ HashSet<PsiElement> $visited;
            final /* synthetic */ Angular2SourceEntityListValidator<T, E> this$0;
            {
                this.$visited = $visited;
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<PsiElement> invoke(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$visited.add(element) ? Angular2SourceEntityListValidator.access$resolve(this.this$0, element) : CollectionsKt.emptyList();
            }
        }, arg_0)).typedIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"typedIterator(...)");
        this$0.myIterator = (TreeTraversal.TracingIt)iterator;
        while (true) {
            TreeTraversal.TracingIt<PsiElement> tracingIt;
            if ((tracingIt = this$0.myIterator) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
                tracingIt = null;
            }
            if (!tracingIt.advance()) break;
            ProgressManager.checkCanceled();
            TreeTraversal.TracingIt<PsiElement> tracingIt2 = this$0.myIterator;
            if (tracingIt2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
                tracingIt2 = null;
            }
            ((PsiElement)tracingIt2.current()).accept((PsiElementVisitor)this$0.getResultsVisitor());
        }
    }

    public static final /* synthetic */ List access$resolve(Angular2SourceEntityListValidator $this, PsiElement t) {
        return $this.resolve(t);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationProblem;", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "getFixes", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "location", "Lcom/intellij/psi/PsiElement;", "getLocation", "()Lcom/intellij/psi/PsiElement;", "message", "", "Lorg/jetbrains/annotations/Nls;", "getMessage", "()Ljava/lang/String;", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getSeverity", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "intellij.angular"})
    public static interface ValidationProblem {
        @NotNull
        public PsiElement getLocation();

        @NotNull
        public String getMessage();

        @NotNull
        public ProblemHighlightType getSeverity();

        @NotNull
        public LocalQuickFix[] getFixes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b*\f\b\u0002\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0004JE\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00022\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00028\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "T", "", "", "()V", "results", "Lcom/intellij/util/containers/MultiMap;", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationProblem;", "registerProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "type", "message", "", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "registerProblem$intellij_angular", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Enum;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "registerProblems", "problemType", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Ljava/lang/Enum;Lcom/intellij/codeInspection/ProblemsHolder;)V", "Companion", "intellij.angular"})
    public static class ValidationResults<T extends Enum<?>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultiMap<T, ValidationProblem> results = new MultiMap();
        @NotNull
        private static final Companion.EMPTY.1 EMPTY = new ValidationResults<Enum<?>>(){

            public void registerProblems(@NotNull Enum<?> problemType, @NotNull ProblemsHolder holder) {
                Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }
        };

        public void registerProblems(@NotNull T problemType, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            for (ValidationProblem problem : this.results.get(problemType)) {
                LocalQuickFix[] localQuickFixArray = problem.getFixes();
                holder.registerProblem(problem.getLocation(), problem.getMessage(), problem.getSeverity(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }

        public final void registerProblem$intellij_angular(@NotNull PsiElement element, @NotNull T type, @Nls @NotNull String message, @NotNull ProblemHighlightType severity, LocalQuickFix ... quickFixes2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)quickFixes2, (String)"quickFixes");
            this.results.putValue(type, (Object)new ValidationProblem(message, element, severity, quickFixes2){
                final /* synthetic */ String $message;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ ProblemHighlightType $severity;
                final /* synthetic */ LocalQuickFix[] $quickFixes;
                {
                    this.$message = $message;
                    this.$element = $element;
                    this.$severity = $severity;
                    this.$quickFixes = $quickFixes;
                }

                @NotNull
                public String getMessage() {
                    return this.$message;
                }

                @NotNull
                public PsiElement getLocation() {
                    return this.$element;
                }

                @NotNull
                public ProblemHighlightType getSeverity() {
                    return this.$severity;
                }

                @NotNull
                public LocalQuickFix[] getFixes() {
                    return this.$quickFixes;
                }
            });
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\f\b\u0003\u0010\b*\u0006\u0012\u0002\b\u00030\tR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion;", "", "()V", "EMPTY", "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion$EMPTY$1", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion$EMPTY$1;", "empty", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "T", "", "intellij.angular"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T extends Enum<?>> ValidationResults<T> empty() {
                EMPTY.1 v0 = EMPTY;
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.angular2.inspections.Angular2SourceEntityListValidator.ValidationResults<T of org.angular2.inspections.Angular2SourceEntityListValidator.ValidationResults.Companion.empty>");
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

