/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.codeInsight.Angular2HighlightingUtils;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.inspections.AngularHtmlLikeTemplateLocalInspectionTool;
import org.angular2.inspections.AngularInvalidI18nAttributeInspection;
import org.angular2.inspections.quickfixes.CreateAttributeQuickFix;
import org.angular2.inspections.quickfixes.RenameAttributeQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.web.scopes.I18NAttributesScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/angular2/inspections/AngularInvalidI18nAttributeInspection;", "Lorg/angular2/inspections/AngularHtmlLikeTemplateLocalInspectionTool;", "()V", "visitAngularAttribute", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "descriptor", "Lorg/angular2/codeInsight/attributes/Angular2AttributeDescriptor;", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngularInvalidI18nAttributeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularInvalidI18nAttributeInspection.kt\norg/angular2/inspections/AngularInvalidI18nAttributeInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n1549#2:76\n1620#2,3:77\n37#3,2:74\n37#3,2:80\n*S KotlinDebug\n*F\n+ 1 AngularInvalidI18nAttributeInspection.kt\norg/angular2/inspections/AngularInvalidI18nAttributeInspection\n*L\n42#1:70\n42#1:71,3\n57#1:76\n57#1:77,3\n43#1:74,2\n59#1:80,2\n*E\n"})
public final class AngularInvalidI18nAttributeInspection
extends AngularHtmlLikeTemplateLocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitAngularAttribute(@NotNull ProblemsHolder holder, @NotNull XmlAttribute attribute, @NotNull Angular2AttributeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)((Object)descriptor), (String)"descriptor");
        Angular2AttributeNameParser.AttributeInfo info2 = descriptor.getInfo();
        XmlTag parent = attribute.getParent();
        if (info2.getType() == Angular2AttributeType.I18N && parent != null) {
            TextRange textRange = attribute.getNameElement().getTextRangeInParent();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
            TextRange range = textRange;
            String i18nedAttrName = info2.getName();
            TreeSet<String> candidates = new TreeSet<String>();
            XmlAttribute[] xmlAttributeArray = parent.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
            for (XmlAttribute attr2 : xmlAttributeArray) {
                String string = attr2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Angular2AttributeNameParser.AttributeInfo attrInfo = Angular2AttributeNameParser.INSTANCE.parse(string, parent);
                if (!I18NAttributesScope.Companion.isI18nCandidate(attrInfo)) continue;
                String string2 = attr2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                candidates.add(Angular2AttributeType.I18N.buildName(string2));
            }
            XmlAttribute[] xmlAttributeArray2 = parent.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray2, (String)"getAttributes(...)");
            for (XmlAttribute attr2 : xmlAttributeArray2) {
                candidates.remove(attr2.getName());
            }
            if (((CharSequence)i18nedAttrName).length() == 0) {
                Object[] $this$toTypedArray$iv;
                Collection $this$map$iv;
                XmlAttribute attr2;
                Iterable iterable = CollectionsKt.take((Iterable)candidates, (int)3);
                $i$f$map = false;
                attr2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new RenameAttributeQuickFix((String)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                quickFixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
                $this$toTypedArray$iv = new Object[]{Angular2HighlightingUtils.INSTANCE.withColor("i18n-", Angular2HighlightingUtils.TextAttributesKind.HTML_ATTRIBUTE, (PsiElement)attribute)};
                holder.registerProblem((PsiElement)attribute, range, Angular2Bundle.Companion.htmlMessage("angular.inspection.i18n.message.empty", $this$toTypedArray$iv), Arrays.copyOf(quickFixes, quickFixes.length));
            } else if (descriptor.hasErrorSymbols()) {
                Collection $this$map$iv;
                Iterable $this$toTypedArray$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)candidates, (arg_0, arg_1) -> AngularInvalidI18nAttributeInspection.visitAngularAttribute$lambda$1(visitAngularAttribute.quickFixes.2.INSTANCE, arg_0, arg_1)), (int)2);
                $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void name;
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new RenameAttributeQuickFix((String)name));
                }
                $this$map$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new CreateAttributeQuickFix(i18nedAttrName));
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                quickFixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
                Object[] objectArray = new Object[]{Angular2HighlightingUtils.INSTANCE.withColor(i18nedAttrName, Angular2HighlightingUtils.TextAttributesKind.HTML_ATTRIBUTE, (PsiElement)attribute)};
                holder.registerProblem((PsiElement)attribute, new TextRange(range.getStartOffset() + 5, range.getEndOffset()), Angular2Bundle.Companion.htmlMessage("angular.inspection.i18n.message.not-matching", objectArray), Arrays.copyOf(quickFixes, quickFixes.length));
            }
        }
    }

    private static final int visitAngularAttribute$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

