/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.javascript.web.js.WebJSResolveUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.source.Angular2SourceDirectiveProperty;
import org.angular2.inspections.quickfixes.Angular2FixesPsiUtil;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0096\u0002J2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "kind", "Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;", "inputName", "", "expressionType", "clazz", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptClass;", "(Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptClass;)V", "getFamilyName", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "TransformKind", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAddInputTransformFunctionQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddInputTransformFunctionQuickFix.kt\norg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,103:1\n1#2:104\n14#3:105\n*S KotlinDebug\n*F\n+ 1 AddInputTransformFunctionQuickFix.kt\norg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix\n*L\n67#1:105\n*E\n"})
public final class AddInputTransformFunctionQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    @NotNull
    private final TransformKind kind;
    @NotNull
    private final String inputName;
    @NotNull
    private final String expressionType;

    public AddInputTransformFunctionQuickFix(@NotNull TransformKind kind, @NotNull String inputName, @NotNull String expressionType, @NotNull TypeScriptClass clazz) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        super((PsiElement)clazz);
        this.kind = kind;
        this.inputName = inputName;
        this.expressionType = expressionType;
    }

    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.template.create-input-transformer.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        String string;
        if (this.kind == TransformKind.Custom) {
            string = this.getFamilyName();
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.decapitalize((String)this.kind.name()), (String)"decapitalize(...)");
            string = Angular2Bundle.Companion.message("angular.quickfix.template.create-input-transformer.std.name", objectArray);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return !JSProjectUtil.isInLibrary((PsiElement)startElement);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement psiElement;
        Angular2SourceDirectiveProperty angular2SourceDirectiveProperty;
        Angular2DirectiveProperty property;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Angular2Directive angular2Directive = Angular2EntitiesProvider.getDirective((PsiElement)(startElement instanceof TypeScriptClass ? (TypeScriptClass)startElement : null));
        if (angular2Directive == null) return;
        Collection<Angular2DirectiveProperty> collection = angular2Directive.getInputs();
        if (collection == null) return;
        Iterator iterator = ((Iterable)collection).iterator();
        do {
            Angular2SourceDirectiveProperty angular2SourceDirectiveProperty2;
            if (!iterator.hasNext()) return;
            property = (Angular2DirectiveProperty)iterator.next();
            boolean bl = false;
            Angular2SourceDirectiveProperty angular2SourceDirectiveProperty3 = angular2SourceDirectiveProperty2 = property instanceof Angular2SourceDirectiveProperty ? (Angular2SourceDirectiveProperty)property : null;
            if (angular2SourceDirectiveProperty2 != null) {
                Angular2SourceDirectiveProperty angular2SourceDirectiveProperty4;
                Angular2SourceDirectiveProperty it = angular2SourceDirectiveProperty4 = angular2SourceDirectiveProperty2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)this.inputName) && !it.getVirtualProperty() && it.getTransformParameterType() == null) {
                    angular2SourceDirectiveProperty = angular2SourceDirectiveProperty4;
                    continue;
                }
                angular2SourceDirectiveProperty = null;
                continue;
            }
            angular2SourceDirectiveProperty = null;
        } while ((property = angular2SourceDirectiveProperty) == null);
        Angular2DirectiveProperty angular2DirectiveProperty = property;
        Angular2SourceDirectiveProperty angular2SourceDirectiveProperty5 = angular2DirectiveProperty;
        if (angular2SourceDirectiveProperty5 == null) return;
        Angular2SourceDirectiveProperty input = angular2SourceDirectiveProperty5;
        PsiElement psiElement2 = input.getDeclarationSource();
        if (psiElement2 != null) {
            PsiFile psiFile = startElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            psiElement = Angular2FixesPsiUtil.INSTANCE.remapToCopyIfNeeded(psiElement2, psiFile);
        } else {
            psiElement = null;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression = Angular2FixesPsiUtil.INSTANCE.getOrCreateInputObjectLiteral(psiElement);
        if (jSObjectLiteralExpression == null) {
            return;
        }
        JSObjectLiteralExpression objectLiteral = jSObjectLiteralExpression;
        if (this.kind == TransformKind.Custom) {
            void $this$asSafely$iv;
            OpenFileDescriptor openFileDescriptor;
            JSProperty property2 = Angular2FixesPsiUtil.insertJSObjectLiteralProperty$default(Angular2FixesPsiUtil.INSTANCE, objectLiteral, "transform", "(value: " + this.expressionType + "): " + input.getRawJsType() + " => ", false, false, 8, null);
            if (IntentionPreviewUtils.isIntentionPreviewActive()) {
                return;
            }
            OpenFileDescriptor it = openFileDescriptor = new OpenFileDescriptor(project, property2.getContainingFile().getVirtualFile(), property2.getTextRange().getEndOffset());
            boolean $i$a$-takeIf-AddInputTransformFunctionQuickFix$invoke$22 = false;
            Object object = angular2SourceDirectiveProperty5 = it.canNavigateToSource() ? openFileDescriptor : null;
            if (angular2SourceDirectiveProperty5 != null) {
                angular2SourceDirectiveProperty5.navigate(true);
            }
            if ((openFileDescriptor = FileEditorManager.getInstance((Project)project).getSelectedEditor(property2.getContainingFile().getVirtualFile())) == null) return;
            OpenFileDescriptor $i$a$-takeIf-AddInputTransformFunctionQuickFix$invoke$22 = openFileDescriptor;
            boolean $i$f$asSafely = false;
            Object v8 = $this$asSafely$iv;
            if (!(v8 instanceof TextEditor)) {
                v8 = null;
            }
            if ((it = (TextEditor)v8) == null) return;
            Editor editor2 = it.getEditor();
            Editor componentEditor = editor2;
            if (componentEditor == null) return;
            JSExpression jSExpression = property2.getValue();
            if (jSExpression != null) {
                jSExpression.delete();
            }
            Template template = TemplateManager.getInstance((Project)project).createTemplate("ng_insert_input_transform", "angular", "(value: $TYPE0$): $TYPE1$ => $END$");
            template.addVariable("TYPE0", (Expression)new TextExpression(this.expressionType), (Expression)new TextExpression(this.expressionType), true, true);
            JSType jSType = input.getRawJsType();
            String inputType = jSType != null && (jSType = jSType.substitute()) != null ? jSType.getTypeText(JSType.TypeTextFormat.CODE) : null;
            template.addVariable("TYPE1", (Expression)new TextExpression(inputType), (Expression)new TextExpression(inputType), true, true);
            template.addVariable("END", (Expression)new EmptyExpression(), true);
            template.setToReformat(true);
            TemplateManager.getInstance((Project)project).startTemplate(componentEditor, template);
            return;
        } else {
            String string = StringUtil.decapitalize((String)this.kind.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalize(...)");
            String functionName = string;
            PsiElement function = WebJSResolveUtil.INSTANCE.resolveSymbolFromNodeModule(startElement, "@angular/core", functionName, PsiElement.class);
            if (function == null) return;
            Angular2FixesPsiUtil.insertJSObjectLiteralProperty$default(Angular2FixesPsiUtil.INSTANCE, objectLiteral, "transform", functionName, false, false, 8, null);
            ES6ImportPsiUtil.insertJSImport((PsiElement)startElement, (String)functionName, (PsiElement)function, (Editor)editor);
        }
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.kind == TransformKind.Custom ? PriorityAction.Priority.NORMAL : PriorityAction.Priority.HIGH;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;", "", "(Ljava/lang/String;I)V", "BooleanAttribute", "NumberAttribute", "Custom", "intellij.angular"})
    public static final class TransformKind
    extends Enum<TransformKind> {
        public static final /* enum */ TransformKind BooleanAttribute = new TransformKind();
        public static final /* enum */ TransformKind NumberAttribute = new TransformKind();
        public static final /* enum */ TransformKind Custom = new TransformKind();
        private static final /* synthetic */ TransformKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TransformKind[] values() {
            return (TransformKind[])$VALUES.clone();
        }

        public static TransformKind valueOf(String value) {
            return Enum.valueOf(TransformKind.class, value);
        }

        @NotNull
        public static EnumEntries<TransformKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = transformKindArray = new TransformKind[]{TransformKind.BooleanAttribute, TransformKind.NumberAttribute, TransformKind.Custom};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

