/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.Angular2ImportsOwner;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.source.Angular2SourceDeclaration;
import org.angular2.inspections.actions.AddNgModuleDeclarationAction;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J3\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/angular2/inspections/quickfixes/AddNgModuleDeclarationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/source/Angular2SourceDeclaration;", "(Lcom/intellij/psi/PsiElement;Lorg/angular2/entities/source/Angular2SourceDeclaration;)V", "myDeclarationDecorator", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;", "myDeclarationName", "", "myModuleName", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "startElement", "endElement", "Companion", "intellij.angular"})
public final class AddNgModuleDeclarationQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myDeclarationName;
    @NotNull
    private final SmartPsiElementPointer<ES6Decorator> myDeclarationDecorator;
    @Nullable
    private final String myModuleName;

    private AddNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration) {
        super(context);
        String string = declaration.getTypeScriptClass().getName();
        Intrinsics.checkNotNull((Object)string);
        this.myDeclarationName = string;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)declaration.getDecorator()));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.myDeclarationDecorator = smartPsiElementPointer;
        List<Angular2Module> candidates = Companion.getCandidateModules(context);
        this.myModuleName = candidates.size() == 1 ? candidates.get(0).getName() : null;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.myModuleName == null) {
            Object[] objectArray = new Object[]{this.myDeclarationName};
            string = Angular2Bundle.Companion.message("angular.quickfix.ngmodule.declare.name.choice", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.myDeclarationName, this.myModuleName};
            string = Angular2Bundle.Companion.message("angular.quickfix.ngmodule.declare.name", objectArray);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.ngmodule.declare.family", new Object[0]);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.HIGH;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (this.myDeclarationDecorator.getElement() == null) {
            return;
        }
        AddNgModuleDeclarationAction action2 = Angular2ActionFactory.INSTANCE.createAddNgModuleDeclarationAction(editor, startElement, this.myDeclarationDecorator, this.myDeclarationName, this.getText(), false);
        List<JSImportCandidate> candidates = action2.getRawCandidates();
        if (candidates.size() == 1 || editor != null) {
            action2.execute();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public /* synthetic */ AddNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration, DefaultConstructorMarker $constructor_marker) {
        this(context, declaration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/angular2/inspections/quickfixes/AddNgModuleDeclarationQuickFix$Companion;", "", "()V", "add", "", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/Angular2Declaration;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "getCandidateModules", "", "Lorg/angular2/entities/Angular2Module;", "intellij.angular"})
    public static final class Companion {
        private Companion() {
        }

        public final void add(@NotNull PsiElement context, @NotNull Angular2Declaration declaration, @NotNull List<LocalQuickFix> fixes) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            if (declaration instanceof Angular2SourceDeclaration && ((Angular2SourceDeclaration)declaration).getTypeScriptClass().getName() != null) {
                fixes.add((LocalQuickFix)new AddNgModuleDeclarationQuickFix(context, (Angular2SourceDeclaration)declaration, null));
            }
        }

        @NotNull
        public final List<Angular2Module> getCandidateModules(@NotNull PsiElement context) {
            Angular2Module contextModule;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ArrayDeque<Angular2Module> processingQueue = new ArrayDeque<Angular2Module>(20);
            Angular2DeclarationsScope scope = new Angular2DeclarationsScope(context);
            Angular2ImportsOwner angular2ImportsOwner = scope.getImportsOwner();
            Angular2Module angular2Module = contextModule = angular2ImportsOwner instanceof Angular2Module ? (Angular2Module)angular2ImportsOwner : null;
            if (contextModule == null || !scope.isInSource(contextModule)) {
                return CollectionsKt.emptyList();
            }
            processingQueue.addLast(contextModule);
            HashSet<Angular2Module> processed = new HashSet<Angular2Module>();
            ArrayList<Angular2Module> result2 = new ArrayList<Angular2Module>();
            while (!processingQueue.isEmpty()) {
                Angular2Module module = (Angular2Module)processingQueue.removeFirst();
                if (!processed.add(module)) continue;
                Intrinsics.checkNotNull((Object)module);
                if (!scope.isInSource(module)) continue;
                result2.add(module);
                Angular2EntityUtils.forEachModule((Iterable<? extends Angular2Entity>)module.getImports(), (Function1<? super Angular2Module, Unit>)((Function1)new Function1<Angular2Module, Unit>(processingQueue){
                    final /* synthetic */ ArrayDeque<Angular2Module> $processingQueue;
                    {
                        this.$processingQueue = $processingQueue;
                        super(1);
                    }

                    public final void invoke(@NotNull Angular2Module it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$processingQueue.addLast(it);
                    }
                }));
                Angular2EntityUtils.forEachModule((Iterable<? extends Angular2Entity>)module.getExports(), (Function1<? super Angular2Module, Unit>)((Function1)new Function1<Angular2Module, Unit>(processingQueue){
                    final /* synthetic */ ArrayDeque<Angular2Module> $processingQueue;
                    {
                        this.$processingQueue = $processingQueue;
                        super(1);
                    }

                    public final void invoke(@NotNull Angular2Module it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$processingQueue.addLast(it);
                    }
                }));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

