/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.llmInstaller.AIAssistantContentExtension;
import com.intellij.llmInstaller.Agreement;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.UtilsKt;
import com.intellij.llmInstaller.ui.wizard.LLMInstallerPluginDisabledPanel;
import com.intellij.llmInstaller.ui.wizard.LLMInstallerWizardPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.migrations.AIAssistant241Kt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/llmInstaller/AIAssistantToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "firstRun", "", "lastToolWindowState", "Lcom/intellij/llmInstaller/AIAssistantToolWindowFactory$LastToolWindowState;", "calculateAndUpdateLastToolWindowState", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getAIAssistantContentExtension", "Lcom/intellij/llmInstaller/AIAssistantContentExtension;", "getLastToolWindowState", "init", "initContent", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "setLastToolWindowState", "state", "shouldBeAvailable", "Companion", "LastToolWindowState", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nAIAssistantToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantToolWindowFactory.kt\ncom/intellij/llmInstaller/AIAssistantToolWindowFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,177:1\n1#2:178\n9#3:179\n*S KotlinDebug\n*F\n+ 1 AIAssistantToolWindowFactory.kt\ncom/intellij/llmInstaller/AIAssistantToolWindowFactory\n*L\n151#1:179\n*E\n"})
public final class AIAssistantToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean firstRun = PropertiesComponent.getInstance().getValue("llm.installer.last.toolwindow.state") == null;
    @NotNull
    private final LastToolWindowState lastToolWindowState = this.calculateAndUpdateLastToolWindowState();
    @NotNull
    public static final String ID = "AIAssistant";
    @NotNull
    private static final String LLM_INSTALLER_LAST_TOOLWINDOW_STATE = "llm.installer.last.toolwindow.state";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.initContent(project, (ToolWindowEx)toolWindow);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.lastToolWindowState != LastToolWindowState.LLM_INSTALLER_HIDDEN;
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.init(toolWindow);
        toolWindow.setStripeShortTitleProvider(LLMInstallerBundle.INSTANCE.messagePointer("toolwindow.stripe.AIAssistant.shortName", new Object[0]));
        AIAssistantContentExtension.Companion.getEP_NAME().addChangeListener(() -> AIAssistantToolWindowFactory.init$lambda$0(this, toolWindow), toolWindow.getDisposable());
        MessageBus messageBus = toolWindow.getProject().getMessageBus();
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ AIAssistantToolWindowFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                LastToolWindowState state;
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                super.toolWindowShown(toolWindow);
                if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"AIAssistant") && (state = AIAssistantToolWindowFactory.access$getLastToolWindowState(this.this$0)) == LastToolWindowState.LLM_INSTALLER_HIDDEN) {
                    AIAssistantToolWindowFactory.access$setLastToolWindowState(this.this$0, LastToolWindowState.LLM_INSTALLER);
                }
            }
        });
        boolean aiAssistantExists = this.getAIAssistantContentExtension() != null;
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        ToolWindowManagerImpl toolWindowManager2 = (ToolWindowManagerImpl)toolWindowManager;
        if (!this.firstRun || aiAssistantExists || UtilsKt.isLLMPluginDisabled() || Agreement.INSTANCE.isAiPrivacyPolicyAccepted() || !Registry.is((String)"llm.ai.assistant.toolwindow.activation.on.start")) {
            return;
        }
        toolWindowManager2.invokeLater(() -> AIAssistantToolWindowFactory.init$lambda$1(toolWindow));
    }

    private final void initContent(Project project, ToolWindowEx toolWindow) {
        Content content2;
        AIAssistantContentExtension extension = this.getAIAssistantContentExtension();
        JComponent component = UtilsKt.isLLMPluginDisabled() ? (JComponent)new LLMInstallerPluginDisabledPanel(project) : (extension == null ? (JComponent)new LLMInstallerWizardPanel(project) : extension.getContent(project, toolWindow));
        Content $this$initContent_u24lambda_u242 = content2 = ContentFactory.getInstance().createContent(component, null, false);
        boolean bl = false;
        $this$initContent_u24lambda_u242.setCloseable(false);
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"apply(...)");
        Content content4 = content3;
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeAllContents(true);
        contentManager2.addContent(content4);
        toolWindow.setStripeTitle(extension == null ? LLMInstallerBundle.INSTANCE.message("toolwindow.install.title", new Object[0]) : LLMInstallerBundle.INSTANCE.message("toolwindow.stripe.AIAssistant", new Object[0]));
    }

    private final AIAssistantContentExtension getAIAssistantContentExtension() {
        return (AIAssistantContentExtension)CollectionsKt.firstOrNull((List)AIAssistantContentExtension.Companion.getEP_NAME().getExtensionList());
    }

    private final LastToolWindowState calculateAndUpdateLastToolWindowState() {
        LastToolWindowState result;
        LastToolWindowState storedState = this.getLastToolWindowState();
        if (this.getAIAssistantContentExtension() != null) {
            v0 = LastToolWindowState.AI_ASSISTANT;
        } else if (storedState == LastToolWindowState.AI_ASSISTANT) {
            v0 = UtilsKt.isLLMPluginDisabled() ? LastToolWindowState.LLM_INSTALLER : LastToolWindowState.LLM_INSTALLER_HIDDEN;
        } else {
            v0 = storedState;
            if (v0 == null) {
                v0 = result = AIAssistant241Kt.isAIDisabledBeforeMigrated() ? LastToolWindowState.LLM_INSTALLER_HIDDEN : LastToolWindowState.LLM_INSTALLER;
            }
        }
        if (result != storedState) {
            this.setLastToolWindowState(result);
        }
        return result;
    }

    private final LastToolWindowState getLastToolWindowState() {
        String string = PropertiesComponent.getInstance().getValue(LLM_INSTALLER_LAST_TOOLWINDOW_STATE);
        if (string == null) {
            return null;
        }
        String storedState = string;
        try {
            return LastToolWindowState.valueOf(storedState);
        }
        catch (Exception e) {
            AIAssistantToolWindowFactory $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AIAssistantToolWindowFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected llm.installer.last.toolwindow.state: " + storedState);
            return null;
        }
    }

    private final void setLastToolWindowState(LastToolWindowState state) {
        PropertiesComponent.getInstance().setValue(LLM_INSTALLER_LAST_TOOLWINDOW_STATE, state.name());
    }

    private static final void init$lambda$0(AIAssistantToolWindowFactory this$0, ToolWindow $toolWindow) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$toolWindow, (String)"$toolWindow");
        Project project = $toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.initContent(project, (ToolWindowEx)$toolWindow);
    }

    private static final void init$lambda$1(ToolWindow $toolWindow) {
        Intrinsics.checkNotNullParameter((Object)$toolWindow, (String)"$toolWindow");
        $toolWindow.activate(null);
    }

    public static final /* synthetic */ LastToolWindowState access$getLastToolWindowState(AIAssistantToolWindowFactory $this) {
        return $this.getLastToolWindowState();
    }

    public static final /* synthetic */ void access$setLastToolWindowState(AIAssistantToolWindowFactory $this, LastToolWindowState state) {
        $this.setLastToolWindowState(state);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/llmInstaller/AIAssistantToolWindowFactory$Companion;", "", "()V", "ID", "", "LLM_INSTALLER_LAST_TOOLWINDOW_STATE", "activateToolWindow", "", "project", "Lcom/intellij/openapi/project/Project;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "intellij.llmInstaller"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ToolWindow getToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ToolWindowManager.Companion.getInstance(project).getToolWindow(AIAssistantToolWindowFactory.ID);
        }

        @RequiresEdt
        public final void activateToolWindow(@Nullable Project project) {
            block1: {
                Project project2 = project;
                if (project2 == null) {
                    return;
                }
                ToolWindow toolWindow = this.getToolWindow(project2);
                if (toolWindow == null) break block1;
                toolWindow.activate(null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/llmInstaller/AIAssistantToolWindowFactory$LastToolWindowState;", "", "(Ljava/lang/String;I)V", "LLM_INSTALLER", "LLM_INSTALLER_HIDDEN", "AI_ASSISTANT", "intellij.llmInstaller"})
    private static final class LastToolWindowState
    extends Enum<LastToolWindowState> {
        public static final /* enum */ LastToolWindowState LLM_INSTALLER = new LastToolWindowState();
        public static final /* enum */ LastToolWindowState LLM_INSTALLER_HIDDEN = new LastToolWindowState();
        public static final /* enum */ LastToolWindowState AI_ASSISTANT = new LastToolWindowState();
        private static final /* synthetic */ LastToolWindowState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LastToolWindowState[] values() {
            return (LastToolWindowState[])$VALUES.clone();
        }

        public static LastToolWindowState valueOf(String value) {
            return Enum.valueOf(LastToolWindowState.class, value);
        }

        @NotNull
        public static EnumEntries<LastToolWindowState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lastToolWindowStateArray = new LastToolWindowState[]{LastToolWindowState.LLM_INSTALLER, LastToolWindowState.LLM_INSTALLER_HIDDEN, LastToolWindowState.AI_ASSISTANT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

