/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterExecutionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.stylelint.StylelintBundle;
import com.intellij.stylelint.StylelintFixResult;
import com.intellij.stylelint.StylelintPackage;
import com.intellij.stylelint.StylelintResultParser;
import com.intellij.stylelint.StylelintSessionData;
import com.intellij.stylelint.StylelintState;
import com.intellij.stylelint.StylelintUtil;
import com.intellij.stylelint.config.StylelintConfigFileChangeTracker;
import com.intellij.stylelint.config.StylelintUnsavedConfigFileManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.text.SemVer;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalRunner {
    private static final Logger LOG = Logger.getInstance(StylelintExternalRunner.class);
    private static final String FORMAT_PARAMETER = "-f";
    private static final String JSON_FORMAT = "json";
    private static final String SYNTAX = "--syntax";
    private static final String CONFIG = "--config";
    private static final String STDIN_FILENAME = "--stdin-filename";
    private static final String FIX = "--fix";
    @NlsSafe
    private static final String DEFAULT_ERROR_PREFIX = "Error: ";
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private final boolean myIsOnTheFly;
    private final boolean myRunStylelintFix;

    public StylelintExternalRunner(boolean isOnTheFly, boolean runStylelintFix) {
        this.myIsOnTheFly = isOnTheFly;
        this.myRunStylelintFix = runStylelintFix;
    }

    @Nullable
    public JSLinterAnnotationResult execute(@NotNull JSLinterInput<StylelintState> input) {
        boolean canRun;
        VirtualFile fileToLint;
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(0);
        }
        if (!(fileToLint = input.getVirtualFile()).isValid() || fileToLint.getParent() == null) {
            return null;
        }
        StylelintState state = (StylelintState)input.getState();
        Project project = input.getProject();
        if (project.isDisposed()) {
            return null;
        }
        VirtualFile workingDirectory = (VirtualFile)ReadAction.compute(() -> StylelintUtil.findWorkingDirectory(fileToLint));
        if (workingDirectory == null) {
            return null;
        }
        if (this.myIsOnTheFly) {
            ((StylelintConfigFileChangeTracker)((Object)project.getService(StylelintConfigFileChangeTracker.class))).startIfNeeded();
        }
        boolean bl = canRun = !this.myIsOnTheFly || (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            Collection<VirtualFile> configs = StylelintUtil.getPossibleConfigs(workingDirectory);
            return ((StylelintUnsavedConfigFileManager)((Object)((Object)project.getService(StylelintUnsavedConfigFileManager.class)))).requestSaveIfNeeded(configs);
        }) != false;
        if (!canRun) {
            LOG.debug("Stylelint postponed because of unsaved configs");
            return null;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage((Project)project, (NodeJsInterpreter)interpreter, (NodePackage)state.getStylelintPackage(), (String)"stylelint", (VirtualFile)fileToLint);
        if (error != null) {
            return JSLinterAnnotationResult.create(input, (JSLinterFileLevelAnnotation)error, null);
        }
        StylelintPackage stylelintPackage = StylelintPackage.fromNodePackage(project, state.getStylelintPackage());
        StylelintSessionData sessionData = new StylelintSessionData(interpreter, stylelintPackage, workingDirectory, state.getConfigFilePath(), fileToLint, input.getFileContent(), StylelintExternalRunner.suggestSyntax(input.getPsiFile()), this.myRunStylelintFix);
        return StylelintExternalRunner.stylelint(input, sessionData);
    }

    @Nullable
    private static String suggestSyntax(@NotNull PsiFile file) {
        if (file == null) {
            StylelintExternalRunner.$$$reportNull$$$0(1);
        }
        if (file instanceof StylesheetFile) {
            Language language = file.getLanguage();
            String languageId = language.getID();
            if ("LESS".equals(languageId)) {
                return "less";
            }
            if ("SCSS".equals(languageId)) {
                return "scss";
            }
        }
        return null;
    }

    private static JSLinterAnnotationResult stylelint(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(2);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(3);
        }
        long startNanoTime = System.nanoTime();
        JSLinterAnnotationResult result = StylelintExternalRunner.runProcess(input, sessionData);
        StylelintExternalRunner.logEnd(startNanoTime, result.getErrors().size());
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static JSLinterAnnotationResult runProcess(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(4);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(5);
        }
        if ((annotation = JSLinterExecutionSuppressor.annotationFromExecutionSuppressor((Project)input.getProject(), (String)((StylelintState)input.getState()).getStylelintPackage().getSystemDependentPath())) != null) {
            v0 = JSLinterAnnotationResult.create(input, (JSLinterFileLevelAnnotation)annotation, null);
            if (v0 == null) {
                StylelintExternalRunner.$$$reportNull$$$0(6);
            }
            return v0;
        }
        progressTitle = StylelintBundle.message("stylelint.starting.process.progress.title", new Object[0]);
        processWithCmdLine = (ProcessWithCmdLine)NodeProgressUtil.runExecutionUnderProgress((Project)input.getProject(), (String)progressTitle, (ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$runProcess$2(com.intellij.lang.javascript.linter.JSLinterInput com.intellij.stylelint.StylelintSessionData ), ()Lcom/intellij/javascript/nodejs/execution/ProcessWithCmdLine;)(input, (StylelintSessionData)sessionData));
        processHandler = processWithCmdLine.getProcessHandler();
        commandLine = processWithCmdLine.getCommandLine();
        StylelintExternalRunner.logStart(sessionData, processWithCmdLine.getCommandLinePresentation());
        if (StylelintExternalRunner.supportStdinClosing(sessionData.getInterpreter())) {
            try {
                StylelintExternalRunner.writeFileContentToStdin((ProcessHandler)processHandler, sessionData, commandLine.getCharset());
            }
            catch (IOException e) {
                StylelintExternalRunner.LOG.warn((Throwable)e);
                output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
                output.appendStderr("\n" + e.getMessage() + "\n");
                return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, processWithCmdLine, output);
            }
        }
        output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
        stylelintVersion = sessionData.getStylelintPackage().getVersion();
        v1 = reportToStderr = stylelintVersion != null && stylelintVersion.isGreaterOrEqualThan(16, 0, 0) != false;
        if (!reportToStderr && !StringUtil.isEmptyOrSpaces((String)(stderr = output.getStderr()))) {
            return StylelintExternalRunner.createFileLevelWarning(stderr, input, processWithCmdLine, output);
        }
        stylelintResultParser = new StylelintResultParser();
        if (sessionData.isRunStylelintFix()) {
            v2 = StylelintFixResult.create(output.getStdout());
        }
        ** GOTO lbl40
        {
            block19: {
                catch (ExecutionException e) {
                    return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
                }
                if (v2 == null) {
                    StylelintExternalRunner.$$$reportNull$$$0(7);
                }
                return v2;
lbl40:
                // 1 sources

                report = reportToStderr != false ? output.getStderr() : output.getStdout();
                try {
                    errors = stylelintResultParser.parse(report);
                    if (errors != null) ** GOTO lbl54
                    if (!StringUtil.isEmptyOrSpaces((String)report)) break block19;
                    v3 = JSLinterAnnotationResult.createLinterResult(input, Collections.emptyList(), null);
                }
                catch (Exception e) {}
                return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, processWithCmdLine, output);
                if (v3 == null) {
                    StylelintExternalRunner.$$$reportNull$$$0(8);
                }
                return v3;
            }
            return StylelintExternalRunner.createFileLevelWarning(report, input, processWithCmdLine, output);
lbl54:
            // 1 sources

            v4 = JSLinterAnnotationResult.createLinterResult(input, errors, null);
            if (v4 == null) {
                StylelintExternalRunner.$$$reportNull$$$0(9);
            }
            return v4;
        }
    }

    private static void writeFileContentToStdin(@NotNull ProcessHandler processHandler, @NotNull StylelintSessionData sessionData, @NotNull Charset charset) throws IOException {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(10);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(11);
        }
        if (charset == null) {
            StylelintExternalRunner.$$$reportNull$$$0(12);
        }
        String content = sessionData.getFileToLintContent();
        try (OutputStream stdin = Objects.requireNonNull(processHandler.getProcessInput());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file content to stdin\n\n" + content, e);
        }
    }

    @NotNull
    private static ProcessWithCmdLine startProcess(@NotNull Project project, @NotNull StylelintSessionData sessionData) throws ExecutionException {
        SemVer version;
        if (project == null) {
            StylelintExternalRunner.$$$reportNull$$$0(13);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(14);
        }
        NodeTargetRun targetRun = new NodeTargetRun(sessionData.getInterpreter(), project, null, NodeTargetRunOptions.of((Boolean)false));
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        File workDirectory = VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDir());
        commandLineBuilder.setWorkingDirectory(targetRun.requestUploadProjectRootAndGetPath(workDirectory.getAbsolutePath()));
        sessionData.getStylelintPackage().addMainEntryJsFile(targetRun);
        if (sessionData.isRunStylelintFix()) {
            commandLineBuilder.addParameter(FIX);
        } else {
            commandLineBuilder.addParameters(new String[]{FORMAT_PARAMETER, JSON_FORMAT});
        }
        String configFilePath = FileUtil.toSystemDependentName((String)sessionData.getConfigFilePath());
        if (!configFilePath.isEmpty()) {
            commandLineBuilder.addParameter(CONFIG);
            commandLineBuilder.addParameter(targetRun.path(configFilePath));
        }
        if ((version = sessionData.getStylelintPackage().getPackage().getVersion(project)) != null && !version.isGreaterOrEqualThan(14, 0, 0) && sessionData.getSyntax() != null) {
            commandLineBuilder.addParameters(new String[]{SYNTAX, sessionData.getSyntax()});
        }
        String pathToLint = FileUtil.toSystemDependentName((String)sessionData.getFileToLint().getPath());
        if (StylelintExternalRunner.supportStdinClosing(targetRun.getInterpreter())) {
            String relativePath = FileUtil.getRelativePath((String)workDirectory.getAbsolutePath(), (String)pathToLint, (char)File.separatorChar);
            if (relativePath != null) {
                commandLineBuilder.addParameters(new String[]{STDIN_FILENAME, relativePath});
            }
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            commandLineBuilder.addParameter(targetRun.path(pathToLint));
        }
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        if (processWithCmdLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(15);
        }
        return processWithCmdLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(16);
        }
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        ProcessOutput processOutput = progress != null ? runner.runProcess(progress, 10000) : runner.runProcess(10000);
        if (processOutput == null) {
            StylelintExternalRunner.$$$reportNull$$$0(17);
        }
        return processOutput;
    }

    private static boolean supportStdinClosing(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            StylelintExternalRunner.$$$reportNull$$$0(18);
        }
        return !NodeJsRemoteInterpreter.isDocker((NodeJsInterpreter)interpreter);
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull @InspectionMessage String message, @NotNull JSLinterInput<StylelintState> input) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(19);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(20);
        }
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, (JSLinterFileLevelAnnotation)new JSLinterFileLevelAnnotation(message), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(21);
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input, @NotNull ProcessWithCmdLine processWithCmdLine, @NotNull ProcessOutput output) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(22);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(23);
        }
        if (processWithCmdLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(24);
        }
        if (output == null) {
            StylelintExternalRunner.$$$reportNull$$$0(25);
        }
        JsqtViewProcessOutputAction detailsAction = new JsqtViewProcessOutputAction(JavaScriptBundle.message((String)"javascript.linter.error.failed.to.lint", (Object[])new Object[]{input.getVirtualFile().getPath()}), JavaScriptLanguageIcons.FileTypes.Stylelint, processWithCmdLine.buildGeneralCommandLine(), (ProcessHandler)processWithCmdLine.getProcessHandler(), output);
        String errorMessage = StringUtil.splitByLines((String)message)[0];
        errorMessage = StringUtil.trimStart((String)errorMessage, (String)DEFAULT_ERROR_PREFIX);
        errorMessage = StringUtil.decapitalize((String)errorMessage);
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, (JSLinterFileLevelAnnotation)new JSLinterFileLevelAnnotation(errorMessage, (IntentionAction)detailsAction).withIcon(JavaScriptLanguageIcons.FileTypes.Stylelint), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(26);
        }
        return jSLinterAnnotationResult;
    }

    private static void logStart(@NotNull StylelintSessionData sessionData, @NotNull String commandLine) {
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(27);
        }
        if (commandLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(28);
        }
        String stylelintVersion = sessionData.getStylelintPackage().getVersionStr();
        String fileToLintPath = sessionData.getFileToLint().getPath();
        LOG.debug(String.format("Running stylelint@%s at %s$ %s", stylelintVersion, fileToLintPath, commandLine));
    }

    private static void logEnd(long startTime, int resultSize) {
        long durationMillis = TimeoutUtil.getDurationMillis((long)startTime);
        LOG.debug(String.format(StylelintBundle.message("stylelint.error.prefix", new Object[0]) + " done in %d ms, found %d problems", durationMillis, resultSize));
    }

    private static /* synthetic */ ProcessWithCmdLine lambda$runProcess$2(JSLinterInput input, StylelintSessionData sessionData) throws ExecutionException {
        return StylelintExternalRunner.startProcess(input.getProject(), sessionData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 15, 17, 21, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintExternalRunner";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processWithCmdLine";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintExternalRunner";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "captureOutput";
                break;
            }
            case 21: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLevelWarning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestSyntax";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stylelint";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 21: 
            case 26: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeFileContentToStdin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "captureOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "supportStdinClosing";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFileLevelWarning";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "logStart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 15, 17, 21, 26 -> new IllegalStateException(string);
        };
    }
}

