{{-- layout extend --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','App Email')

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/quill/quill.snow.css')}}">
@endsection

{{-- page styles --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/app-sidebar.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/app-email-content.css')}}">
@endsection

{{-- main page content --}}
@section('content')
<!-- Sidebar Area Starts -->
<div class="sidebar-left sidebar-fixed">
  <div class="sidebar">
    <div class="sidebar-content">
      <div class="sidebar-header">
        <div class="sidebar-details">
          <h5 class="m-0 sidebar-title"><i class="material-icons app-header-icon text-top">mail_outline</i> Mailbox</h5>
          <div class="row valign-wrapper mt-10 pt-2">
            <div class="col s3 media-image">
              <img src="{{asset('images/user/2.jpg')}}" alt="" class="circle z-depth-2 responsive-img">
              <!-- notice the "circle" class -->
            </div>
            <div class="col s9">
              <p class="m-0 subtitle font-weight-700">Lawrence Collins</p>
              <p class="m-0 text-muted">lawrence.collins@xyz.com</p>
            </div>
          </div>
        </div>
      </div>
      <div id="sidebar-list" class="sidebar-menu list-group position-relative">
        <div class="sidebar-list-padding app-sidebar sidenav" id="email-sidenav">
          <ul class="email-list display-grid">
            <li class="sidebar-title">Folders</li>
            <li class="active">
              <a href="javascript:void(0)" class="text-sub">
                <i class="material-icons mr-2">mail_outline </i>
                Inbox
              </a>
            </li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> send </i> Sent</a></li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> description </i> Draft</a>
            </li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> info_outline </i> Span</a>
            </li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> delete </i> Trash</a></li>
            <li class="sidebar-title">Filters</li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> star_border </i>
                Starred</a></li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="material-icons mr-2"> label_outline </i>
                Important</a></li>
            <li class="sidebar-title">Labels</li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="purple-text material-icons small-icons mr-2">
                  fiber_manual_record </i> Note</a></li>
            <li><a href="javascript:void(0)" class="text-sub"><i class="amber-text material-icons small-icons mr-2">
                  fiber_manual_record </i> Paypal</a></li>
            <li><a href="javascript:void(0)" class="text-sub"><i
                  class="light-green-text material-icons small-icons mr-2">
                  fiber_manual_record </i> Invoice</a></li>
          </ul>
        </div>
      </div>
      <a href="#" data-target="email-sidenav" class="sidenav-trigger hide-on-large-only"><i
          class="material-icons">menu</i></a>
    </div>
  </div>
</div>
<!-- Sidebar Area Ends -->
<!-- Content Area Starts -->
<div class="app-email-content">
  <div class="content-area content-right">
    <div class="app-wrapper">
      <div class="app-search">
        <i class="material-icons mr-2 search-icon">search</i>
        <input type="text" placeholder="Search Mail" class="app-filter" id="email_filter">
      </div>
      <div class="card card-default scrollspy border-radius-6 fixed-width">
        <div class="card-content pt-0">
          <div class="row">
            <div class="col s12">
              <!-- Email Header -->
              <div class="email-header">
                <div class="subject">
                  <div class="back-to-mails">
                    <a href="{{asset('app-email')}}"><i class="material-icons">arrow_back</i></a>
                  </div>
                  <div class="email-title">Fruitcake sweet jelly-o sweet ice cream donut ice cream</div>
                </div>
                <div class="header-action">
                  <span class="badge grey lighten-2"><i class="amber-text material-icons small-icons mr-2">
                      fiber_manual_record </i>Paypal</span>
                  <div class="favorite">
                    <i class="material-icons">star_border</i>
                  </div>
                  <div class="email-label">
                    <i class="material-icons">label_outline</i>
                  </div>
                </div>
              </div>
              <!-- Email Header Ends -->
              <hr>
              <!-- Email Content -->
              <div class="email-content">
                <div class="list-title-area">
                  <div class="user-media">
                    <img src="{{asset('images/user/9.jpg')}}" alt="" class="circle z-depth-2 responsive-img avtar">
                    <div class="list-title">
                      <span class="name">Pari Kalin</span>
                      <span class="to-person">to me</span>
                    </div>
                  </div>
                  <div class="title-right">
                    <span class="mail-time">Fri, Jan 11, 9:01 AM(4 days ago)</span>
                    <i class="material-icons">reply</i>
                    <i class="material-icons">more_vert</i>
                  </div>
                </div>
                <div class="email-desc">
                  <p>Fruitcake lemon drops jelly-o marshmallow cake dragée. Pie pudding cookie candy canes chocolate
                    bar. Cookie cheesecake carrot cake jelly-o jelly cupcake. Sweet roll icing dragée croissant tart
                    marshmallow icing marshmallow. Sweet roll jujubes cheesecake. Soufflé croissant bear claw
                    marshmallow macaroon sweet. <strong>Sweet roll</strong> macaroon topping cake jelly-o halvah chupa
                    chups.</p>
                  <p>Lollipop carrot cake gummies. Croissant lemon drops cotton candy. Candy canes sesame snaps
                    macaroon pie pie fruitcake cupcake danish marshmallow. Topping jelly donut liquorice oat cake sugar
                    plum cake dragée. Sweet cheesecake marshmallow. Gummies brownie lemon drops marshmallow oat cake
                    bear claw pudding.</p>
                </div>
              </div>
              <!-- Email Content Ends -->
              <hr>
              <!-- Email Footer -->
              <div class="email-footer">
                <h6 class="footer-title">Attachments (3)</h6>
                <div class="footer-action">
                  <div class="attachment-list">
                    <div class="attachment">
                      <img src="{{asset('images/gallery/35.png')}}" alt="" class="responsive-img attached-image">
                      <div class="size">
                        <span class="grey-text">(0.75Mb)</span>
                      </div>
                      <div class="links">
                        <a href="#" class="left">
                          <i class="material-icons">remove_red_eye</i>
                        </a>
                        <a href="#" class="Right">
                          <i class="material-icons">file_download</i>
                        </a>
                      </div>
                    </div>
                    <div class="attachment">
                      <img src="{{asset('images/gallery/36.png')}}" alt="" class="responsive-img attached-image">
                      <div class="size">
                        <span class="grey-text">(1Mb)</span>
                      </div>
                      <div class="links">
                        <a href="#" class="left">
                          <i class="material-icons">remove_red_eye</i>
                        </a>
                        <a href="#" class="Right">
                          <i class="material-icons">file_download</i>
                        </a>
                      </div>
                    </div>
                    <div class="attachment">
                      <img src="{{asset('images/gallery/39.png')}}" alt="" class="responsive-img attached-image">
                      <div class="size">
                        <span class="grey-text">(1.2Mb)</span>
                      </div>
                      <div class="links">
                        <a href="#" class="left">
                          <i class="material-icons">remove_red_eye</i>
                        </a>
                        <a href="#" class="Right">
                          <i class="material-icons">file_download</i>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="footer-buttons">
                    <a class="btn reply mb-1"><i class="material-icons left">reply</i><span>Reply</span></a>
                    <a class="btn forward mb-1"><i class="material-icons left">reply</i><span>Forward</span></a>
                  </div>
                </div>
                <div class="reply-box d-none">
                  <form action="#">
                    <div class="input-field col s12">
                      <div class="snow-container mt-2">
                        <div class="compose-editor"></div>
                        <div class="compose-quill-toolbar">
                          <span class="ql-formats mr-0">
                            <button class="ql-bold"></button>
                            <button class="ql-italic"></button>
                            <button class="ql-underline"></button>
                            <button class="ql-link"></button>
                            <button class="ql-image"></button>
                          </span>
                        </div>
                      </div>
                    </div>
                    <div class="input-field col s12">
                      <a class="btn reply-btn right">Reply</a>
                    </div>
                  </form>
                </div>
                <div class="forward-box d-none">
                  <hr>
                  <form action="#">
                    <div class="input-field col s12">
                      <i class="material-icons prefix"> person_outline </i>
                      <input id="email" type="email" class="validate">
                      <label for="email">To</label>
                    </div>
                    <div class="input-field col s12">
                      <i class="material-icons prefix"> title </i>
                      <input id="subject" type="text" class="validate">
                      <label for="subject">Subject</label>
                    </div>
                    <div class="input-field col s12">
                      <div class="snow-container mt-2">
                        <div class="forward-email"></div>
                        <div class="forward-email-toolbar">
                          <span class="ql-formats mr-0">
                            <button class="ql-bold"></button>
                            <button class="ql-italic"></button>
                            <button class="ql-underline"></button>
                            <button class="ql-link"></button>
                            <button class="ql-image"></button>
                          </span>
                        </div>
                      </div>
                    </div>
                    <div class="input-field col s12">
                      <a class="btn forward-btn right">Forward</a>
                    </div>
                  </form>
                </div>
              </div>
              <!-- Email Footer Ends -->
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Content Area Ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/quill/quill.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/app-email-content.js')}}"></script>
@endsection